/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.reader.DxfColors;
import java.awt.Color;

public class DxfColorModel
implements DxfColors {
    protected static final int NORMAL_COLORS = 0;
    protected static final int SWAP_BW_COLORS = 1;
    protected static final int MONO_COLORS = 2;
    protected static DxfColorModel normalColors = new DxfColorModel(0);
    protected static DxfColorModel swapBWColors = new DxfColorModel(1);
    protected static DxfColorModel monoColors = new DxfColorModel(2);
    protected int colorSetType;
    protected Color[] colorArray = new Color[256];

    public static DxfColorModel getNormalColors() {
        return normalColors;
    }

    public static DxfColorModel getSwappedBWColors() {
        return swapBWColors;
    }

    public static DxfColorModel getMonochromeColors() {
        return monoColors;
    }

    private DxfColorModel(int type) {
        this.colorSetType = type;
        switch (this.colorSetType) {
            case 0: {
                this.colorArray[0] = Color.black;
                break;
            }
            case 1: {
                this.colorArray[0] = Color.white;
                this.colorArray[7] = Color.black;
                break;
            }
            case 2: {
                this.colorArray[0] = Color.white;
                int c = 1;
                while (c < this.colorArray.length) {
                    this.colorArray[c] = Color.black;
                    ++c;
                }
                break;
            }
        }
    }

    private DxfColorModel(Color bgColor) {
        this(0.3f * (float)bgColor.getRed() / 255.0f + 0.53f * (float)bgColor.getGreen() / 255.0f + 0.17f * (float)bgColor.getBlue() / 255.0f > 0.5f ? 1 : 0);
        this.colorArray[0] = bgColor;
    }

    public Color getColor(short nr) {
        if (nr < 1 || nr > 255) {
            nr = (short)7;
        }
        if (this.colorArray[nr] == null) {
            this.colorArray[nr] = new Color(DxfColors.red[nr], DxfColors.green[nr], DxfColors.blue[nr]);
        }
        return this.colorArray[nr];
    }

    public Color getBackgroundColor() {
        return this.colorArray[0];
    }
}

