/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSparseImageMemoryRequirements2;

public class VkSparseImageMemoryRequirements2KHR
extends VkSparseImageMemoryRequirements2 {
    public VkSparseImageMemoryRequirements2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSparseImageMemoryRequirements2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR pNext(@NativeType(value="void *") long value) {
        VkSparseImageMemoryRequirements2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSparseImageMemoryRequirements2KHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSparseImageMemoryRequirements2KHR set(VkSparseImageMemoryRequirements2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryRequirements2KHR malloc() {
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR calloc() {
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSparseImageMemoryRequirements2KHR create(long address) {
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)address);
    }

    @Nullable
    public static VkSparseImageMemoryRequirements2KHR createSafe(long address) {
        return address == 0L ? null : (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSparseImageMemoryRequirements2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryRequirements2KHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSparseImageMemoryRequirements2KHR mallocStack() {
        return VkSparseImageMemoryRequirements2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements2KHR callocStack() {
        return VkSparseImageMemoryRequirements2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryRequirements2KHR mallocStack(MemoryStack stack) {
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2KHR callocStack(MemoryStack stack) {
        return (VkSparseImageMemoryRequirements2KHR)VkSparseImageMemoryRequirements2KHR.wrap(VkSparseImageMemoryRequirements2KHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryRequirements2KHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkSparseImageMemoryRequirements2.Buffer {
        private static final VkSparseImageMemoryRequirements2KHR ELEMENT_FACTORY = VkSparseImageMemoryRequirements2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSparseImageMemoryRequirements2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSparseImageMemoryRequirements2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSparseImageMemoryRequirements2KHR.npNext(this.address(), value);
            return this;
        }
    }
}

