/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageMemoryBind;

public class VkSparseImageMemoryBindInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    public VkSparseImageMemoryBindInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSparseImageMemoryBindInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkSparseImageMemoryBindInfo.nimage(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseImageMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseImageMemoryBind const *")
    public VkSparseImageMemoryBind.Buffer pBinds() {
        return VkSparseImageMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseImageMemoryBindInfo image(@NativeType(value="VkImage") long value) {
        VkSparseImageMemoryBindInfo.nimage(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo pBinds(@NativeType(value="VkSparseImageMemoryBind const *") VkSparseImageMemoryBind.Buffer value) {
        VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(long image, VkSparseImageMemoryBind.Buffer pBinds) {
        this.image(image);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(VkSparseImageMemoryBindInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryBindInfo malloc() {
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo calloc() {
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSparseImageMemoryBindInfo create(long address) {
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)address);
    }

    @Nullable
    public static VkSparseImageMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSparseImageMemoryBindInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryBindInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSparseImageMemoryBindInfo mallocStack() {
        return VkSparseImageMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBindInfo callocStack() {
        return VkSparseImageMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageMemoryBindInfo mallocStack(MemoryStack stack) {
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryBindInfo callocStack(MemoryStack stack) {
        return (VkSparseImageMemoryBindInfo)VkSparseImageMemoryBindInfo.wrap(VkSparseImageMemoryBindInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryBindInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static int nbindCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDCOUNT);
    }

    public static VkSparseImageMemoryBind.Buffer npBinds(long struct) {
        return VkSparseImageMemoryBind.create(MemoryUtil.memGetAddress((long)(struct + (long)PBINDS)), VkSparseImageMemoryBindInfo.nbindCount(struct));
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    public static void nbindCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseImageMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBINDS), (long)value.address());
        VkSparseImageMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PBINDS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseImageMemoryBindInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryBindInfo.__struct((Struct.Member[])new Struct.Member[]{VkSparseImageMemoryBindInfo.__member((int)8), VkSparseImageMemoryBindInfo.__member((int)4), VkSparseImageMemoryBindInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryBindInfo, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryBindInfo ELEMENT_FACTORY = VkSparseImageMemoryBindInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSparseImageMemoryBindInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkSparseImageMemoryBindInfo.nimage(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseImageMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseImageMemoryBind const *")
        public VkSparseImageMemoryBind.Buffer pBinds() {
            return VkSparseImageMemoryBindInfo.npBinds(this.address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkSparseImageMemoryBindInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseImageMemoryBind const *") VkSparseImageMemoryBind.Buffer value) {
            VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

