/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfo;

public class VkRenderPassMultiviewCreateInfoKHR
extends VkRenderPassMultiviewCreateInfo {
    public VkRenderPassMultiviewCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHR set(VkRenderPassMultiviewCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc() {
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc() {
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderPassMultiviewCreateInfoKHR create(long address) {
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkRenderPassMultiviewCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderPassMultiviewCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassMultiviewCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRenderPassMultiviewCreateInfoKHR mallocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHR callocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkRenderPassMultiviewCreateInfoKHR)VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkRenderPassMultiviewCreateInfo.Buffer {
        private static final VkRenderPassMultiviewCreateInfoKHR ELEMENT_FACTORY = VkRenderPassMultiviewCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderPassMultiviewCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

