/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageMemoryRequirementsInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;

    public VkImageMemoryRequirementsInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageMemoryRequirementsInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageMemoryRequirementsInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageMemoryRequirementsInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageMemoryRequirementsInfo2.nimage(this.address());
    }

    public VkImageMemoryRequirementsInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 image(@NativeType(value="VkImage") long value) {
        VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(int sType, long pNext, long image) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(VkImageMemoryRequirementsInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageMemoryRequirementsInfo2 malloc() {
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 calloc() {
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageMemoryRequirementsInfo2 create(long address) {
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)address);
    }

    @Nullable
    public static VkImageMemoryRequirementsInfo2 createSafe(long address) {
        return address == 0L ? null : (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageMemoryRequirementsInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageMemoryRequirementsInfo2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageMemoryRequirementsInfo2 mallocStack() {
        return VkImageMemoryRequirementsInfo2.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2 callocStack() {
        return VkImageMemoryRequirementsInfo2.callocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2 mallocStack(MemoryStack stack) {
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2 callocStack(MemoryStack stack) {
        return (VkImageMemoryRequirementsInfo2)VkImageMemoryRequirementsInfo2.wrap(VkImageMemoryRequirementsInfo2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageMemoryRequirementsInfo2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    static {
        Struct.Layout layout = VkImageMemoryRequirementsInfo2.__struct((Struct.Member[])new Struct.Member[]{VkImageMemoryRequirementsInfo2.__member((int)4), VkImageMemoryRequirementsInfo2.__member((int)POINTER_SIZE), VkImageMemoryRequirementsInfo2.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryRequirementsInfo2, Buffer>
    implements NativeResource {
        private static final VkImageMemoryRequirementsInfo2 ELEMENT_FACTORY = VkImageMemoryRequirementsInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageMemoryRequirementsInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageMemoryRequirementsInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageMemoryRequirementsInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageMemoryRequirementsInfo2.nimage(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
            return this;
        }
    }
}

