/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndirectCommand
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTVERTEX;
    public static final int FIRSTINSTANCE;

    public VkDrawIndirectCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDrawIndirectCommand.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return VkDrawIndirectCommand.nvertexCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkDrawIndirectCommand.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstVertex() {
        return VkDrawIndirectCommand.nfirstVertex(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstInstance() {
        return VkDrawIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndirectCommand vertexCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nvertexCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand instanceCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstVertex(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nfirstVertex(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstInstance(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand set(int vertexCount, int instanceCount, int firstVertex, int firstInstance) {
        this.vertexCount(vertexCount);
        this.instanceCount(instanceCount);
        this.firstVertex(firstVertex);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndirectCommand set(VkDrawIndirectCommand src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDrawIndirectCommand malloc() {
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDrawIndirectCommand calloc() {
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDrawIndirectCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDrawIndirectCommand create(long address) {
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)address);
    }

    @Nullable
    public static VkDrawIndirectCommand createSafe(long address) {
        return address == 0L ? null : (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDrawIndirectCommand.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDrawIndirectCommand.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDrawIndirectCommand mallocStack() {
        return VkDrawIndirectCommand.mallocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndirectCommand callocStack() {
        return VkDrawIndirectCommand.callocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndirectCommand mallocStack(MemoryStack stack) {
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDrawIndirectCommand callocStack(MemoryStack stack) {
        return (VkDrawIndirectCommand)VkDrawIndirectCommand.wrap(VkDrawIndirectCommand.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDrawIndirectCommand.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDrawIndirectCommand.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDrawIndirectCommand.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nvertexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNT);
    }

    public static int ninstanceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INSTANCECOUNT);
    }

    public static int nfirstVertex(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTVERTEX);
    }

    public static int nfirstInstance(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTINSTANCE);
    }

    public static void nvertexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNT, value);
    }

    public static void ninstanceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INSTANCECOUNT, value);
    }

    public static void nfirstVertex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTVERTEX, value);
    }

    public static void nfirstInstance(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTINSTANCE, value);
    }

    static {
        Struct.Layout layout = VkDrawIndirectCommand.__struct((Struct.Member[])new Struct.Member[]{VkDrawIndirectCommand.__member((int)4), VkDrawIndirectCommand.__member((int)4), VkDrawIndirectCommand.__member((int)4), VkDrawIndirectCommand.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTVERTEX = layout.offsetof(2);
        FIRSTINSTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndirectCommand, Buffer>
    implements NativeResource {
        private static final VkDrawIndirectCommand ELEMENT_FACTORY = VkDrawIndirectCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDrawIndirectCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return VkDrawIndirectCommand.nvertexCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkDrawIndirectCommand.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstVertex() {
            return VkDrawIndirectCommand.nfirstVertex(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstInstance() {
            return VkDrawIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer vertexCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nvertexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstVertex(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nfirstVertex(this.address(), value);
            return this;
        }

        public Buffer firstInstance(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

