/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferDeviceAddressInfo;

public class VkBufferDeviceAddressInfoKHR
extends VkBufferDeviceAddressInfo {
    public VkBufferDeviceAddressInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferDeviceAddressInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfoKHR set(VkBufferDeviceAddressInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfoKHR malloc() {
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfoKHR calloc() {
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferDeviceAddressInfoKHR create(long address) {
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkBufferDeviceAddressInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferDeviceAddressInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferDeviceAddressInfoKHR mallocStack() {
        return VkBufferDeviceAddressInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfoKHR callocStack() {
        return VkBufferDeviceAddressInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfoKHR mallocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferDeviceAddressInfoKHR callocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfoKHR)VkBufferDeviceAddressInfoKHR.wrap(VkBufferDeviceAddressInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferDeviceAddressInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferDeviceAddressInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkBufferDeviceAddressInfo.Buffer {
        private static final VkBufferDeviceAddressInfoKHR ELEMENT_FACTORY = VkBufferDeviceAddressInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferDeviceAddressInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfoKHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

