/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOpInfoCallbackI;
import org.lwjgl.llvm.LLVMSymbolLookupCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class LLVMDisassembler {
    public static final int LLVMDisassembler_VariantKind_None = 0;
    public static final int LLVMDisassembler_VariantKind_ARM_HI16 = 1;
    public static final int LLVMDisassembler_VariantKind_ARM_LO16 = 2;
    public static final int LLVMDisassembler_VariantKind_ARM64_PAGE = 1;
    public static final int LLVMDisassembler_VariantKind_ARM64_PAGEOFF = 2;
    public static final int LLVMDisassembler_VariantKind_ARM64_GOTPAGE = 3;
    public static final int LLVMDisassembler_VariantKind_ARM64_GOTPAGEOFF = 4;
    public static final int LLVMDisassembler_VariantKind_ARM64_TLVP = 5;
    public static final int LLVMDisassembler_VariantKind_ARM64_TLVOFF = 6;
    public static final int LLVMDisassembler_ReferenceType_InOut_None = 0;
    public static final int LLVMDisassembler_ReferenceType_In_Branch = 1;
    public static final int LLVMDisassembler_ReferenceType_In_PCrel_Load = 2;
    public static final int LLVMDisassembler_ReferenceType_Out_SymbolStub = 1;
    public static final int LLVMDisassembler_ReferenceType_Out_LitPool_SymAddr = 2;
    public static final int LLVMDisassembler_ReferenceType_Out_LitPool_CstrAddr = 3;
    public static final int LLVMDisassembler_ReferenceType_Out_Objc_CFString_Ref = 4;
    public static final int LLVMDisassembler_ReferenceType_Out_Objc_Message = 5;
    public static final int LLVMDisassembler_ReferenceType_Out_Objc_Message_Ref = 6;
    public static final int LLVMDisassembler_ReferenceType_Out_Objc_Selector_Ref = 7;
    public static final int LLVMDisassembler_ReferenceType_Out_Objc_Class_Ref = 8;
    public static final int LLVMDisassembler_ReferenceType_DeMangled_Name = 9;
    public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADRP = 0x100000001L;
    public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADDXri = 0x100000002L;
    public static final long LLVMDisassembler_ReferenceType_In_ARM64_LDRXui = 0x100000003L;
    public static final long LLVMDisassembler_ReferenceType_In_ARM64_LDRXl = 0x100000004L;
    public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADR = 0x100000005L;
    public static final int LLVMDisassembler_Option_UseMarkup = 1;
    public static final int LLVMDisassembler_Option_PrintImmHex = 2;
    public static final int LLVMDisassembler_Option_AsmPrinterVariant = 4;
    public static final int LLVMDisassembler_Option_SetInstrComments = 8;
    public static final int LLVMDisassembler_Option_PrintLatency = 16;

    protected LLVMDisassembler() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMCreateDisasm(long TripleName, long DisInfo, int TagType, long GetOpInfo, long SymbolLookUp) {
        long __functionAddress = Functions.CreateDisasm;
        return JNI.invokePPPPP((long)TripleName, (long)DisInfo, (int)TagType, (long)GetOpInfo, (long)SymbolLookUp, (long)__functionAddress);
    }

    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasm(@NativeType(value="char const *") ByteBuffer TripleName, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)TripleName);
        }
        return LLVMDisassembler.nLLVMCreateDisasm(MemoryUtil.memAddress((ByteBuffer)TripleName), DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasm(@NativeType(value="char const *") CharSequence TripleName, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TripleName, true);
            long TripleNameEncoded = stack.getPointerAddress();
            long l = LLVMDisassembler.nLLVMCreateDisasm(TripleNameEncoded, DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCreateDisasmCPU(long Triple, long CPU, long DisInfo, int TagType, long GetOpInfo, long SymbolLookUp) {
        long __functionAddress = Functions.CreateDisasmCPU;
        return JNI.invokePPPPPP((long)Triple, (long)CPU, (long)DisInfo, (int)TagType, (long)GetOpInfo, (long)SymbolLookUp, (long)__functionAddress);
    }

    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasmCPU(@NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="char const *") ByteBuffer CPU, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Triple);
            Checks.checkNT1((ByteBuffer)CPU);
        }
        return LLVMDisassembler.nLLVMCreateDisasmCPU(MemoryUtil.memAddress((ByteBuffer)Triple), MemoryUtil.memAddress((ByteBuffer)CPU), DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasmCPU(@NativeType(value="char const *") CharSequence Triple, @NativeType(value="char const *") CharSequence CPU, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            stack.nUTF8(CPU, true);
            long CPUEncoded = stack.getPointerAddress();
            long l = LLVMDisassembler.nLLVMCreateDisasmCPU(TripleEncoded, CPUEncoded, DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCreateDisasmCPUFeatures(long Triple, long CPU, long Features, long DisInfo, int TagType, long GetOpInfo, long SymbolLookUp) {
        long __functionAddress = Functions.CreateDisasmCPUFeatures;
        return JNI.invokePPPPPPP((long)Triple, (long)CPU, (long)Features, (long)DisInfo, (int)TagType, (long)GetOpInfo, (long)SymbolLookUp, (long)__functionAddress);
    }

    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasmCPUFeatures(@NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="char const *") ByteBuffer CPU, @NativeType(value="char const *") ByteBuffer Features, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Triple);
            Checks.checkNT1((ByteBuffer)CPU);
            Checks.checkNT1((ByteBuffer)Features);
        }
        return LLVMDisassembler.nLLVMCreateDisasmCPUFeatures(MemoryUtil.memAddress((ByteBuffer)Triple), MemoryUtil.memAddress((ByteBuffer)CPU), MemoryUtil.memAddress((ByteBuffer)Features), DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMDisasmContextRef")
    public static long LLVMCreateDisasmCPUFeatures(@NativeType(value="char const *") CharSequence Triple, @NativeType(value="char const *") CharSequence CPU, @NativeType(value="char const *") CharSequence Features, @NativeType(value="void *") long DisInfo, int TagType, @Nullable @NativeType(value="int (*) (void *, uint64_t, uint64_t, uint64_t, int, void *)") LLVMOpInfoCallbackI GetOpInfo, @Nullable @NativeType(value="char const * (*) (void *, uint64_t, uint64_t *, uint64_t, char const **)") LLVMSymbolLookupCallbackI SymbolLookUp) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            stack.nUTF8(CPU, true);
            long CPUEncoded = stack.getPointerAddress();
            stack.nUTF8(Features, true);
            long FeaturesEncoded = stack.getPointerAddress();
            long l = LLVMDisassembler.nLLVMCreateDisasmCPUFeatures(TripleEncoded, CPUEncoded, FeaturesEncoded, DisInfo, TagType, MemoryUtil.memAddressSafe((Pointer)GetOpInfo), MemoryUtil.memAddressSafe((Pointer)SymbolLookUp));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int LLVMSetDisasmOptions(@NativeType(value="LLVMDisasmContextRef") long DC, @NativeType(value="uint64_t") long Options) {
        long __functionAddress = Functions.SetDisasmOptions;
        if (Checks.CHECKS) {
            Checks.check((long)DC);
        }
        return JNI.invokePJI((long)DC, (long)Options, (long)__functionAddress);
    }

    public static void LLVMDisasmDispose(@NativeType(value="LLVMDisasmContextRef") long DC) {
        long __functionAddress = Functions.DisasmDispose;
        if (Checks.CHECKS) {
            Checks.check((long)DC);
        }
        JNI.invokePV((long)DC, (long)__functionAddress);
    }

    public static long nLLVMDisasmInstruction(long DC, long Bytes, long BytesSize, long PC, long OutString, long OutStringSize) {
        long __functionAddress = Functions.DisasmInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)DC);
        }
        return JNI.invokePPJJPPP((long)DC, (long)Bytes, (long)BytesSize, (long)PC, (long)OutString, (long)OutStringSize, (long)__functionAddress);
    }

    @NativeType(value="size_t")
    public static long LLVMDisasmInstruction(@NativeType(value="LLVMDisasmContextRef") long DC, @NativeType(value="uint8_t *") ByteBuffer Bytes, @NativeType(value="uint64_t") long PC, @NativeType(value="char *") ByteBuffer OutString) {
        return LLVMDisassembler.nLLVMDisasmInstruction(DC, MemoryUtil.memAddress((ByteBuffer)Bytes), Bytes.remaining(), PC, MemoryUtil.memAddress((ByteBuffer)OutString), OutString.remaining());
    }

    public static final class Functions {
        public static final long CreateDisasm = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateDisasm");
        public static final long CreateDisasmCPU = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateDisasmCPU");
        public static final long CreateDisasmCPUFeatures = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateDisasmCPUFeatures");
        public static final long SetDisasmOptions = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetDisasmOptions");
        public static final long DisasmDispose = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisasmDispose");
        public static final long DisasmInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisasmInstruction");

        private Functions() {
        }
    }
}

