/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rpmalloc_global_statistics_t")
public class RPmallocGlobalStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPPED;
    public static final int MAPPED_PEAK;
    public static final int CACHED;
    public static final int HUGE_ALLOC;
    public static final int HUGE_ALLOC_PEAK;
    public static final int MAPPED_TOTAL;
    public static final int UNMAPPED_TOTAL;

    public RPmallocGlobalStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RPmallocGlobalStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mapped() {
        return RPmallocGlobalStatistics.nmapped(this.address());
    }

    @NativeType(value="size_t")
    public long mapped_peak() {
        return RPmallocGlobalStatistics.nmapped_peak(this.address());
    }

    @NativeType(value="size_t")
    public long cached() {
        return RPmallocGlobalStatistics.ncached(this.address());
    }

    @NativeType(value="size_t")
    public long huge_alloc() {
        return RPmallocGlobalStatistics.nhuge_alloc(this.address());
    }

    @NativeType(value="size_t")
    public long huge_alloc_peak() {
        return RPmallocGlobalStatistics.nhuge_alloc_peak(this.address());
    }

    @NativeType(value="size_t")
    public long mapped_total() {
        return RPmallocGlobalStatistics.nmapped_total(this.address());
    }

    @NativeType(value="size_t")
    public long unmapped_total() {
        return RPmallocGlobalStatistics.nunmapped_total(this.address());
    }

    public static RPmallocGlobalStatistics malloc() {
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static RPmallocGlobalStatistics calloc() {
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static RPmallocGlobalStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static RPmallocGlobalStatistics create(long address) {
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)address);
    }

    @Nullable
    public static RPmallocGlobalStatistics createSafe(long address) {
        return address == 0L ? null : (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)RPmallocGlobalStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RPmallocGlobalStatistics.__create((int)capacity, (int)SIZEOF);
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static RPmallocGlobalStatistics mallocStack() {
        return RPmallocGlobalStatistics.mallocStack(MemoryStack.stackGet());
    }

    public static RPmallocGlobalStatistics callocStack() {
        return RPmallocGlobalStatistics.callocStack(MemoryStack.stackGet());
    }

    public static RPmallocGlobalStatistics mallocStack(MemoryStack stack) {
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RPmallocGlobalStatistics callocStack(MemoryStack stack) {
        return (RPmallocGlobalStatistics)RPmallocGlobalStatistics.wrap(RPmallocGlobalStatistics.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RPmallocGlobalStatistics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RPmallocGlobalStatistics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)RPmallocGlobalStatistics.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nmapped(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MAPPED));
    }

    public static long nmapped_peak(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MAPPED_PEAK));
    }

    public static long ncached(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CACHED));
    }

    public static long nhuge_alloc(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HUGE_ALLOC));
    }

    public static long nhuge_alloc_peak(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HUGE_ALLOC_PEAK));
    }

    public static long nmapped_total(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MAPPED_TOTAL));
    }

    public static long nunmapped_total(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)UNMAPPED_TOTAL));
    }

    static {
        Struct.Layout layout = RPmallocGlobalStatistics.__struct((Struct.Member[])new Struct.Member[]{RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE), RPmallocGlobalStatistics.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPPED = layout.offsetof(0);
        MAPPED_PEAK = layout.offsetof(1);
        CACHED = layout.offsetof(2);
        HUGE_ALLOC = layout.offsetof(3);
        HUGE_ALLOC_PEAK = layout.offsetof(4);
        MAPPED_TOTAL = layout.offsetof(5);
        UNMAPPED_TOTAL = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<RPmallocGlobalStatistics, Buffer>
    implements NativeResource {
        private static final RPmallocGlobalStatistics ELEMENT_FACTORY = RPmallocGlobalStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected RPmallocGlobalStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long mapped() {
            return RPmallocGlobalStatistics.nmapped(this.address());
        }

        @NativeType(value="size_t")
        public long mapped_peak() {
            return RPmallocGlobalStatistics.nmapped_peak(this.address());
        }

        @NativeType(value="size_t")
        public long cached() {
            return RPmallocGlobalStatistics.ncached(this.address());
        }

        @NativeType(value="size_t")
        public long huge_alloc() {
            return RPmallocGlobalStatistics.nhuge_alloc(this.address());
        }

        @NativeType(value="size_t")
        public long huge_alloc_peak() {
            return RPmallocGlobalStatistics.nhuge_alloc_peak(this.address());
        }

        @NativeType(value="size_t")
        public long mapped_total() {
            return RPmallocGlobalStatistics.nmapped_total(this.address());
        }

        @NativeType(value="size_t")
        public long unmapped_total() {
            return RPmallocGlobalStatistics.nunmapped_total(this.address());
        }
    }
}

