/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.Frequency;
import ca.sqlpower.util.OrdinalNumberFormat;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class Recurrence {
    private static Logger logger = Logger.getLogger(Recurrence.class);
    protected Date startDate = new Date();
    protected Date endDate = null;
    protected Frequency frequency = new Frequency(5);
    protected int interval = 1;
    protected boolean byDate = false;
    protected boolean[] day = new boolean[8];

    public String toString() {
        OrdinalNumberFormat ordinalFmt = new OrdinalNumberFormat();
        DateFormatSymbols dfs = new DateFormatSymbols();
        String[] weekdays = dfs.getWeekdays();
        String[] months = dfs.getMonths();
        StringBuffer sb = new StringBuffer();
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(this.startDate);
        sb.append("[Recurrence: every ");
        switch (this.frequency.getFreq()) {
            case 5: {
                sb.append(this.interval > 1 ? this.interval + " days" : "day");
                break;
            }
            case 4: {
                if (this.interval > 1) {
                    sb.append(this.interval + " weeks on ");
                }
                int n = 0;
                for (int d = 1; d <= 7; ++d) {
                    if (!this.isOnDay(d)) continue;
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(weekdays[d]);
                    ++n;
                }
                break;
            }
            case 3: {
                sb.append(this.interval > 1 ? this.interval + " months" : "month");
                if (this.byDate) {
                    int date = startCal.get(5);
                    sb.append(" on the ").append(ordinalFmt.format(date));
                    break;
                }
                int dayInMonth = startCal.get(8);
                sb.append(" on the ").append(ordinalFmt.format(dayInMonth)).append(" ").append(weekdays[startCal.get(7)]);
                break;
            }
            case 1: {
                sb.append(this.interval > 1 ? this.interval + " years" : "year");
                if (this.byDate) {
                    int month = startCal.get(2);
                    int date = startCal.get(5);
                    sb.append(" on ").append(months[month]).append(" ").append(ordinalFmt.format(date));
                    break;
                }
                int month = startCal.get(2);
                int dayInMonth = startCal.get(8);
                sb.append(" on the ").append(ordinalFmt.format(dayInMonth)).append(" ").append(weekdays[startCal.get(7)]).append(" of ").append(months[month]);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported recurrence frequency " + this.frequency);
            }
        }
        sb.append(" at ").append(DateFormat.getTimeInstance().format(this.startDate));
        sb.append(" starting ").append(DateFormat.getDateInstance().format(this.startDate));
        if (this.endDate != null) {
            sb.append(" until ").append(DateFormat.getDateInstance().format(this.endDate));
        }
        sb.append("]");
        return sb.toString();
    }

    public Date[] nextOccurrences(Date baseDate, int n) {
        Date[] retval = new Date[n];
        for (int i = 0; i < n && baseDate != null; ++i) {
            retval[i] = baseDate = this.nextOccurrence(baseDate);
        }
        return retval;
    }

    public Date nextOccurrence() {
        return this.nextOccurrence(new Date());
    }

    public Date nextOccurrence(Date baseDate) {
        logger.debug((Object)("Calc next occurrence from base=" + baseDate + "; start=" + this.startDate + "; end=" + (this.endDate == null ? "never" : this.endDate.toString())));
        if (this.endDate != null && baseDate.after(this.endDate)) {
            return null;
        }
        if (baseDate.before(this.startDate)) {
            return this.startDate;
        }
        GregorianCalendar next = new GregorianCalendar();
        next.setTime(this.startDate);
        switch (this.frequency.getFreq()) {
            default: {
                throw new IllegalStateException("Unsupported recurrence frequency " + this.frequency);
            }
            case 5: {
                long dif = baseDate.getTime() - this.startDate.getTime();
                int days = 1 + (int)(dif / 86400000L);
                logger.debug((Object)("base date is " + days + " days (" + dif + "ms) after start date"));
                if (this.interval > 1) {
                    days = days + this.interval - days % this.interval;
                }
                ((Calendar)next).add(5, days);
                break;
            }
            case 4: {
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(this.startDate);
                start.set(7, 1);
                start.set(10, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                GregorianCalendar base = new GregorianCalendar();
                base.setTime(baseDate);
                long dif = baseDate.getTime() - start.getTime().getTime();
                int weeks = (int)(dif / 604800000L);
                logger.debug((Object)("base date is " + weeks + " weeks (" + dif + "ms) after start date"));
                int w = start.get(3) + weeks;
                int ww = this.interval > 1 && weeks % this.interval != 0 ? start.get(3) + (weeks + this.interval - weeks % this.interval) : w;
                int d = w == ww ? base.get(7) : 1;
                int dd = d;
                do {
                    if (++dd <= 7) continue;
                    dd = 1;
                } while (!this.isOnDay(dd));
                int www = w == ww && dd <= d ? ww + this.interval : ww;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Base week = " + w));
                    logger.debug((Object)("Next Recurrence week = " + ww));
                    logger.debug((Object)("Searching day-of-week starting with " + new DateFormatSymbols().getWeekdays()[d]));
                    logger.debug((Object)("Selected next day-of-week " + new DateFormatSymbols().getWeekdays()[dd]));
                    logger.debug((Object)("Final choice of next week-of-year " + www));
                }
                next.set(7, dd);
                next.set(3, www);
                break;
            }
            case 3: {
                GregorianCalendar base = new GregorianCalendar();
                base.setTime(baseDate);
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(this.startDate);
                int months = this.monthsFromStart(base);
                logger.debug((Object)("months from start to base = " + months));
                if (months % this.interval != 0) {
                    months = months + this.interval - months % this.interval;
                }
                logger.debug((Object)("next occurrence will be " + months + " months after start"));
                next.set(5, 1);
                ((Calendar)next).add(2, months);
                if (this.byDate) {
                    next.set(5, start.get(5));
                    break;
                }
                next.set(7, start.get(7));
                next.set(8, start.get(8));
                break;
            }
            case 1: {
                GregorianCalendar base = new GregorianCalendar();
                base.setTime(baseDate);
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(this.startDate);
                int months = this.monthsFromStart(base);
                logger.debug((Object)("months from start to base = " + months));
                int years = months / 12;
                if (months % 12 != 0) {
                    ++years;
                }
                if (years % this.interval != 0) {
                    years = years + this.interval - years % this.interval;
                }
                logger.debug((Object)("next occurrence will be " + years + " years after start"));
                next.set(5, 1);
                ((Calendar)next).add(1, years);
                if (this.byDate) {
                    next.set(5, start.get(5));
                    break;
                }
                next.set(7, start.get(7));
                next.set(8, start.get(8));
            }
        }
        return next.getTime();
    }

    protected int msSinceMidnight(Calendar cal) {
        int ms = cal.get(14);
        ms += 1000 * cal.get(13);
        ms += 60000 * cal.get(12);
        return ms += 3600000 * cal.get(10);
    }

    public int monthsFromStart(Calendar cal) {
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(this.startDate);
        int months = 12 * (cal.get(1) - start.get(1));
        months += cal.get(2) - start.get(2);
        if (this.byDate) {
            if (start.get(5) < cal.get(5) || start.get(5) == cal.get(5) && this.msSinceMidnight(start) <= this.msSinceMidnight(cal)) {
                ++months;
            }
        } else {
            logger.debug((Object)("start DAY_OF_WEEK_IN_MONTH " + start.get(8) + "; DAY_OF_WEEK " + start.get(7)));
            logger.debug((Object)("cal   DAY_OF_WEEK_IN_MONTH " + cal.get(8) + "; DAY_OF_WEEK " + cal.get(7)));
            if (start.get(8) < cal.get(8) || start.get(8) == cal.get(8) && start.get(7) < cal.get(7) || start.get(7) == cal.get(7) && this.msSinceMidnight(start) <= this.msSinceMidnight(cal)) {
                ++months;
            }
        }
        return months;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date argStartDate) {
        this.startDate = argStartDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date argEndDate) {
        this.endDate = argEndDate;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency argFrequency) {
        this.frequency = argFrequency;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int argInterval) {
        if (argInterval < 1) {
            throw new IllegalArgumentException("Interval must be a positive integer");
        }
        this.interval = argInterval;
    }

    public boolean isByDate() {
        return this.byDate;
    }

    public void setByDate(boolean argByDate) {
        this.byDate = argByDate;
    }

    public boolean isOnDay(int dayNum) {
        if (this.frequency.getFreq() == 4) {
            GregorianCalendar startCal = new GregorianCalendar();
            startCal.setTime(this.startDate);
            return this.day[dayNum] || dayNum == startCal.get(7);
        }
        return false;
    }

    public void setOnDay(int dayNum, boolean v) {
        this.day[dayNum] = v;
    }
}

