/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class CollectedInfo {
    private static final StringManager sm = StringManager.getManager(CollectedInfo.class);
    protected MBeanServer mBeanServer = null;
    protected ObjectName objName = null;
    int ready;
    int busy;
    int port = 0;
    String host = null;

    public CollectedInfo(String host, int port) throws Exception {
        this.init(host, port);
    }

    public void init(String host, int port) throws Exception {
        int iport = 0;
        String shost = null;
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        String onStr = "*:type=ThreadPool,*";
        ObjectName objectName = new ObjectName(onStr);
        Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            this.objName = oi.getObjectName();
            String name = this.objName.getKeyProperty("name");
            String[] elenames = name.split("-");
            String sport = elenames[elenames.length - 1];
            iport = Integer.parseInt(sport);
            String[] shosts = elenames[1].split("%2F");
            shost = shosts[0];
            if (!(port == 0 && host == null || host == null && iport == port) && shost.compareTo(host) != 0) continue;
            break;
        }
        if (this.objName == null) {
            throw new Exception(sm.getString("collectedInfo.noConnector", new Object[]{host, port}));
        }
        this.port = iport;
        this.host = shost;
    }

    public void refresh() throws Exception {
        if (this.mBeanServer == null || this.objName == null) {
            throw new Exception(sm.getString("collectedInfo.notInitialized"));
        }
        Integer imax = (Integer)this.mBeanServer.getAttribute(this.objName, "maxThreads");
        Integer ibusy = (Integer)this.mBeanServer.getAttribute(this.objName, "currentThreadsBusy");
        this.busy = ibusy;
        this.ready = imax - ibusy;
    }
}

