/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.GroovyShell;
import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.sandbox.ui.Completer;

public class ShellCompleter
implements Completer {
    private GroovyShell shell;
    private List completions = new ArrayList();

    public ShellCompleter(GroovyShell shell) {
        this.shell = shell;
    }

    public List findCompletions(String token) {
        this.completions.clear();
        if (token.length() == 0) {
            return this.completions;
        }
        this.findLocalVariables(token);
        this.findShellMethods(token);
        return this.completions;
    }

    private void findShellMethods(String complete) {
        List methods = this.shell.getMetaClass().getMetaMethods();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            MetaMethod method = (MetaMethod)i.next();
            if (!method.getName().startsWith(complete)) continue;
            if (method.getParameterTypes().length > 0) {
                this.completions.add(method.getName() + "(");
                continue;
            }
            this.completions.add(method.getName() + "()");
        }
    }

    private void findLocalVariables(String complete) {
        Set names = this.shell.getContext().getVariables().keySet();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(complete)) continue;
            this.completions.add(name);
        }
    }
}

