/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.CommonSearchDialog;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.CodeUsageInfo;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UsageDialog
extends CommonSearchDialog {
    private static final long serialVersionUID = -5105405789969134105L;
    private final transient JNode node;

    public UsageDialog(MainWindow mainWindow, JNode node) {
        super(mainWindow);
        this.node = node;
        this.initUI();
        this.registerInitOnOpen();
        this.loadWindowPos();
    }

    @Override
    protected void openInit() {
        this.prepare();
    }

    @Override
    protected void loadFinished() {
        this.performSearch();
    }

    @Override
    protected void loadStart() {
    }

    @Override
    protected synchronized void performSearch() {
        this.resultsModel.clear();
        CodeUsageInfo usageInfo = this.cache.getUsageInfo();
        if (usageInfo == null) {
            return;
        }
        this.resultsModel.addAll(usageInfo.getUsageList(this.node));
        this.highlightText = null;
        super.performSearch();
    }

    private void initUI() {
        JLabel lbl = new JLabel(NLS.str("usage_dialog.label", new Object[0]));
        JLabel nodeLabel = new JLabel(this.node.makeLongString(), this.node.getIcon(), 2);
        lbl.setLabelFor(nodeLabel);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new FlowLayout(0));
        searchPane.add(lbl);
        searchPane.add(nodeLabel);
        searchPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)searchPane, "First");
        contentPane.add((Component)resultsPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setTitle(NLS.str("usage_dialog.title", new Object[0]));
        this.pack();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
    }
}

