"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var tooltip_1 = require("../../annotations/tooltip");
var specs_1 = require("../../utils/specs");
var compute_annotations_1 = require("./compute_annotations");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_specs_1 = require("./get_specs");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getAnnotationTooltipStateSelector = re_reselect_1.default([
    getCurrentPointerPosition,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    get_chart_rotation_1.getChartRotationSelector,
    get_specs_1.getAnnotationSpecsSelector,
    get_specs_1.getAxisSpecsSelector,
    compute_annotations_1.computeAnnotationDimensionsSelector,
    get_tooltip_values_highlighted_geoms_1.getTooltipInfoSelector,
], getAnnotationTooltipState)(get_chart_id_1.getChartIdSelector);
function getAnnotationTooltipState(cursorPosition, _a, geometries, chartRotation, annotationSpecs, axesSpecs, annotationDimensions, tooltip) {
    var chartDimensions = _a.chartDimensions;
    if (cursorPosition.x < 0 || cursorPosition.y < 0) {
        return null;
    }
    var _b = geometries.scales, xScale = _b.xScale, yScales = _b.yScales;
    if (!xScale || !yScales) {
        return null;
    }
    var tooltipState = tooltip_1.computeAnnotationTooltipState(cursorPosition, annotationDimensions, annotationSpecs, chartRotation, axesSpecs, chartDimensions);
    var isChartTooltipDisplayed = tooltip.values.some(function (_a) {
        var isHighlighted = _a.isHighlighted;
        return isHighlighted;
    });
    if (tooltipState &&
        tooltipState.isVisible &&
        tooltipState.annotationType === specs_1.AnnotationTypes.Rectangle &&
        isChartTooltipDisplayed) {
        return null;
    }
    return tooltipState;
}
//# sourceMappingURL=get_annotation_tooltip_state.js.map