/* ========================================================================
 * Copyright (c) 2005-2019 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Runtime.Serialization;
using Opc.Ua.Di;
using Opc.Ua;

namespace Opc.Ua.Adi
{
    #region DataType Identifiers
    /// <summary>
    /// A class that declares constants for all DataTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class DataTypes
    {
        /// <summary>
        /// The identifier for the ExecutionCycleEnumeration DataType.
        /// </summary>
        public const uint ExecutionCycleEnumeration = 9378;

        /// <summary>
        /// The identifier for the AcquisitionResultStatusEnumeration DataType.
        /// </summary>
        public const uint AcquisitionResultStatusEnumeration = 3003;

        /// <summary>
        /// The identifier for the AlarmStateEnumeration DataType.
        /// </summary>
        public const uint AlarmStateEnumeration = 3009;
    }
    #endregion

    #region Method Identifiers
    /// <summary>
    /// A class that declares constants for all Methods in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Methods
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Open = 15015;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Close Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Close = 15018;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Read = 15020;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Write Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Write = 15023;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition = 15025;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition Method.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition = 15028;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_InitLock = 9393;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_RenewLock = 9396;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_ExitLock = 9398;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_BreakLock = 9400;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_InitLock = 13098;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_RenewLock = 13101;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_ExitLock = 13103;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_BreakLock = 13105;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GetConfiguration = 9443;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_SetConfiguration = 9445;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GetConfigDataDigest = 9448;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_CompareConfigDataDigest = 9450;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_ResetAllChannels = 9453;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_StartAllChannels = 9454;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_StopAllChannels = 9455;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_AbortAllChannels = 9456;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GotoOperating = 9457;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GotoMaintenance = 9458;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Open = 9467;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Close = 9470;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Read = 9472;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Write = 9475;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_GetPosition = 9477;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_SetPosition = 9480;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_InitLock = 9512;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock = 9515;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock = 9517;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock = 9519;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 9521;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 9522;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 9523;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Reset = 9525;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Start = 9526;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Stop = 9527;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Hold = 9528;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Unhold = 9529;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Suspend = 9530;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 9531;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Abort = 9532;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_Clear = 9533;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock Method.
        /// </summary>
        public const uint AnalyserChannelType_Lock_InitLock = 9690;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RenewLock Method.
        /// </summary>
        public const uint AnalyserChannelType_Lock_RenewLock = 9693;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_ExitLock Method.
        /// </summary>
        public const uint AnalyserChannelType_Lock_ExitLock = 9695;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_BreakLock Method.
        /// </summary>
        public const uint AnalyserChannelType_Lock_BreakLock = 9697;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_GotoOperating = 9699;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_GotoMaintenance = 9700;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_StartSingleAcquisition = 9701;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Reset Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Reset = 9703;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Start Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Start = 9704;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Stop Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Stop = 9705;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Hold Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Hold = 9706;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Unhold Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Unhold = 9707;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Suspend Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Suspend = 9708;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Unsuspend = 9709;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Abort Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Abort = 9710;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Clear Method.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_Clear = 9711;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_InitLock = 9802;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_RenewLock = 9805;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_ExitLock = 9807;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_BreakLock = 9809;

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock Method.
        /// </summary>
        public const uint StreamType_Lock_InitLock = 10330;

        /// <summary>
        /// The identifier for the StreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint StreamType_Lock_RenewLock = 10333;

        /// <summary>
        /// The identifier for the StreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint StreamType_Lock_ExitLock = 10335;

        /// <summary>
        /// The identifier for the StreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint StreamType_Lock_BreakLock = 10337;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_InitLock = 10459;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_RenewLock = 10462;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_ExitLock = 10464;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_BreakLock = 10466;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_InitLock = 10652;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_RenewLock = 10655;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_ExitLock = 10657;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_BreakLock = 10659;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_InitLock = 10781;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_RenewLock = 10784;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_ExitLock = 10786;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_BreakLock = 10788;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_InitLock = 10931;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_RenewLock = 10934;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_ExitLock = 10936;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_BreakLock = 10938;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_InitLock = 11060;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_RenewLock = 11063;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_ExitLock = 11065;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_BreakLock = 11067;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_InitLock = 11189;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_RenewLock = 11192;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_ExitLock = 11194;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_BreakLock = 11196;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_InitLock = 11318;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_RenewLock = 11321;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_ExitLock = 11323;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_BreakLock = 11325;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_InitLock = 13123;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_RenewLock = 13126;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_ExitLock = 13128;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_BreakLock = 13130;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GetConfiguration = 11368;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_SetConfiguration = 11370;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GetConfigDataDigest = 11373;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_CompareConfigDataDigest = 11375;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_ResetAllChannels = 11378;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_StartAllChannels = 11379;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_StopAllChannels = 11380;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_AbortAllChannels = 11381;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GotoOperating = 11382;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GotoMaintenance = 11383;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Open = 11392;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Close = 11395;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Read = 11397;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Write = 11400;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = 11402;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = 11405;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = 11437;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = 11440;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = 11442;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = 11444;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 11446;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 11447;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 11448;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = 11450;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = 11451;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = 11452;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = 11453;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = 11454;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = 11455;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 11456;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = 11457;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = 11458;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_InitLock = 11567;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_RenewLock = 11570;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_ExitLock = 11572;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_BreakLock = 11574;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock = 13148;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock = 13151;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock = 13153;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock = 13155;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration = 11617;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration = 11619;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest = 11622;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest = 11624;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_ResetAllChannels = 11627;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_StartAllChannels = 11628;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_StopAllChannels = 11629;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_AbortAllChannels = 11630;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GotoOperating = 11631;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GotoMaintenance = 11632;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open = 11641;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close = 11644;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read = 11646;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write = 11649;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition = 11651;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition = 11654;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock = 11686;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock = 11689;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock = 11691;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock = 11693;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 11695;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 11696;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 11697;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Reset = 11699;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Start = 11700;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Stop = 11701;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Hold = 11702;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unhold = 11703;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Suspend = 11704;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 11705;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Abort = 11706;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Clear = 11707;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_InitLock = 11813;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_RenewLock = 11816;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_ExitLock = 11818;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_BreakLock = 11820;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_InitLock = 13173;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_RenewLock = 13176;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_ExitLock = 13178;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_BreakLock = 13180;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GetConfiguration = 11863;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_SetConfiguration = 11865;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GetConfigDataDigest = 11868;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_CompareConfigDataDigest = 11870;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_ResetAllChannels = 11873;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_StartAllChannels = 11874;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_StopAllChannels = 11875;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_AbortAllChannels = 11876;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GotoOperating = 11877;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GotoMaintenance = 11878;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Open = 11887;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Close = 11890;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Read = 11892;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Write = 11895;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_GetPosition = 11897;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_SetPosition = 11900;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_InitLock = 11932;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock = 11935;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock = 11937;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock = 11939;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 11941;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 11942;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 11943;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Reset = 11945;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Start = 11946;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Stop = 11947;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Hold = 11948;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Unhold = 11949;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Suspend = 11950;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 11951;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Abort = 11952;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_Clear = 11953;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_InitLock = 12059;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_RenewLock = 12062;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_ExitLock = 12064;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_BreakLock = 12066;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock = 13198;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock = 13201;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock = 13203;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock = 13205;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GetConfiguration = 12109;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_SetConfiguration = 12111;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest = 12114;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest = 12116;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_ResetAllChannels = 12119;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_StartAllChannels = 12120;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_StopAllChannels = 12121;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_AbortAllChannels = 12122;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GotoOperating = 12123;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GotoMaintenance = 12124;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Open = 12133;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Close = 12136;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Read = 12138;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Write = 12141;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = 12143;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = 12146;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = 12178;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = 12181;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = 12183;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = 12185;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 12187;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 12188;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 12189;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = 12191;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = 12192;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = 12193;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = 12194;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = 12195;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = 12196;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 12197;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = 12198;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = 12199;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_InitLock = 12305;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_RenewLock = 12308;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_ExitLock = 12310;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_BreakLock = 12312;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock = 13223;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock = 13226;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock = 13228;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock = 13230;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GetConfiguration = 12355;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_SetConfiguration = 12357;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest = 12360;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest = 12362;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_ResetAllChannels = 12365;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_StartAllChannels = 12366;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_StopAllChannels = 12367;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_AbortAllChannels = 12368;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GotoOperating = 12369;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GotoMaintenance = 12370;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open = 12379;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close = 12382;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read = 12384;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write = 12387;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = 12389;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = 12392;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = 12424;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = 12427;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = 12429;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = 12431;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 12433;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 12434;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 12435;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = 12437;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = 12438;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = 12439;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = 12440;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = 12441;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = 12442;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 12443;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = 12444;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = 12445;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_InitLock Method.
        /// </summary>
        public const uint NMRDeviceType_Lock_InitLock = 12551;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_RenewLock Method.
        /// </summary>
        public const uint NMRDeviceType_Lock_RenewLock = 12554;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_ExitLock Method.
        /// </summary>
        public const uint NMRDeviceType_Lock_ExitLock = 12556;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_BreakLock Method.
        /// </summary>
        public const uint NMRDeviceType_Lock_BreakLock = 12558;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_InitLock = 13248;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_RenewLock = 13251;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_ExitLock = 13253;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_BreakLock = 13255;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GetConfiguration = 12601;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_SetConfiguration = 12603;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GetConfigDataDigest = 12606;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_CompareConfigDataDigest = 12608;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_ResetAllChannels = 12611;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_StartAllChannels = 12612;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_StopAllChannels = 12613;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_AbortAllChannels = 12614;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GotoOperating = 12615;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GotoMaintenance = 12616;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Open = 12625;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Close = 12628;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Read = 12630;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Write = 12633;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_GetPosition = 12635;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_SetPosition = 12638;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_InitLock = 12670;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_RenewLock = 12673;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_ExitLock = 12675;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_BreakLock = 12677;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_GotoOperating = 12679;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = 12680;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = 12681;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Reset = 12683;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Start = 12684;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Stop = 12685;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Hold = 12686;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Unhold = 12687;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Suspend = 12688;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Unsuspend = 12689;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Abort = 12690;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_Clear = 12691;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_InitLock Method.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_InitLock = 12812;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_RenewLock Method.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_RenewLock = 12815;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_ExitLock Method.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_ExitLock = 12817;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_BreakLock Method.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_BreakLock = 12819;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_InitLock Method.
        /// </summary>
        public const uint AccessoryType_Lock_InitLock = 12889;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_RenewLock Method.
        /// </summary>
        public const uint AccessoryType_Lock_RenewLock = 12892;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_ExitLock Method.
        /// </summary>
        public const uint AccessoryType_Lock_ExitLock = 12894;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_BreakLock Method.
        /// </summary>
        public const uint AccessoryType_Lock_BreakLock = 12896;

        /// <summary>
        /// The identifier for the DetectorType_Lock_InitLock Method.
        /// </summary>
        public const uint DetectorType_Lock_InitLock = 12919;

        /// <summary>
        /// The identifier for the DetectorType_Lock_RenewLock Method.
        /// </summary>
        public const uint DetectorType_Lock_RenewLock = 12922;

        /// <summary>
        /// The identifier for the DetectorType_Lock_ExitLock Method.
        /// </summary>
        public const uint DetectorType_Lock_ExitLock = 12924;

        /// <summary>
        /// The identifier for the DetectorType_Lock_BreakLock Method.
        /// </summary>
        public const uint DetectorType_Lock_BreakLock = 12926;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_InitLock Method.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_InitLock = 12949;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_RenewLock Method.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_RenewLock = 12952;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_ExitLock Method.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_ExitLock = 12954;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_BreakLock Method.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_BreakLock = 12956;

        /// <summary>
        /// The identifier for the SourceType_Lock_InitLock Method.
        /// </summary>
        public const uint SourceType_Lock_InitLock = 12979;

        /// <summary>
        /// The identifier for the SourceType_Lock_RenewLock Method.
        /// </summary>
        public const uint SourceType_Lock_RenewLock = 12982;

        /// <summary>
        /// The identifier for the SourceType_Lock_ExitLock Method.
        /// </summary>
        public const uint SourceType_Lock_ExitLock = 12984;

        /// <summary>
        /// The identifier for the SourceType_Lock_BreakLock Method.
        /// </summary>
        public const uint SourceType_Lock_BreakLock = 12986;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_InitLock Method.
        /// </summary>
        public const uint GcOvenType_Lock_InitLock = 13009;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_RenewLock Method.
        /// </summary>
        public const uint GcOvenType_Lock_RenewLock = 13012;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_ExitLock Method.
        /// </summary>
        public const uint GcOvenType_Lock_ExitLock = 13014;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_BreakLock Method.
        /// </summary>
        public const uint GcOvenType_Lock_BreakLock = 13016;
    }
    #endregion

    #region Object Identifiers
    /// <summary>
    /// A class that declares constants for all Objects in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Objects
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata Object.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata = 15001;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet Object.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet = 5001;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet Object.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet = 9382;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Identification Object.
        /// </summary>
        public const uint AnalyserDeviceType_Identification = 9386;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_NetworkAddress = 13107;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData Object.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData = 9462;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Configuration Object.
        /// </summary>
        public const uint AnalyserDeviceType_Configuration = 9482;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Status Object.
        /// </summary>
        public const uint AnalyserDeviceType_Status = 9484;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_FactorySettings Object.
        /// </summary>
        public const uint AnalyserDeviceType_FactorySettings = 9486;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine Object.
        /// </summary>
        public const uint AnalyserDeviceType_AnalyserStateMachine = 9488;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier = 9500;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet = 9503;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Configuration = 9546;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Status = 9548;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine = 9550;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 9562;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 9574;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier Object.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier = 9610;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_SupportedTypes = 9611;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 9614;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Powerup Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Powerup = 9647;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Operating Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Operating = 9649;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Local Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Local = 9651;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Maintenance Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Maintenance = 9653;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Shutdown Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Shutdown = 9655;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_PowerupToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_PowerupToOperatingTransition = 9657;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToLocalTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToLocalTransition = 9659;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition = 9661;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToOperatingTransition = 9663;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToMaintenanceTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToMaintenanceTransition = 9665;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition = 9667;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToLocalTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToLocalTransition = 9669;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToShutdownTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToShutdownTransition = 9671;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToShutdownTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToShutdownTransition = 9673;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition Object.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition = 9675;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet Object.
        /// </summary>
        public const uint AnalyserChannelType_ParameterSet = 9677;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet Object.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet = 9679;

        /// <summary>
        /// The identifier for the AnalyserChannelType_GroupIdentifier Object.
        /// </summary>
        public const uint AnalyserChannelType_GroupIdentifier = 9788;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Configuration Object.
        /// </summary>
        public const uint AnalyserChannelType_Configuration = 9724;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Status Object.
        /// </summary>
        public const uint AnalyserChannelType_Status = 9726;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine = 9728;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine = 9740;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 9752;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier = 9790;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Configuration Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Configuration = 9902;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Status Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Status = 9904;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionSettings Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_AcquisitionSettings = 9906;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionStatus Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_AcquisitionStatus = 9908;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionData Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_AcquisitionData = 9910;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ChemometricModelSettings Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ChemometricModelSettings = 9912;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Context Object.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Context = 9914;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier Object.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier = 9916;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_SupportedTypes = 9917;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine = 9920;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine = 9948;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 9960;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalSubStateMachine = 9972;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceSubStateMachine = 9984;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveMode Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_SlaveMode = 9996;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Operating Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Operating = 9998;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Local Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Local = 10000;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Maintenance Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Maintenance = 10002;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveModeToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_SlaveModeToOperatingTransition = 10004;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToLocalTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToLocalTransition = 10006;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToMaintenanceTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToMaintenanceTransition = 10008;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToOperatingTransition = 10010;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToMaintenanceTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToMaintenanceTransition = 10012;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToOperatingTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToOperatingTransition = 10014;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToLocalTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToLocalTransition = 10016;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToSlaveModeTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToSlaveModeTransition = 10018;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToSlaveModeTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToSlaveModeTransition = 10020;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition Object.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition = 10022;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine = 10036;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopped Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Stopped = 10048;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Resetting Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Resetting = 10050;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Idle Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Idle = 10052;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Starting Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Starting = 10054;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Execute Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Execute = 10056;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Completing Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Completing = 10058;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Complete Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Complete = 10060;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspending Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Suspending = 10062;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspended Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Suspended = 10064;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending = 10066;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Holding Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Holding = 10068;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Held Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Held = 10070;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unholding Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Unholding = 10072;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopping Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Stopping = 10074;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborting Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Aborting = 10076;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborted Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Aborted = 10078;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Clearing Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Clearing = 10080;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition = 10082;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition = 10084;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition = 10086;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition = 10088;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition = 10090;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition = 10092;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition = 10094;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition = 10096;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition = 10098;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition = 10100;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition = 10102;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition = 10104;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition = 10106;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition = 10108;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition = 10110;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition = 10112;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition = 10114;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition = 10116;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition = 10118;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition = 10120;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition = 10122;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition = 10124;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition = 10126;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition = 10128;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition = 10130;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition = 10132;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition = 10134;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition = 10136;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition = 10138;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition = 10140;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition = 10142;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition = 10144;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition = 10146;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition = 10148;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition = 10150;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition = 10152;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition = 10154;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition = 10156;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition = 10158;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition = 10160;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition = 10162;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition = 10164;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition = 10166;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition = 10168;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition = 10170;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition = 10172;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition = 10174;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition = 10176;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition = 10178;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition = 10180;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition = 10182;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition = 10184;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition = 10186;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition = 10188;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle = 10201;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger = 10203;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample = 10205;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample = 10207;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample = 10209;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger = 10211;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample = 10213;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample = 10215;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample = 10217;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger = 10219;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample = 10221;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample = 10223;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample = 10225;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger = 10227;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic = 10229;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger = 10231;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning = 10233;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults = 10235;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample = 10237;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem = 10239;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition = 10241;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition = 10243;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition = 10245;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition = 10247;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition = 10249;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition = 10251;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition = 10253;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition = 10255;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition = 10257;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition = 10259;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition = 10261;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition = 10263;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition = 10265;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition = 10267;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition = 10269;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition = 10271;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition = 10273;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition = 10275;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition = 10277;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition = 10279;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition = 10281;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition = 10283;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition = 10285;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition = 10287;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition = 10289;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition = 10291;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition = 10293;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition = 10295;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition = 10297;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition = 10299;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition = 10301;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition = 10303;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition = 10305;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition = 10307;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition = 10309;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition = 10311;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition = 10313;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition Object.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition = 10315;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet Object.
        /// </summary>
        public const uint StreamType_ParameterSet = 10317;

        /// <summary>
        /// The identifier for the StreamType_GroupIdentifier Object.
        /// </summary>
        public const uint StreamType_GroupIdentifier = 10444;

        /// <summary>
        /// The identifier for the StreamType_Configuration Object.
        /// </summary>
        public const uint StreamType_Configuration = 10430;

        /// <summary>
        /// The identifier for the StreamType_Status Object.
        /// </summary>
        public const uint StreamType_Status = 10432;

        /// <summary>
        /// The identifier for the StreamType_AcquisitionSettings Object.
        /// </summary>
        public const uint StreamType_AcquisitionSettings = 10434;

        /// <summary>
        /// The identifier for the StreamType_AcquisitionStatus Object.
        /// </summary>
        public const uint StreamType_AcquisitionStatus = 10436;

        /// <summary>
        /// The identifier for the StreamType_AcquisitionData Object.
        /// </summary>
        public const uint StreamType_AcquisitionData = 10438;

        /// <summary>
        /// The identifier for the StreamType_ChemometricModelSettings Object.
        /// </summary>
        public const uint StreamType_ChemometricModelSettings = 10440;

        /// <summary>
        /// The identifier for the StreamType_Context Object.
        /// </summary>
        public const uint StreamType_Context = 10442;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet = 10446;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Configuration Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Configuration = 10559;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionSettings Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_AcquisitionSettings = 10563;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionStatus Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_AcquisitionStatus = 10565;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionData Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_AcquisitionData = 10567;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_FactorySettings Object.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_FactorySettings = 10638;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet = 10768;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_AcquisitionData Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_AcquisitionData = 10889;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet = 11305;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_NetworkAddress = 13132;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_FactorySettings Object.
        /// </summary>
        public const uint SpectrometerDeviceType_FactorySettings = 11411;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet = 11428;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Configuration = 11471;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Status = 11473;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = 11475;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 11487;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 11499;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = 11536;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 11539;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_NetworkAddress = 13157;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet = 11677;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Configuration = 11720;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Status = 11722;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine = 11724;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 11736;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 11748;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_SupportedTypes = 11785;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 11788;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_NetworkAddress = 13182;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet = 11923;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Configuration = 11966;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Status = 11968;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine = 11970;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 11982;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 11994;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_SupportedTypes = 12031;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 12034;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_NetworkAddress = 13207;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet = 12169;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Configuration = 12212;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Status = 12214;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = 12216;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 12228;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 12240;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = 12277;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 12280;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_NetworkAddress = 13232;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet = 12415;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Configuration = 12458;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Status = 12460;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = 12462;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 12474;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 12486;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = 12523;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 12526;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_NetworkAddress = 13257;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet = 12661;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Configuration = 12704;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Status = 12706;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine = 12708;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = 12720;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = 12732;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_SupportedTypes = 12769;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = 12772;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessorySlotStateMachine Object.
        /// </summary>
        public const uint AccessorySlotType_AccessorySlotStateMachine = 12788;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier Object.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier = 12800;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Configuration Object.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Configuration = 12821;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Status Object.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Status = 12823;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_FactorySettings Object.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_FactorySettings = 12825;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Powerup Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Powerup = 12840;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Empty Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Empty = 12842;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Inserting Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Inserting = 12844;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Installed Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Installed = 12846;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Removing Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Removing = 12848;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Shutdown Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Shutdown = 12850;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_PowerupToEmptyTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_PowerupToEmptyTransition = 12852;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToInsertingTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_EmptyToInsertingTransition = 12854;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingTransition = 12856;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToRemovingTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToRemovingTransition = 12858;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToInstalledTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToInstalledTransition = 12860;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToRemovingTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InstalledToRemovingTransition = 12862;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingTransition = 12864;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToEmptyTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingToEmptyTransition = 12866;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToShutdownTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_EmptyToShutdownTransition = 12868;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToShutdownTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToShutdownTransition = 12870;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToShutdownTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InstalledToShutdownTransition = 12872;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToShutdownTransition Object.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingToShutdownTransition = 12874;

        /// <summary>
        /// The identifier for the AccessoryType_Configuration Object.
        /// </summary>
        public const uint AccessoryType_Configuration = 12898;

        /// <summary>
        /// The identifier for the AccessoryType_Status Object.
        /// </summary>
        public const uint AccessoryType_Status = 12900;

        /// <summary>
        /// The identifier for the AccessoryType_FactorySettings Object.
        /// </summary>
        public const uint AccessoryType_FactorySettings = 12902;
    }
    #endregion

    #region ObjectType Identifiers
    /// <summary>
    /// A class that declares constants for all ObjectTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ObjectTypes
    {
        /// <summary>
        /// The identifier for the AnalyserDeviceType ObjectType.
        /// </summary>
        public const uint AnalyserDeviceType = 1001;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType ObjectType.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType = 1002;

        /// <summary>
        /// The identifier for the AnalyserChannelType ObjectType.
        /// </summary>
        public const uint AnalyserChannelType = 1003;

        /// <summary>
        /// The identifier for the AnalyserChannelOperatingStateType ObjectType.
        /// </summary>
        public const uint AnalyserChannelOperatingStateType = 1004;

        /// <summary>
        /// The identifier for the AnalyserChannelLocalStateType ObjectType.
        /// </summary>
        public const uint AnalyserChannelLocalStateType = 1005;

        /// <summary>
        /// The identifier for the AnalyserChannelMaintenanceStateType ObjectType.
        /// </summary>
        public const uint AnalyserChannelMaintenanceStateType = 1006;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType ObjectType.
        /// </summary>
        public const uint AnalyserChannelStateMachineType = 1007;

        /// <summary>
        /// The identifier for the AnalyserChannelOperatingExecuteStateType ObjectType.
        /// </summary>
        public const uint AnalyserChannelOperatingExecuteStateType = 8964;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType ObjectType.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType = 1008;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType ObjectType.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType = 1009;

        /// <summary>
        /// The identifier for the StreamType ObjectType.
        /// </summary>
        public const uint StreamType = 1010;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public const uint SpectrometerDeviceStreamType = 1030;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType = 1031;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType ObjectType.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType = 1032;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType = 1033;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType ObjectType.
        /// </summary>
        public const uint ChromatographDeviceStreamType = 1034;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType ObjectType.
        /// </summary>
        public const uint MNRDeviceStreamType = 1035;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType ObjectType.
        /// </summary>
        public const uint SpectrometerDeviceType = 1011;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType ObjectType.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType = 1012;

        /// <summary>
        /// The identifier for the ChromatographDeviceType ObjectType.
        /// </summary>
        public const uint ChromatographDeviceType = 1013;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType ObjectType.
        /// </summary>
        public const uint MassSpectrometerDeviceType = 1014;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType ObjectType.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType = 1015;

        /// <summary>
        /// The identifier for the NMRDeviceType ObjectType.
        /// </summary>
        public const uint NMRDeviceType = 1016;

        /// <summary>
        /// The identifier for the AccessorySlotType ObjectType.
        /// </summary>
        public const uint AccessorySlotType = 1017;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType ObjectType.
        /// </summary>
        public const uint AccessorySlotStateMachineType = 1018;

        /// <summary>
        /// The identifier for the AccessoryType ObjectType.
        /// </summary>
        public const uint AccessoryType = 1019;

        /// <summary>
        /// The identifier for the DetectorType ObjectType.
        /// </summary>
        public const uint DetectorType = 9350;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType ObjectType.
        /// </summary>
        public const uint SmartSamplingSystemType = 9359;

        /// <summary>
        /// The identifier for the SourceType ObjectType.
        /// </summary>
        public const uint SourceType = 9368;

        /// <summary>
        /// The identifier for the GcOvenType ObjectType.
        /// </summary>
        public const uint GcOvenType = 1020;
    }
    #endregion

    #region ReferenceType Identifiers
    /// <summary>
    /// A class that declares constants for all ReferenceTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ReferenceTypes
    {
        /// <summary>
        /// The identifier for the HasDataSource ReferenceType.
        /// </summary>
        public const uint HasDataSource = 4001;

        /// <summary>
        /// The identifier for the HasInput ReferenceType.
        /// </summary>
        public const uint HasInput = 4002;

        /// <summary>
        /// The identifier for the HasOutput ReferenceType.
        /// </summary>
        public const uint HasOutput = 4003;
    }
    #endregion

    #region Variable Identifiers
    /// <summary>
    /// A class that declares constants for all Variables in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Variables
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceUri Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceUri = 15002;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceVersion Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceVersion = 15003;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespacePublicationDate Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespacePublicationDate = 15004;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_IsNamespaceSubset Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_IsNamespaceSubset = 15005;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticNodeIdTypes Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_StaticNodeIdTypes = 15006;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticNumericNodeIdRange Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_StaticNumericNodeIdRange = 15007;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticStringNodeIdPattern Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_StaticStringNodeIdPattern = 15008;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Size Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Size = 15010;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Writable Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Writable = 15011;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_UserWritable Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_UserWritable = 15012;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_OpenCount Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_OpenCount = 15013;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Open_InputArguments = 15016;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open_OutputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Open_OutputArguments = 15017;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Close_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Close_InputArguments = 15019;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Read_InputArguments = 15021;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read_OutputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Read_OutputArguments = 15022;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Write_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_Write_InputArguments = 15024;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_InputArguments = 15026;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_OutputArguments = 15027;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition_InputArguments = 15029;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultRolePermissions Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_DefaultRolePermissions = 15031;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultUserRolePermissions Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_DefaultUserRolePermissions = 15032;

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultAccessRestrictions Variable.
        /// </summary>
        public const uint OpcUaAdiNamespaceMetadata_DefaultAccessRestrictions = 15033;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_Locked = 9389;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_LockingClient = 9390;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_LockingUser = 9391;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_RemainingLockTime = 9392;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_InitLock_InputArguments = 9394;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_InitLock_OutputArguments = 9395;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_RenewLock_OutputArguments = 9397;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_ExitLock_OutputArguments = 9399;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_Lock_BreakLock_OutputArguments = 9401;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_Locked = 13094;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_LockingClient = 13095;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_LockingUser = 13096;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_RemainingLockTime = 13097;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13099;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13100;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13102;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13104;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13106;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GetConfiguration_OutputArguments = 9444;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_SetConfiguration_InputArguments = 9446;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_SetConfiguration_OutputArguments = 9447;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 9449;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 9451;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 9452;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_DiagnosticStatus = 9459;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Size = 9463;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Writable = 13070;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_UserWritable = 13071;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_OpenCount = 9466;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Open_InputArguments = 9468;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 9469;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Close_InputArguments = 9471;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Read_InputArguments = 9473;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 9474;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_Write_InputArguments = 9476;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 9478;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 9479;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 9481;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AnalyserStateMachine_CurrentState = 9489;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AnalyserStateMachine_CurrentState_Id = 9490;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AnalyserStateMachine_LastTransition_Id = 9495;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_Locked = 9508;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_LockingClient = 9509;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_LockingUser = 9510;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 9511;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 9513;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 9514;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 9516;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 9518;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 9520;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 9524;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 9537;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 9540;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 9543;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 9551;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 9552;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 9557;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 9563;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 9564;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 9569;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 9575;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 9576;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 9581;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 9587;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 9588;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 9593;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 9599;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 9600;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 9605;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_IsHotSwappable = 9612;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_IsEnabled = 9613;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 9615;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 9616;

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 9621;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_CurrentState_Id = 9637;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LastTransition_Id = 9642;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Powerup_StateNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Powerup_StateNumber = 9648;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Operating_StateNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Operating_StateNumber = 9650;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Local_StateNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Local_StateNumber = 9652;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Maintenance_StateNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Maintenance_StateNumber = 9654;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Shutdown_StateNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_Shutdown_StateNumber = 9656;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_PowerupToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_PowerupToOperatingTransition_TransitionNumber = 9658;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToLocalTransition_TransitionNumber = 9660;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition_TransitionNumber = 9662;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToOperatingTransition_TransitionNumber = 9664;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToMaintenanceTransition_TransitionNumber = 9666;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition_TransitionNumber = 9668;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToLocalTransition_TransitionNumber = 9670;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_OperatingToShutdownTransition_TransitionNumber = 9672;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_LocalToShutdownTransition_TransitionNumber = 9674;

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition_TransitionNumber = 9676;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_Locked Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_Locked = 9686;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_LockingClient Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_LockingClient = 9687;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_LockingUser Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_LockingUser = 9688;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_RemainingLockTime = 9689;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_InitLock_InputArguments = 9691;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_InitLock_OutputArguments = 9692;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_RenewLock_OutputArguments = 9694;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_ExitLock_OutputArguments = 9696;

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_Lock_BreakLock_OutputArguments = 9698;

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_MethodSet_StartSingleAcquisition_InputArguments = 9702;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_ChannelId Variable.
        /// </summary>
        public const uint AnalyserChannelType_ParameterSet_ChannelId = 9712;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint AnalyserChannelType_ParameterSet_IsEnabled = 9715;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AnalyserChannelType_ParameterSet_DiagnosticStatus = 9718;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint AnalyserChannelType_ParameterSet_ActiveStream = 9721;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_CurrentState = 9729;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_CurrentState_Id = 9730;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_LastTransition_Id = 9735;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 9741;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 9742;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 9747;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 9753;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 9754;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 9759;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState = 9765;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 9766;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 9771;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 9777;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 9778;

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 9783;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_Locked = 9798;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_LockingClient = 9799;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_LockingUser = 9800;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_RemainingLockTime = 9801;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_InitLock_InputArguments = 9803;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_InitLock_OutputArguments = 9804;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_RenewLock_OutputArguments = 9806;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_ExitLock_OutputArguments = 9808;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_Lock_BreakLock_OutputArguments = 9810;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_IsEnabled = 9811;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_DiagnosticStatus = 9817;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_LastSampleTime = 9826;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_TimeBetweenSamples_EURange = 9833;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_IsActive = 9835;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycle = 9838;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode = 9841;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode_EnumStrings = 9844;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_Progress Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_Progress = 9845;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter = 9848;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter_EURange = 9852;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionResultStatus = 9854;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_ScaledData = 9860;

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionEndTime = 9866;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_IsHotSwappable = 9918;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_IsEnabled = 9919;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 9921;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 9922;

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 9927;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_CurrentState_Id = 9938;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LastTransition_Id = 9943;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState = 9949;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState_Id = 9950;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_LastTransition_Id = 9955;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 9961;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 9962;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 9967;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState = 9973;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState_Id = 9974;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalSubStateMachine_LastTransition_Id = 9979;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState = 9985;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState_Id = 9986;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceSubStateMachine_LastTransition_Id = 9991;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveMode_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_SlaveMode_StateNumber = 9997;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Operating_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Operating_StateNumber = 9999;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Local_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Local_StateNumber = 10001;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Maintenance_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_Maintenance_StateNumber = 10003;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveModeToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_SlaveModeToOperatingTransition_TransitionNumber = 10005;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToLocalTransition_TransitionNumber = 10007;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToMaintenanceTransition_TransitionNumber = 10009;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToOperatingTransition_TransitionNumber = 10011;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToMaintenanceTransition_TransitionNumber = 10013;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToOperatingTransition_TransitionNumber = 10015;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToLocalTransition_TransitionNumber = 10017;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_OperatingToSlaveModeTransition_TransitionNumber = 10019;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_LocalToSlaveModeTransition_TransitionNumber = 10021;

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition_TransitionNumber = 10023;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CurrentState_Id = 10026;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_LastTransition_Id = 10031;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState = 10037;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState_Id = 10038;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_LastTransition_Id = 10043;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopped_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Stopped_StateNumber = 10049;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Resetting_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Resetting_StateNumber = 10051;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Idle_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Idle_StateNumber = 10053;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Starting_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Starting_StateNumber = 10055;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Execute_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Execute_StateNumber = 10057;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Completing_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Completing_StateNumber = 10059;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Complete_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Complete_StateNumber = 10061;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspending_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Suspending_StateNumber = 10063;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspended_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Suspended_StateNumber = 10065;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending_StateNumber = 10067;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Holding_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Holding_StateNumber = 10069;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Held_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Held_StateNumber = 10071;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unholding_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Unholding_StateNumber = 10073;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopping_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Stopping_StateNumber = 10075;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborting_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Aborting_StateNumber = 10077;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborted_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Aborted_StateNumber = 10079;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Clearing_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_Clearing_StateNumber = 10081;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition_TransitionNumber = 10083;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition_TransitionNumber = 10085;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition_TransitionNumber = 10087;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition_TransitionNumber = 10089;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition_TransitionNumber = 10091;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition_TransitionNumber = 10093;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition_TransitionNumber = 10095;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition_TransitionNumber = 10097;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition_TransitionNumber = 10099;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition_TransitionNumber = 10101;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition_TransitionNumber = 10103;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition_TransitionNumber = 10105;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition_TransitionNumber = 10107;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition_TransitionNumber = 10109;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition_TransitionNumber = 10111;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition_TransitionNumber = 10113;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition_TransitionNumber = 10115;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition_TransitionNumber = 10117;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition_TransitionNumber = 10119;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition_TransitionNumber = 10121;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition_TransitionNumber = 10123;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition_TransitionNumber = 10125;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition_TransitionNumber = 10127;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition_TransitionNumber = 10129;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition_TransitionNumber = 10131;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition_TransitionNumber = 10133;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition_TransitionNumber = 10135;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition_TransitionNumber = 10137;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition_TransitionNumber = 10139;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition_TransitionNumber = 10141;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition_TransitionNumber = 10143;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition_TransitionNumber = 10145;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition_TransitionNumber = 10147;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition_TransitionNumber = 10149;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition_TransitionNumber = 10151;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition_TransitionNumber = 10153;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition_TransitionNumber = 10155;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition_TransitionNumber = 10157;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition_TransitionNumber = 10159;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition_TransitionNumber = 10161;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition_TransitionNumber = 10163;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition_TransitionNumber = 10165;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition_TransitionNumber = 10167;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition_TransitionNumber = 10169;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition_TransitionNumber = 10171;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition_TransitionNumber = 10173;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition_TransitionNumber = 10175;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition_TransitionNumber = 10177;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition_TransitionNumber = 10179;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition_TransitionNumber = 10181;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition_TransitionNumber = 10183;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition_TransitionNumber = 10185;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition_TransitionNumber = 10187;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition_TransitionNumber = 10189;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CurrentState_Id = 10191;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_LastTransition_Id = 10196;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle_StateNumber = 10202;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger_StateNumber = 10204;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample_StateNumber = 10206;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample_StateNumber = 10208;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample_StateNumber = 10210;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger_StateNumber = 10212;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample_StateNumber = 10214;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample_StateNumber = 10216;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample_StateNumber = 10218;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger_StateNumber = 10220;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample_StateNumber = 10222;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample_StateNumber = 10224;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample_StateNumber = 10226;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger_StateNumber = 10228;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic_StateNumber = 10230;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger_StateNumber = 10232;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning_StateNumber = 10234;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults_StateNumber = 10236;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample_StateNumber = 10238;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem_StateNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem_StateNumber = 10240;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition_TransitionNumber = 10242;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition_TransitionNumber = 10244;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition_TransitionNumber = 10246;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition_TransitionNumber = 10248;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition_TransitionNumber = 10250;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition_TransitionNumber = 10252;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition_TransitionNumber = 10254;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition_TransitionNumber = 10256;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition_TransitionNumber = 10258;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition_TransitionNumber = 10260;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition_TransitionNumber = 10262;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition_TransitionNumber = 10264;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition_TransitionNumber = 10266;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition_TransitionNumber = 10268;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition_TransitionNumber = 10270;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition_TransitionNumber = 10272;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition_TransitionNumber = 10274;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition_TransitionNumber = 10276;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition_TransitionNumber = 10278;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition_TransitionNumber = 10280;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition_TransitionNumber = 10282;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition_TransitionNumber = 10284;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition_TransitionNumber = 10286;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition_TransitionNumber = 10288;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition_TransitionNumber = 10290;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition_TransitionNumber = 10292;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition_TransitionNumber = 10294;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition_TransitionNumber = 10296;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition_TransitionNumber = 10298;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition_TransitionNumber = 10300;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition_TransitionNumber = 10302;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition_TransitionNumber = 10304;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition_TransitionNumber = 10306;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition_TransitionNumber = 10308;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition_TransitionNumber = 10310;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition_TransitionNumber = 10312;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition_TransitionNumber = 10314;

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition_TransitionNumber = 10316;

        /// <summary>
        /// The identifier for the StreamType_Lock_Locked Variable.
        /// </summary>
        public const uint StreamType_Lock_Locked = 10326;

        /// <summary>
        /// The identifier for the StreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint StreamType_Lock_LockingClient = 10327;

        /// <summary>
        /// The identifier for the StreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint StreamType_Lock_LockingUser = 10328;

        /// <summary>
        /// The identifier for the StreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint StreamType_Lock_RemainingLockTime = 10329;

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint StreamType_Lock_InitLock_InputArguments = 10331;

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint StreamType_Lock_InitLock_OutputArguments = 10332;

        /// <summary>
        /// The identifier for the StreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint StreamType_Lock_RenewLock_OutputArguments = 10334;

        /// <summary>
        /// The identifier for the StreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint StreamType_Lock_ExitLock_OutputArguments = 10336;

        /// <summary>
        /// The identifier for the StreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint StreamType_Lock_BreakLock_OutputArguments = 10338;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_IsEnabled = 10339;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsForced Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_IsForced = 10342;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_DiagnosticStatus = 10345;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastCalibrationTime Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_LastCalibrationTime = 10348;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastValidationTime Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_LastValidationTime = 10351;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_LastSampleTime = 10354;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_TimeBetweenSamples Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_TimeBetweenSamples = 10357;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_TimeBetweenSamples_EURange = 10361;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_IsActive = 10363;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_ExecutionCycle = 10366;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_ExecutionCycleSubcode = 10369;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 10372;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Progress = 10373;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_AcquisitionCounter = 10376;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_AcquisitionCounter_EURange = 10380;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_AcquisitionResultStatus = 10382;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_RawData Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_RawData = 10385;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_ScaledData = 10388;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Offset Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Offset = 10391;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_AcquisitionEndTime = 10394;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_CampaignId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_CampaignId = 10397;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_BatchId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_BatchId = 10400;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_SubBatchId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_SubBatchId = 10403;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LotId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_LotId = 10406;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_MaterialId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_MaterialId = 10409;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Process Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Process = 10412;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Unit Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Unit = 10415;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Operation Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Operation = 10418;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Phase Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_Phase = 10421;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_UserId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_UserId = 10424;

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_SampleId Variable.
        /// </summary>
        public const uint StreamType_ParameterSet_SampleId = 10427;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_Locked = 10455;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_LockingClient = 10456;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_LockingUser = 10457;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_RemainingLockTime = 10458;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_InitLock_InputArguments = 10460;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = 10461;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = 10463;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = 10465;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = 10467;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_IsEnabled = 10468;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = 10474;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_LastSampleTime = 10483;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 10490;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_IsActive = 10492;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = 10495;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 10498;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 10501;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_Progress = 10502;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = 10505;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 10509;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = 10511;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ScaledData = 10517;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = 10523;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground = 10575;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EURange = 10579;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EngineeringUnits Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EngineeringUnits = 10580;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_Title Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_Title = 10581;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_AxisScaleType Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_AxisScaleType = 10582;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_XAxisDefinition Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_XAxisDefinition = 10583;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1 Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1 = 10584;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EURange = 10588;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EngineeringUnits Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EngineeringUnits = 10589;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_Title Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_Title = 10590;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_AxisScaleType Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_AxisScaleType = 10591;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_XAxisDefinition Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_XAxisDefinition = 10592;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_SpectralRange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_SpectralRange = 10593;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Resolution Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_Resolution = 10596;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_RequestedNumberOfScans Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_RequestedNumberOfScans = 10599;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Gain Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_Gain = 10602;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TransmittanceCutoff Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_TransmittanceCutoff = 10605;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AbsorbanceCutoff Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_AbsorbanceCutoff = 10608;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_NumberOfScansDone Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_NumberOfScansDone = 10611;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TotalNumberOfScansDone Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_TotalNumberOfScansDone = 10614;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_BackgroundAcquisitionTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_BackgroundAcquisitionTime = 10617;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground = 10620;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EURange = 10624;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EngineeringUnits Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EngineeringUnits = 10625;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_Title Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground_Title = 10626;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_AxisScaleType Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground_AxisScaleType = 10627;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_XAxisDefinition Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground_XAxisDefinition = 10628;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1 Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1 = 10629;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EURange Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EURange = 10633;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EngineeringUnits Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EngineeringUnits = 10634;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_Title Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_Title = 10635;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_AxisScaleType Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_AxisScaleType = 10636;

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_XAxisDefinition Variable.
        /// </summary>
        public const uint SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_XAxisDefinition = 10637;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_Locked = 10648;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_LockingClient = 10649;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_LockingUser = 10650;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_RemainingLockTime = 10651;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_InitLock_InputArguments = 10653;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = 10654;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = 10656;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = 10658;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = 10660;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_IsEnabled = 10661;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = 10667;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_LastSampleTime = 10676;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 10683;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_IsActive = 10685;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = 10688;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 10691;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 10694;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_Progress = 10695;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = 10698;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 10702;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = 10704;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_ScaledData = 10710;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = 10716;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_Locked = 10777;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_LockingClient = 10778;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_LockingUser = 10779;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_RemainingLockTime = 10780;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_InitLock_InputArguments = 10782;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_InitLock_OutputArguments = 10783;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_RenewLock_OutputArguments = 10785;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_ExitLock_OutputArguments = 10787;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_Lock_BreakLock_OutputArguments = 10789;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_IsEnabled = 10790;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_DiagnosticStatus = 10796;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_LastSampleTime = 10805;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 10812;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_IsActive = 10814;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycle = 10817;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 10820;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 10823;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Progress = 10824;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter = 10827;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 10831;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionResultStatus = 10833;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_ScaledData = 10839;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionEndTime = 10845;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background = 10897;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EURange Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EURange = 10901;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EngineeringUnits Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EngineeringUnits = 10902;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_Title Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_Title = 10903;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_AxisScaleType Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_AxisScaleType = 10904;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_XAxisDefinition Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_XAxisDefinition = 10905;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution = 10906;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EURange Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EURange = 10910;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EngineeringUnits Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EngineeringUnits = 10911;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_Title Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_Title = 10912;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_AxisScaleType Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_AxisScaleType = 10913;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_XAxisDefinition Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_XAxisDefinition = 10914;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_BackgroundAcquisitionTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceStreamType_ParameterSet_BackgroundAcquisitionTime = 10915;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_Locked = 10927;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_LockingClient = 10928;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_LockingUser = 10929;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_RemainingLockTime = 10930;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_InitLock_InputArguments = 10932;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = 10933;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = 10935;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = 10937;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = 10939;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_IsEnabled = 10940;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = 10946;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_LastSampleTime = 10955;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 10962;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_IsActive = 10964;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = 10967;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 10970;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 10973;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_Progress = 10974;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = 10977;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 10981;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = 10983;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_ScaledData = 10989;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = 10995;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_Locked = 11056;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_LockingClient = 11057;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_LockingUser = 11058;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_RemainingLockTime = 11059;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_InitLock_InputArguments = 11061;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_InitLock_OutputArguments = 11062;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_RenewLock_OutputArguments = 11064;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_ExitLock_OutputArguments = 11066;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_Lock_BreakLock_OutputArguments = 11068;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_IsEnabled = 11069;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_DiagnosticStatus = 11075;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_LastSampleTime = 11084;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 11091;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_IsActive = 11093;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_ExecutionCycle = 11096;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 11099;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 11102;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_Progress = 11103;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter = 11106;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 11110;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_AcquisitionResultStatus = 11112;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_ScaledData = 11118;

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint ChromatographDeviceStreamType_ParameterSet_AcquisitionEndTime = 11124;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_Locked = 11185;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_LockingClient = 11186;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_LockingUser = 11187;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_RemainingLockTime = 11188;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_InitLock_InputArguments = 11190;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_InitLock_OutputArguments = 11191;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_RenewLock_OutputArguments = 11193;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_ExitLock_OutputArguments = 11195;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_Lock_BreakLock_OutputArguments = 11197;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_IsEnabled = 11198;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_DiagnosticStatus = 11204;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_LastSampleTime = 11213;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = 11220;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_IsActive = 11222;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_ExecutionCycle = 11225;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode = 11228;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = 11231;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_Progress = 11232;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_AcquisitionCounter = 11235;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = 11239;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_AcquisitionResultStatus = 11241;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_ScaledData = 11247;

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public const uint MNRDeviceStreamType_ParameterSet_AcquisitionEndTime = 11253;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_Locked = 11314;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_LockingClient = 11315;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_LockingUser = 11316;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_RemainingLockTime = 11317;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_InitLock_InputArguments = 11319;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_InitLock_OutputArguments = 11320;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_RenewLock_OutputArguments = 11322;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_ExitLock_OutputArguments = 11324;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_Lock_BreakLock_OutputArguments = 11326;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_Locked = 13119;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_LockingClient = 13120;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_LockingUser = 13121;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime = 13122;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13124;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13125;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13127;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13129;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13131;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments = 11369;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments = 11371;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments = 11372;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 11374;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 11376;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 11377;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_DiagnosticStatus = 11384;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Size = 11388;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Writable = 13072;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_UserWritable = 13073;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_OpenCount = 11391;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments = 11393;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 11394;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments = 11396;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments = 11398;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 11399;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments = 11401;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 11403;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 11404;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 11406;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AnalyserStateMachine_CurrentState = 11414;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id = 11415;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id = 11420;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_Locked = 11433;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient = 11434;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser = 11435;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 11436;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 11438;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 11439;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 11441;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 11443;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 11445;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 11449;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 11462;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 11465;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 11468;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 11476;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 11477;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 11482;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 11488;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 11489;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 11494;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 11500;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 11501;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 11506;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 11512;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 11513;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 11518;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 11524;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 11525;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 11530;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable = 11537;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled = 11538;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 11540;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 11541;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 11546;

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_SpectralRange Variable.
        /// </summary>
        public const uint SpectrometerDeviceType_ParameterSet_SpectralRange = 11551;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_Locked = 11563;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_LockingClient = 11564;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_LockingUser = 11565;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_RemainingLockTime = 11566;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_InitLock_InputArguments = 11568;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_InitLock_OutputArguments = 11569;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_RenewLock_OutputArguments = 11571;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_ExitLock_OutputArguments = 11573;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_Lock_BreakLock_OutputArguments = 11575;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_Locked = 13144;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingClient = 13145;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingUser = 13146;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RemainingLockTime = 13147;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13149;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13150;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13152;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13154;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13156;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration_OutputArguments = 11618;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration_InputArguments = 11620;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration_OutputArguments = 11621;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 11623;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 11625;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 11626;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_DiagnosticStatus = 11633;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Size = 11637;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Writable = 13074;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_UserWritable = 13075;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_OpenCount = 11640;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open_InputArguments = 11642;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 11643;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close_InputArguments = 11645;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read_InputArguments = 11647;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 11648;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write_InputArguments = 11650;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 11652;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 11653;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 11655;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AnalyserStateMachine_CurrentState = 11663;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AnalyserStateMachine_CurrentState_Id = 11664;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AnalyserStateMachine_LastTransition_Id = 11669;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_Locked = 11682;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_LockingClient = 11683;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_LockingUser = 11684;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 11685;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 11687;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 11688;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 11690;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 11692;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 11694;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 11698;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 11711;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 11714;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 11717;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 11725;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 11726;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 11731;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 11737;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 11738;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 11743;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 11749;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 11750;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 11755;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 11761;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 11762;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 11767;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 11773;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 11774;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 11779;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_IsHotSwappable = 11786;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_IsEnabled = 11787;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 11789;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 11790;

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 11795;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_Locked = 11809;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_LockingClient = 11810;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_LockingUser = 11811;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_RemainingLockTime = 11812;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_InitLock_InputArguments = 11814;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_InitLock_OutputArguments = 11815;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_RenewLock_OutputArguments = 11817;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_ExitLock_OutputArguments = 11819;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_Lock_BreakLock_OutputArguments = 11821;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_Locked = 13169;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_LockingClient = 13170;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_LockingUser = 13171;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_RemainingLockTime = 13172;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13174;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13175;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13177;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13179;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13181;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GetConfiguration_OutputArguments = 11864;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_SetConfiguration_InputArguments = 11866;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_SetConfiguration_OutputArguments = 11867;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 11869;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 11871;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 11872;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_DiagnosticStatus = 11879;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Size = 11883;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Writable = 13076;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_UserWritable = 13077;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_OpenCount = 11886;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Open_InputArguments = 11888;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 11889;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Close_InputArguments = 11891;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Read_InputArguments = 11893;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 11894;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_Write_InputArguments = 11896;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 11898;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 11899;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 11901;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AnalyserStateMachine_CurrentState = 11909;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AnalyserStateMachine_CurrentState_Id = 11910;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AnalyserStateMachine_LastTransition_Id = 11915;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_Locked = 11928;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_LockingClient = 11929;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_LockingUser = 11930;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 11931;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 11933;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 11934;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 11936;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 11938;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 11940;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 11944;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 11957;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 11960;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 11963;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 11971;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 11972;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 11977;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 11983;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 11984;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 11989;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 11995;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 11996;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 12001;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 12007;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 12008;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 12013;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 12019;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 12020;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 12025;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_IsHotSwappable = 12032;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_IsEnabled = 12033;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 12035;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 12036;

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 12041;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_Locked = 12055;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_LockingClient = 12056;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_LockingUser = 12057;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_RemainingLockTime = 12058;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_InitLock_InputArguments = 12060;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_InitLock_OutputArguments = 12061;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_RenewLock_OutputArguments = 12063;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_ExitLock_OutputArguments = 12065;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_Lock_BreakLock_OutputArguments = 12067;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_Locked = 13194;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_LockingClient = 13195;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_LockingUser = 13196;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime = 13197;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13199;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13200;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13202;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13204;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13206;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments = 12110;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments = 12112;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments = 12113;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 12115;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 12117;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 12118;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_DiagnosticStatus = 12125;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Size = 12129;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Writable = 13078;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_UserWritable = 13079;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_OpenCount = 12132;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments = 12134;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 12135;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments = 12137;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments = 12139;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 12140;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments = 12142;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 12144;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 12145;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 12147;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AnalyserStateMachine_CurrentState = 12155;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id = 12156;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id = 12161;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_Locked = 12174;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient = 12175;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser = 12176;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 12177;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 12179;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 12180;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 12182;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 12184;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 12186;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 12190;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 12203;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 12206;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 12209;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 12217;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 12218;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 12223;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 12229;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 12230;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 12235;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 12241;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 12242;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 12247;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 12253;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 12254;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 12259;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 12265;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 12266;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 12271;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable = 12278;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled = 12279;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 12281;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 12282;

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 12287;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_Locked = 12301;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_LockingClient = 12302;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_LockingUser = 12303;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_RemainingLockTime = 12304;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_InitLock_InputArguments = 12306;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_InitLock_OutputArguments = 12307;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_RenewLock_OutputArguments = 12309;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_ExitLock_OutputArguments = 12311;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_Lock_BreakLock_OutputArguments = 12313;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_Locked = 13219;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_LockingClient = 13220;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_LockingUser = 13221;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime = 13222;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13224;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13225;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13227;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13229;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13231;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments = 12356;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments = 12358;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments = 12359;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 12361;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 12363;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 12364;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_DiagnosticStatus = 12371;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Size = 12375;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Writable = 13080;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_UserWritable = 13081;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_OpenCount = 12378;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments = 12380;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 12381;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments = 12383;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments = 12385;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 12386;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments = 12388;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 12390;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 12391;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 12393;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AnalyserStateMachine_CurrentState = 12401;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id = 12402;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id = 12407;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_Locked = 12420;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient = 12421;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser = 12422;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 12423;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 12425;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 12426;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 12428;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 12430;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 12432;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 12436;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 12449;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 12452;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 12455;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 12463;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 12464;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 12469;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 12475;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 12476;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 12481;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 12487;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 12488;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 12493;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 12499;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 12500;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 12505;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 12511;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 12512;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 12517;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable = 12524;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled = 12525;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 12527;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 12528;

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 12533;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_Locked Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_Locked = 12547;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_LockingClient = 12548;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_LockingUser = 12549;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_RemainingLockTime = 12550;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_InitLock_InputArguments = 12552;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_InitLock_OutputArguments = 12553;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_RenewLock_OutputArguments = 12555;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_ExitLock_OutputArguments = 12557;

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_Lock_BreakLock_OutputArguments = 12559;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_Locked = 13244;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_LockingClient = 13245;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_LockingUser = 13246;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_RemainingLockTime = 13247;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_InitLock_InputArguments = 13249;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = 13250;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = 13252;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = 13254;

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = 13256;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GetConfiguration_OutputArguments = 12602;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_SetConfiguration_InputArguments = 12604;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_SetConfiguration_OutputArguments = 12605;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = 12607;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = 12609;

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = 12610;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_DiagnosticStatus = 12617;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Size = 12621;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Writable = 13082;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_UserWritable = 13083;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_OpenCount = 12624;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Open_InputArguments = 12626;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Open_OutputArguments = 12627;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Close_InputArguments = 12629;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Read_InputArguments = 12631;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Read_OutputArguments = 12632;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_Write_InputArguments = 12634;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = 12636;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = 12637;

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = 12639;

        /// <summary>
        /// The identifier for the NMRDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_AnalyserStateMachine_CurrentState = 12647;

        /// <summary>
        /// The identifier for the NMRDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_AnalyserStateMachine_CurrentState_Id = 12648;

        /// <summary>
        /// The identifier for the NMRDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_AnalyserStateMachine_LastTransition_Id = 12653;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_Locked = 12666;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_LockingClient = 12667;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_LockingUser = 12668;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_RemainingLockTime = 12669;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = 12671;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = 12672;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = 12674;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = 12676;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = 12678;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = 12682;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = 12695;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = 12698;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = 12701;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = 12709;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = 12710;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = 12715;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = 12721;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = 12722;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = 12727;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = 12733;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = 12734;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = 12739;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = 12745;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = 12746;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = 12751;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = 12757;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = 12758;

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = 12763;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_IsHotSwappable = 12770;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_IsEnabled = 12771;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = 12773;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = 12774;

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = 12779;

        /// <summary>
        /// The identifier for the AccessorySlotType_IsHotSwappable Variable.
        /// </summary>
        public const uint AccessorySlotType_IsHotSwappable = 12786;

        /// <summary>
        /// The identifier for the AccessorySlotType_IsEnabled Variable.
        /// </summary>
        public const uint AccessorySlotType_IsEnabled = 12787;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessorySlotStateMachine_CurrentState = 12789;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessorySlotStateMachine_CurrentState_Id = 12790;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessorySlotStateMachine_LastTransition_Id = 12795;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_Locked Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_Locked = 12808;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_LockingClient = 12809;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_LockingUser = 12810;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_RemainingLockTime = 12811;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_InitLock_InputArguments = 12813;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_InitLock_OutputArguments = 12814;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_RenewLock_OutputArguments = 12816;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_ExitLock_OutputArguments = 12818;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_Lock_BreakLock_OutputArguments = 12820;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_IsHotSwappable Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_IsHotSwappable = 12827;

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_IsReady Variable.
        /// </summary>
        public const uint AccessorySlotType_AccessoryIdentifier_IsReady = 12828;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_CurrentState_Id = 12830;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_LastTransition_Id = 12835;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Powerup_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Powerup_StateNumber = 12841;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Empty_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Empty_StateNumber = 12843;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Inserting_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Inserting_StateNumber = 12845;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Installed_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Installed_StateNumber = 12847;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Removing_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Removing_StateNumber = 12849;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Shutdown_StateNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_Shutdown_StateNumber = 12851;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_PowerupToEmptyTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_PowerupToEmptyTransition_TransitionNumber = 12853;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToInsertingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_EmptyToInsertingTransition_TransitionNumber = 12855;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingTransition_TransitionNumber = 12857;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToRemovingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToRemovingTransition_TransitionNumber = 12859;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToInstalledTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToInstalledTransition_TransitionNumber = 12861;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToRemovingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InstalledToRemovingTransition_TransitionNumber = 12863;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingTransition_TransitionNumber = 12865;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToEmptyTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingToEmptyTransition_TransitionNumber = 12867;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_EmptyToShutdownTransition_TransitionNumber = 12869;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InsertingToShutdownTransition_TransitionNumber = 12871;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_InstalledToShutdownTransition_TransitionNumber = 12873;

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public const uint AccessorySlotStateMachineType_RemovingToShutdownTransition_TransitionNumber = 12875;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_Locked Variable.
        /// </summary>
        public const uint AccessoryType_Lock_Locked = 12885;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_LockingClient Variable.
        /// </summary>
        public const uint AccessoryType_Lock_LockingClient = 12886;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_LockingUser Variable.
        /// </summary>
        public const uint AccessoryType_Lock_LockingUser = 12887;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint AccessoryType_Lock_RemainingLockTime = 12888;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint AccessoryType_Lock_InitLock_InputArguments = 12890;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessoryType_Lock_InitLock_OutputArguments = 12891;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessoryType_Lock_RenewLock_OutputArguments = 12893;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessoryType_Lock_ExitLock_OutputArguments = 12895;

        /// <summary>
        /// The identifier for the AccessoryType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint AccessoryType_Lock_BreakLock_OutputArguments = 12897;

        /// <summary>
        /// The identifier for the AccessoryType_IsHotSwappable Variable.
        /// </summary>
        public const uint AccessoryType_IsHotSwappable = 12904;

        /// <summary>
        /// The identifier for the AccessoryType_IsReady Variable.
        /// </summary>
        public const uint AccessoryType_IsReady = 12905;

        /// <summary>
        /// The identifier for the DetectorType_Lock_Locked Variable.
        /// </summary>
        public const uint DetectorType_Lock_Locked = 12915;

        /// <summary>
        /// The identifier for the DetectorType_Lock_LockingClient Variable.
        /// </summary>
        public const uint DetectorType_Lock_LockingClient = 12916;

        /// <summary>
        /// The identifier for the DetectorType_Lock_LockingUser Variable.
        /// </summary>
        public const uint DetectorType_Lock_LockingUser = 12917;

        /// <summary>
        /// The identifier for the DetectorType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint DetectorType_Lock_RemainingLockTime = 12918;

        /// <summary>
        /// The identifier for the DetectorType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint DetectorType_Lock_InitLock_InputArguments = 12920;

        /// <summary>
        /// The identifier for the DetectorType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint DetectorType_Lock_InitLock_OutputArguments = 12921;

        /// <summary>
        /// The identifier for the DetectorType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint DetectorType_Lock_RenewLock_OutputArguments = 12923;

        /// <summary>
        /// The identifier for the DetectorType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint DetectorType_Lock_ExitLock_OutputArguments = 12925;

        /// <summary>
        /// The identifier for the DetectorType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint DetectorType_Lock_BreakLock_OutputArguments = 12927;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_Locked Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_Locked = 12945;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_LockingClient Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_LockingClient = 12946;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_LockingUser Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_LockingUser = 12947;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_RemainingLockTime = 12948;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_InitLock_InputArguments = 12950;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_InitLock_OutputArguments = 12951;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_RenewLock_OutputArguments = 12953;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_ExitLock_OutputArguments = 12955;

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SmartSamplingSystemType_Lock_BreakLock_OutputArguments = 12957;

        /// <summary>
        /// The identifier for the SourceType_Lock_Locked Variable.
        /// </summary>
        public const uint SourceType_Lock_Locked = 12975;

        /// <summary>
        /// The identifier for the SourceType_Lock_LockingClient Variable.
        /// </summary>
        public const uint SourceType_Lock_LockingClient = 12976;

        /// <summary>
        /// The identifier for the SourceType_Lock_LockingUser Variable.
        /// </summary>
        public const uint SourceType_Lock_LockingUser = 12977;

        /// <summary>
        /// The identifier for the SourceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint SourceType_Lock_RemainingLockTime = 12978;

        /// <summary>
        /// The identifier for the SourceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint SourceType_Lock_InitLock_InputArguments = 12980;

        /// <summary>
        /// The identifier for the SourceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint SourceType_Lock_InitLock_OutputArguments = 12981;

        /// <summary>
        /// The identifier for the SourceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint SourceType_Lock_RenewLock_OutputArguments = 12983;

        /// <summary>
        /// The identifier for the SourceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint SourceType_Lock_ExitLock_OutputArguments = 12985;

        /// <summary>
        /// The identifier for the SourceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint SourceType_Lock_BreakLock_OutputArguments = 12987;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_Locked Variable.
        /// </summary>
        public const uint GcOvenType_Lock_Locked = 13005;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_LockingClient Variable.
        /// </summary>
        public const uint GcOvenType_Lock_LockingClient = 13006;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_LockingUser Variable.
        /// </summary>
        public const uint GcOvenType_Lock_LockingUser = 13007;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_RemainingLockTime Variable.
        /// </summary>
        public const uint GcOvenType_Lock_RemainingLockTime = 13008;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public const uint GcOvenType_Lock_InitLock_InputArguments = 13010;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public const uint GcOvenType_Lock_InitLock_OutputArguments = 13011;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public const uint GcOvenType_Lock_RenewLock_OutputArguments = 13013;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public const uint GcOvenType_Lock_ExitLock_OutputArguments = 13015;

        /// <summary>
        /// The identifier for the GcOvenType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public const uint GcOvenType_Lock_BreakLock_OutputArguments = 13017;

        /// <summary>
        /// The identifier for the ExecutionCycleEnumeration_EnumValues Variable.
        /// </summary>
        public const uint ExecutionCycleEnumeration_EnumValues = 13026;

        /// <summary>
        /// The identifier for the AcquisitionResultStatusEnumeration_EnumStrings Variable.
        /// </summary>
        public const uint AcquisitionResultStatusEnumeration_EnumStrings = 13027;

        /// <summary>
        /// The identifier for the EngineeringValueType_Identifier Variable.
        /// </summary>
        public const uint EngineeringValueType_Identifier = 13030;

        /// <summary>
        /// The identifier for the ChemometricModelType_Name Variable.
        /// </summary>
        public const uint ChemometricModelType_Name = 13033;

        /// <summary>
        /// The identifier for the ChemometricModelType_CreationDate Variable.
        /// </summary>
        public const uint ChemometricModelType_CreationDate = 13034;

        /// <summary>
        /// The identifier for the ChemometricModelType_ModelDescription Variable.
        /// </summary>
        public const uint ChemometricModelType_ModelDescription = 13035;

        /// <summary>
        /// The identifier for the ChemometricModelType_User_defined_Input Variable.
        /// </summary>
        public const uint ChemometricModelType_User_defined_Input = 13036;

        /// <summary>
        /// The identifier for the ChemometricModelType_User_defined_Output Variable.
        /// </summary>
        public const uint ChemometricModelType_User_defined_Output = 13037;

        /// <summary>
        /// The identifier for the ProcessVariableType_SourceName Variable.
        /// </summary>
        public const uint ProcessVariableType_SourceName = 13040;

        /// <summary>
        /// The identifier for the MVAModelType_User_defined_Output Variable.
        /// </summary>
        public const uint MVAModelType_User_defined_Output = 13045;

        /// <summary>
        /// The identifier for the MVAModelType_MainDataIndex Variable.
        /// </summary>
        public const uint MVAModelType_MainDataIndex = 13046;

        /// <summary>
        /// The identifier for the MVAModelType_User_defined_Output_AlarmState Variable.
        /// </summary>
        public const uint MVAModelType_User_defined_Output_AlarmState = 13049;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_WarningLimits Variable.
        /// </summary>
        public const uint MVAOutputParameterType_WarningLimits = 13054;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_AlarmLimits Variable.
        /// </summary>
        public const uint MVAOutputParameterType_AlarmLimits = 13055;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_AlarmState Variable.
        /// </summary>
        public const uint MVAOutputParameterType_AlarmState = 13056;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_VendorSpecificError Variable.
        /// </summary>
        public const uint MVAOutputParameterType_VendorSpecificError = 13057;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_Statistics Variable.
        /// </summary>
        public const uint MVAOutputParameterType_Statistics = 13058;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_Statistics_WarningLimits Variable.
        /// </summary>
        public const uint MVAOutputParameterType_Statistics_WarningLimits = 13059;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_Statistics_AlarmLimits Variable.
        /// </summary>
        public const uint MVAOutputParameterType_Statistics_AlarmLimits = 13060;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_Statistics_AlarmState Variable.
        /// </summary>
        public const uint MVAOutputParameterType_Statistics_AlarmState = 13061;

        /// <summary>
        /// The identifier for the MVAOutputParameterType_Statistics_VendorSpecificError Variable.
        /// </summary>
        public const uint MVAOutputParameterType_Statistics_VendorSpecificError = 13062;

        /// <summary>
        /// The identifier for the AlarmStateEnumeration_EnumValues Variable.
        /// </summary>
        public const uint AlarmStateEnumeration_EnumValues = 13063;

        /// <summary>
        /// The identifier for the OpcUaAdi_BinarySchema Variable.
        /// </summary>
        public const uint OpcUaAdi_BinarySchema = 13067;

        /// <summary>
        /// The identifier for the OpcUaAdi_BinarySchema_NamespaceUri Variable.
        /// </summary>
        public const uint OpcUaAdi_BinarySchema_NamespaceUri = 13069;

        /// <summary>
        /// The identifier for the OpcUaAdi_BinarySchema_Deprecated Variable.
        /// </summary>
        public const uint OpcUaAdi_BinarySchema_Deprecated = 8001;

        /// <summary>
        /// The identifier for the OpcUaAdi_XmlSchema Variable.
        /// </summary>
        public const uint OpcUaAdi_XmlSchema = 13064;

        /// <summary>
        /// The identifier for the OpcUaAdi_XmlSchema_NamespaceUri Variable.
        /// </summary>
        public const uint OpcUaAdi_XmlSchema_NamespaceUri = 13066;

        /// <summary>
        /// The identifier for the OpcUaAdi_XmlSchema_Deprecated Variable.
        /// </summary>
        public const uint OpcUaAdi_XmlSchema_Deprecated = 8003;
    }
    #endregion

    #region VariableType Identifiers
    /// <summary>
    /// A class that declares constants for all VariableTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class VariableTypes
    {
        /// <summary>
        /// The identifier for the EngineeringValueType VariableType.
        /// </summary>
        public const uint EngineeringValueType = 9380;

        /// <summary>
        /// The identifier for the ChemometricModelType VariableType.
        /// </summary>
        public const uint ChemometricModelType = 2007;

        /// <summary>
        /// The identifier for the ProcessVariableType VariableType.
        /// </summary>
        public const uint ProcessVariableType = 2008;

        /// <summary>
        /// The identifier for the MVAModelType VariableType.
        /// </summary>
        public const uint MVAModelType = 2009;

        /// <summary>
        /// The identifier for the MVAOutputParameterType VariableType.
        /// </summary>
        public const uint MVAOutputParameterType = 2010;
    }
    #endregion

    #region DataType Node Identifiers
    /// <summary>
    /// A class that declares constants for all DataTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class DataTypeIds
    {
        /// <summary>
        /// The identifier for the ExecutionCycleEnumeration DataType.
        /// </summary>
        public static readonly ExpandedNodeId ExecutionCycleEnumeration = new ExpandedNodeId(Opc.Ua.Adi.DataTypes.ExecutionCycleEnumeration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcquisitionResultStatusEnumeration DataType.
        /// </summary>
        public static readonly ExpandedNodeId AcquisitionResultStatusEnumeration = new ExpandedNodeId(Opc.Ua.Adi.DataTypes.AcquisitionResultStatusEnumeration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AlarmStateEnumeration DataType.
        /// </summary>
        public static readonly ExpandedNodeId AlarmStateEnumeration = new ExpandedNodeId(Opc.Ua.Adi.DataTypes.AlarmStateEnumeration, Opc.Ua.Adi.Namespaces.OpcUaAdi);
    }
    #endregion

    #region Method Node Identifiers
    /// <summary>
    /// A class that declares constants for all Methods in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class MethodIds
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_StreamIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_StreamIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_StreamIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AnalyserChannelType_StreamIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.StreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.StreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.StreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.StreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MNRDeviceStreamType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MNRDeviceStreamType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MNRDeviceStreamType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MNRDeviceStreamType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.SpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.ChromatographDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_CPIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_CPIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_CPIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_CPIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_CPIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_CPIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_CPIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_CPIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_GetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_GetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_SetConfiguration Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_SetConfiguration = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_SetConfiguration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GetConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_GetConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_GetConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_CompareConfigDataDigest Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_CompareConfigDataDigest = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_CompareConfigDataDigest, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_ResetAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_ResetAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_ResetAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_StartAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_StartAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_StartAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_StopAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_StopAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_StopAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_AbortAllChannels Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_AbortAllChannels = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_AbortAllChannels, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Open Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_Open = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_Open, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Close Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_Close = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_Close, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Read Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_Read = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_Read, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_Write Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_Write = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_Write, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_GetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_GetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_GetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ParameterSet_ConfigData_SetPosition Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ParameterSet_ConfigData_SetPosition = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ParameterSet_ConfigData_SetPosition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_GotoOperating Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_GotoOperating = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_GotoOperating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_GotoMaintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Reset Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Reset = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Reset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Start Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Start = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Start, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Stop Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Stop = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Stop, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Hold Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Hold = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Hold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Unhold Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Unhold = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Unhold, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Suspend Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Suspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Suspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Unsuspend Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Unsuspend = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Unsuspend, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Abort Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Abort = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Abort, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet_Clear Method.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet_Clear = new ExpandedNodeId(Opc.Ua.Adi.Methods.NMRDeviceType_ChannelIdentifier_MethodSet_Clear, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessorySlotType_AccessoryIdentifier_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessorySlotType_AccessoryIdentifier_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessorySlotType_AccessoryIdentifier_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessorySlotType_AccessoryIdentifier_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessoryType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessoryType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessoryType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.AccessoryType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the DetectorType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId DetectorType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.DetectorType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the DetectorType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId DetectorType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.DetectorType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the DetectorType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId DetectorType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.DetectorType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the DetectorType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId DetectorType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.DetectorType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SmartSamplingSystemType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SmartSamplingSystemType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SmartSamplingSystemType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SmartSamplingSystemType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SmartSamplingSystemType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SmartSamplingSystemType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SmartSamplingSystemType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SmartSamplingSystemType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SmartSamplingSystemType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SourceType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SourceType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SourceType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SourceType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SourceType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SourceType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SourceType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SourceType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SourceType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SourceType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId SourceType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.SourceType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the GcOvenType_Lock_InitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId GcOvenType_Lock_InitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.GcOvenType_Lock_InitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the GcOvenType_Lock_RenewLock Method.
        /// </summary>
        public static readonly ExpandedNodeId GcOvenType_Lock_RenewLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.GcOvenType_Lock_RenewLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the GcOvenType_Lock_ExitLock Method.
        /// </summary>
        public static readonly ExpandedNodeId GcOvenType_Lock_ExitLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.GcOvenType_Lock_ExitLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the GcOvenType_Lock_BreakLock Method.
        /// </summary>
        public static readonly ExpandedNodeId GcOvenType_Lock_BreakLock = new ExpandedNodeId(Opc.Ua.Adi.Methods.GcOvenType_Lock_BreakLock, Opc.Ua.Adi.Namespaces.OpcUaAdi);
    }
    #endregion

    #region Object Node Identifiers
    /// <summary>
    /// A class that declares constants for all Objects in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ObjectIds
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata Object.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata = new ExpandedNodeId(Opc.Ua.Adi.Objects.OpcUaAdiNamespaceMetadata, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Identification Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Identification = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_Identification, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ParameterSet_ConfigData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_FactorySettings Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_FactorySettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_FactorySettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AnalyserStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_AnalyserStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_AccessorySlotIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Powerup Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Powerup = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_Powerup, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Operating Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Operating = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_Operating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Local Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Local = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_Local, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Maintenance Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Maintenance = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_Maintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Shutdown Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Shutdown = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_Shutdown, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_PowerupToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_PowerupToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_PowerupToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToLocalTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToLocalTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_OperatingToLocalTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_LocalToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToMaintenanceTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToMaintenanceTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_LocalToMaintenanceTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToLocalTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToLocalTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_MaintenanceToLocalTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_OperatingToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_LocalToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_GroupIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_GroupIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_GroupIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionSettings Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_AcquisitionSettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_AcquisitionSettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionStatus Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_AcquisitionStatus = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_AcquisitionStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_AcquisitionData Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_AcquisitionData = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_AcquisitionData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ChemometricModelSettings Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ChemometricModelSettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_ChemometricModelSettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Context Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Context = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_StreamIdentifier_Context, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_AccessorySlotIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_LocalSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_MaintenanceSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveMode Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_SlaveMode = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_SlaveMode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Operating Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Operating = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_Operating, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Local Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Local = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_Local, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Maintenance Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Maintenance = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_Maintenance, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveModeToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_SlaveModeToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_SlaveModeToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToLocalTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToLocalTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_OperatingToLocalTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToMaintenanceTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToMaintenanceTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_OperatingToMaintenanceTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_LocalToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToMaintenanceTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToMaintenanceTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_LocalToMaintenanceTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToOperatingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToOperatingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_MaintenanceToOperatingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToLocalTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToLocalTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_MaintenanceToLocalTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToSlaveModeTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToSlaveModeTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_OperatingToSlaveModeTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToSlaveModeTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToSlaveModeTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_LocalToSlaveModeTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopped Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Stopped = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Stopped, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Resetting Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Resetting = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Resetting, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Idle Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Idle = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Idle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Starting Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Starting = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Starting, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Execute Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Execute = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Execute, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Completing Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Completing = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Completing, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Complete Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Complete = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Complete, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspending Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Suspending = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Suspending, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspended Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Suspended = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Suspended, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Holding Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Holding = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Holding, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Held Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Held = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Held, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unholding Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Unholding = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Unholding, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopping Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Stopping = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Stopping, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborting Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Aborting = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Aborting, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborted Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Aborted = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Aborted, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Clearing Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Clearing = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_Clearing, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_GroupIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_GroupIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_GroupIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_AcquisitionSettings Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_AcquisitionSettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_AcquisitionSettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_AcquisitionStatus Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_AcquisitionStatus = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_AcquisitionStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_AcquisitionData Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_AcquisitionData = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_AcquisitionData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ChemometricModelSettings Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ChemometricModelSettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_ChemometricModelSettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Context Object.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Context = new ExpandedNodeId(Opc.Ua.Adi.Objects.StreamType_Context, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionSettings Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_AcquisitionSettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_AcquisitionSettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionStatus Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_AcquisitionStatus = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_AcquisitionStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_AcquisitionData Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_AcquisitionData = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_AcquisitionData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_FactorySettings Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_FactorySettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceStreamType_FactorySettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceStreamType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_AcquisitionData Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_AcquisitionData = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceStreamType_AcquisitionData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ParameterSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_FactorySettings Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_FactorySettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_FactorySettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ParticleSizeMonitorDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.ChromatographDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.MassSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AcousticSpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_CPIdentifier_NetworkAddress Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_CPIdentifier_NetworkAddress = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_CPIdentifier_NetworkAddress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_MethodSet Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_MethodSet = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_MethodSet, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_ChannelStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_ChannelStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_SupportedTypes Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_AccessorySlotIdentifier_SupportedTypes = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_AccessorySlotIdentifier_SupportedTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.NMRDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessorySlotStateMachine Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessorySlotStateMachine = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotType_AccessorySlotStateMachine, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotType_AccessoryIdentifier, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotType_AccessoryIdentifier_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotType_AccessoryIdentifier_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType_AccessoryIdentifier_FactorySettings Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType_AccessoryIdentifier_FactorySettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotType_AccessoryIdentifier_FactorySettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Powerup Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Powerup = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Powerup, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Empty Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Empty = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Empty, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Inserting Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Inserting = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Inserting, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Installed Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Installed = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Installed, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Removing Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Removing = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Removing, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_Shutdown Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_Shutdown = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_Shutdown, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_PowerupToEmptyTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_PowerupToEmptyTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_PowerupToEmptyTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToInsertingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_EmptyToInsertingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_EmptyToInsertingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InsertingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InsertingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToRemovingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InsertingToRemovingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InsertingToRemovingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToInstalledTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InsertingToInstalledTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InsertingToInstalledTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToRemovingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InstalledToRemovingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InstalledToRemovingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_RemovingTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_RemovingTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToEmptyTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_RemovingToEmptyTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_RemovingToEmptyTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_EmptyToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_EmptyToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_EmptyToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InsertingToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InsertingToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InsertingToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_InstalledToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_InstalledToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_InstalledToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType_RemovingToShutdownTransition Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType_RemovingToShutdownTransition = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessorySlotStateMachineType_RemovingToShutdownTransition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Configuration Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Configuration = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessoryType_Configuration, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_Status Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_Status = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessoryType_Status, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType_FactorySettings Object.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType_FactorySettings = new ExpandedNodeId(Opc.Ua.Adi.Objects.AccessoryType_FactorySettings, Opc.Ua.Adi.Namespaces.OpcUaAdi);
    }
    #endregion

    #region ObjectType Node Identifiers
    /// <summary>
    /// A class that declares constants for all ObjectTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ObjectTypeIds
    {
        /// <summary>
        /// The identifier for the AnalyserDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserDeviceStateMachineType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelOperatingStateType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelOperatingStateType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelOperatingStateType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelLocalStateType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelLocalStateType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelLocalStateType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelMaintenanceStateType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelMaintenanceStateType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelMaintenanceStateType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelStateMachineType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelOperatingExecuteStateType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelOperatingExecuteStateType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannelOperatingExecuteStateType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannel_OperatingModeSubStateMachineType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AnalyserChannel_OperatingModeExecuteSubStateMachineType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId StreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.StreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.SpectrometerDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.MassSpectrometerDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.ParticleSizeMonitorDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AcousticSpectrometerDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.ChromatographDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.MNRDeviceStreamType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.SpectrometerDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.ParticleSizeMonitorDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.ChromatographDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.MassSpectrometerDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AcousticSpectrometerDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the NMRDeviceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId NMRDeviceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.NMRDeviceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AccessorySlotType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessorySlotStateMachineType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AccessorySlotStateMachineType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AccessorySlotStateMachineType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AccessoryType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId AccessoryType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.AccessoryType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the DetectorType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId DetectorType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.DetectorType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SmartSamplingSystemType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId SmartSamplingSystemType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.SmartSamplingSystemType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SourceType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId SourceType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.SourceType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the GcOvenType ObjectType.
        /// </summary>
        public static readonly ExpandedNodeId GcOvenType = new ExpandedNodeId(Opc.Ua.Adi.ObjectTypes.GcOvenType, Opc.Ua.Adi.Namespaces.OpcUaAdi);
    }
    #endregion

    #region ReferenceType Node Identifiers
    /// <summary>
    /// A class that declares constants for all ReferenceTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ReferenceTypeIds
    {
        /// <summary>
        /// The identifier for the HasDataSource ReferenceType.
        /// </summary>
        public static readonly ExpandedNodeId HasDataSource = new ExpandedNodeId(Opc.Ua.Adi.ReferenceTypes.HasDataSource, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the HasInput ReferenceType.
        /// </summary>
        public static readonly ExpandedNodeId HasInput = new ExpandedNodeId(Opc.Ua.Adi.ReferenceTypes.HasInput, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the HasOutput ReferenceType.
        /// </summary>
        public static readonly ExpandedNodeId HasOutput = new ExpandedNodeId(Opc.Ua.Adi.ReferenceTypes.HasOutput, Opc.Ua.Adi.Namespaces.OpcUaAdi);
    }
    #endregion

    #region Variable Node Identifiers
    /// <summary>
    /// A class that declares constants for all Variables in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class VariableIds
    {
        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceUri Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceUri = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceUri, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceVersion Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceVersion = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceVersion, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespacePublicationDate Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespacePublicationDate = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespacePublicationDate, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_IsNamespaceSubset Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_IsNamespaceSubset = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_IsNamespaceSubset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticNodeIdTypes Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_StaticNodeIdTypes = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_StaticNodeIdTypes, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticNumericNodeIdRange Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_StaticNumericNodeIdRange = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_StaticNumericNodeIdRange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_StaticStringNodeIdPattern Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_StaticStringNodeIdPattern = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_StaticStringNodeIdPattern, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Size Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Size = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Size, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Writable Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Writable = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Writable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_UserWritable Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_UserWritable = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_UserWritable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_OpenCount Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_OpenCount = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_OpenCount, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Open_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Open_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Open_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Open_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Open_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Close_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Close_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Close_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Read_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Read_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Read_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Read_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Read_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_Write_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_Write_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_Write_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_GetPosition_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_NamespaceFile_SetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultRolePermissions Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_DefaultRolePermissions = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_DefaultRolePermissions, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultUserRolePermissions Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_DefaultUserRolePermissions = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_DefaultUserRolePermissions, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the OpcUaAdiNamespaceMetadata_DefaultAccessRestrictions Variable.
        /// </summary>
        public static readonly ExpandedNodeId OpcUaAdiNamespaceMetadata_DefaultAccessRestrictions = new ExpandedNodeId(Opc.Ua.Adi.Variables.OpcUaAdiNamespaceMetadata_DefaultAccessRestrictions, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GetConfiguration_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_GetConfiguration_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_SetConfiguration_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_SetConfiguration_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_SetConfiguration_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_SetConfiguration_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_GetConfigDataDigest_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_CompareConfigDataDigest_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Size = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Size, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Writable = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Writable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_UserWritable = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_UserWritable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_OpenCount = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_OpenCount, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Open_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Open_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Open_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Open_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Close_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Close_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Read_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Read_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Read_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Read_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_Write_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_Write_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AnalyserStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AnalyserStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AnalyserStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AnalyserStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AnalyserStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AnalyserStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ParameterSet_ActiveStream, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_IsHotSwappable = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AccessorySlotIdentifier_IsHotSwappable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AccessorySlotIdentifier_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Powerup_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Powerup_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_Powerup_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Operating_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Operating_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_Operating_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Local_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Local_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_Local_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Maintenance_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Maintenance_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_Maintenance_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_Shutdown_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_Shutdown_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_Shutdown_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_PowerupToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_PowerupToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_PowerupToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToLocalTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_OperatingToLocalTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_OperatingToMaintenanceTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_LocalToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToMaintenanceTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_LocalToMaintenanceTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_MaintenanceToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToLocalTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_MaintenanceToLocalTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_OperatingToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_OperatingToShutdownTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_OperatingToShutdownTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_LocalToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_LocalToShutdownTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_LocalToShutdownTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserDeviceStateMachineType_MaintenanceToShutdownTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_MethodSet_StartSingleAcquisition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_MethodSet_StartSingleAcquisition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_ChannelId Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ParameterSet_ChannelId = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ParameterSet_ChannelId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ParameterSet_ActiveStream Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ParameterSet_ActiveStream = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ParameterSet_ActiveStream, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_StreamIdentifier_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_IsHotSwappable = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_AccessorySlotIdentifier_IsHotSwappable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_AccessorySlotIdentifier_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveMode_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_SlaveMode_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_SlaveMode_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Operating_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Operating_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_Operating_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Local_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Local_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_Local_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_Maintenance_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_Maintenance_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_Maintenance_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_SlaveModeToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_SlaveModeToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_SlaveModeToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToLocalTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingToLocalTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToMaintenanceTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingToMaintenanceTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToMaintenanceTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToMaintenanceTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalToMaintenanceTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToOperatingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToOperatingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceToOperatingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToLocalTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToLocalTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceToLocalTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_OperatingToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_OperatingToSlaveModeTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_OperatingToSlaveModeTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_LocalToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_LocalToSlaveModeTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_LocalToSlaveModeTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannelStateMachineType_MaintenanceToSlaveModeTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_OperatingExecuteSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopped_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Stopped_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Stopped_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Resetting_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Resetting_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Resetting_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Idle_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Idle_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Idle_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Starting_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Starting_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Starting_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Execute_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Execute_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Execute_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Completing_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Completing_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Completing_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Complete_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Complete_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Complete_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspending_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Suspending_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Suspending_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Suspended_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Suspended_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Suspended_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Unsuspending_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Holding_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Holding_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Holding_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Held_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Held_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Held_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Unholding_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Unholding_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Unholding_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Stopping_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Stopping_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Stopping_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborting_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Aborting_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Aborting_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Aborted_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Aborted_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Aborted_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_Clearing_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_Clearing_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_Clearing_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StoppedToResettingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ResettingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToIdleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_IdleToStartingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StartingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StartingToExecuteTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToCompletingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompletingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToCompleteTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppedTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToHoldingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HoldingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToHeldTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HeldToUnholdingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToHoldingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToExecuteTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToSuspendingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToSuspendedTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToUnsuspendingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToSuspendingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToExecuteTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StoppingToStoppedTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_AbortingToAbortedTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_AbortedToClearingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ClearingToStoppedTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_IdleToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StartingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HeldToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToStoppingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StoppedToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ResettingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_IdleToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StartingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_ExecuteToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompletingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_CompleteToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_SuspendedToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnsuspendingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HoldingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_HeldToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_UnholdingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeSubStateMachineType_StoppingToAbortingTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycle_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTrigger_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTrigger_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTrigger_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTrigger_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_Diagnostic_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTrigger_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_Cleaning_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResults_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSample_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem_StateNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem_StateNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystem_StateNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCalibrationTriggerTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCalibrationTriggerToExtractCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractCalibrationSampleToPrepareCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareCalibrationSampleToAnalyseCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseCalibrationSampleToPublishResultsTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForValidationTriggerTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForValidationTriggerToExtractValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractValidationSampleToPrepareValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareValidationSampleToAnalyseValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseValidationSampleToPublishResultsTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForSampleTriggerTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForSampleTriggerToExtractSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_ExtractSampleToPrepareSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PrepareSampleToAnalyseSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_AnalyseSampleToPublishResultsTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForDiagnosticTriggerTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForDiagnosticTriggerToDiagnosticTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_DiagnosticToPublishResultsTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_SelectExecutionCycleToWaitForCleaningTriggerTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_WaitForCleaningTriggerToCleaningTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleaningToPublishResultsTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToCleanupSamplingSystemTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_PublishResultsToEjectGrabSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_EjectGrabSampleToCleanupSamplingSystemTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition_TransitionNumber Variable.
        /// </summary>
        public static readonly ExpandedNodeId AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition_TransitionNumber = new ExpandedNodeId(Opc.Ua.Adi.Variables.AnalyserChannel_OperatingModeExecuteSubStateMachineType_CleanupSamplingSystemToSelectExecutionCycleTransition_TransitionNumber, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsForced Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_IsForced = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_IsForced, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastCalibrationTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_LastCalibrationTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_LastCalibrationTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastValidationTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_LastValidationTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_LastValidationTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_TimeBetweenSamples Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_TimeBetweenSamples = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_TimeBetweenSamples, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_RawData Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_RawData = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_RawData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Offset Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Offset = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Offset, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_CampaignId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_CampaignId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_CampaignId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_BatchId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_BatchId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_BatchId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_SubBatchId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_SubBatchId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_SubBatchId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_LotId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_LotId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_LotId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_MaterialId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_MaterialId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_MaterialId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Process Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Process = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Process, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Unit Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Unit = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Unit, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Operation Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Operation = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Operation, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_Phase Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_Phase = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_Phase, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_UserId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_UserId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_UserId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the StreamType_ParameterSet_SampleId Variable.
        /// </summary>
        public static readonly ExpandedNodeId StreamType_ParameterSet_SampleId = new ExpandedNodeId(Opc.Ua.Adi.Variables.StreamType_ParameterSet_SampleId, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1 Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1 = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_ActiveBackground1_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_SpectralRange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_SpectralRange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_SpectralRange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Resolution Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_Resolution = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_Resolution, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_RequestedNumberOfScans Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_RequestedNumberOfScans = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_RequestedNumberOfScans, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_Gain Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_Gain = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_Gain, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TransmittanceCutoff Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_TransmittanceCutoff = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_TransmittanceCutoff, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_AbsorbanceCutoff Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_AbsorbanceCutoff = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_AbsorbanceCutoff, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_NumberOfScansDone Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_NumberOfScansDone = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_NumberOfScansDone, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_TotalNumberOfScansDone Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_TotalNumberOfScansDone = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_TotalNumberOfScansDone, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_BackgroundAcquisitionTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_BackgroundAcquisitionTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_BackgroundAcquisitionTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1 Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1 = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceStreamType_ParameterSet_PendingBackground1_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MassSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_Background_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EngineeringUnits Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EngineeringUnits = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_EngineeringUnits, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_Title Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_Title = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_Title, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_AxisScaleType Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_AxisScaleType = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_AxisScaleType, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_XAxisDefinition Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_XAxisDefinition = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_SizeDistribution_XAxisDefinition, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceStreamType_ParameterSet_BackgroundAcquisitionTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceStreamType_ParameterSet_BackgroundAcquisitionTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceStreamType_ParameterSet_BackgroundAcquisitionTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.AcousticSpectrometerDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ChromatographDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ChromatographDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ChromatographDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_LastSampleTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_LastSampleTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_LastSampleTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_TimeBetweenSamples_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_IsActive Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_IsActive = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_IsActive, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycle Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_ExecutionCycle = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_ExecutionCycle, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_ExecutionCycleSubcode_EnumStrings, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_Progress Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_Progress = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_Progress, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionCounter Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_AcquisitionCounter = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_AcquisitionCounter, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionCounter_EURange Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_AcquisitionCounter_EURange = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_AcquisitionCounter_EURange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionResultStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_AcquisitionResultStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_AcquisitionResultStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_ScaledData Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_ScaledData = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_ScaledData, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the MNRDeviceStreamType_ParameterSet_AcquisitionEndTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId MNRDeviceStreamType_ParameterSet_AcquisitionEndTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.MNRDeviceStreamType_ParameterSet_AcquisitionEndTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_CPIdentifier_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_GetConfiguration_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_SetConfiguration_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_SetConfiguration_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_GetConfigDataDigest_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_MethodSet_CompareConfigDataDigest_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Size Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Size = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Size, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Writable Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Writable = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Writable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_UserWritable Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_UserWritable = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_UserWritable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_OpenCount Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_OpenCount = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_OpenCount, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Open_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Open_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Close_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Read_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Read_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_Write_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_GetPosition_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_ConfigData_SetPosition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AnalyserStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AnalyserStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AnalyserStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AnalyserStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_MethodSet_StartSingleAcquisition_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ParameterSet_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ParameterSet_DiagnosticStatus, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ParameterSet_ActiveStream, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_OperatingSubStateMachine_OperatingExecuteSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_LocalSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ChannelIdentifier_ChannelStateMachine_MaintenanceSubStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AccessorySlotIdentifier_IsHotSwappable, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AccessorySlotIdentifier_IsEnabled, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_CurrentState_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_AccessorySlotIdentifier_AccessorySlotStateMachine_LastTransition_Id, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the SpectrometerDeviceType_ParameterSet_SpectralRange Variable.
        /// </summary>
        public static readonly ExpandedNodeId SpectrometerDeviceType_ParameterSet_SpectralRange = new ExpandedNodeId(Opc.Ua.Adi.Variables.SpectrometerDeviceType_ParameterSet_SpectralRange, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_LockingUser Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_LockingUser = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_LockingUser, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RemainingLockTime Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_RemainingLockTime = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_RemainingLockTime, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock_InputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_InitLock_InputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_InitLock_InputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_InitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_InitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_InitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_RenewLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_RenewLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_RenewLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_ExitLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_ExitLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_ExitLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_Lock_BreakLock_OutputArguments Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_Lock_BreakLock_OutputArguments = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_Lock_BreakLock_OutputArguments, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_Locked Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_Locked = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_Locked, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summary>
        /// The identifier for the ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingClient Variable.
        /// </summary>
        public static readonly ExpandedNodeId ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingClient = new ExpandedNodeId(Opc.Ua.Adi.Variables.ParticleSizeMonitorDeviceType_CPIdentifier_Lock_LockingClient, Opc.Ua.Adi.Namespaces.OpcUaAdi);

        /// <summ