(declare (block) (standard-bindings) (extended-bindings))
(begin
  (bind-method! (macro-type-port) 'destroy close-port)
  (define std/misc/ports#copy-port
    (lambda (_in674_ _out675_)
      (if (not (input-port? _in674_))
          (error '"Expected input port" _in674_)
          (if (not (output-port? _out675_))
              (error '"Expected output port" _out675_)
              (if (macro-byte-port? _in674_)
                  (if (macro-byte-port? _out675_)
                      (std/misc/ports#try-copy-byte-port _in674_ _out675_)
                      (if (macro-character-port? _out675_)
                          (std/misc/ports#copy-character-port _in674_ _out675_)
                          (std/misc/ports#copy-object-port _in674_ _out675_)))
                  (if (macro-character-port? _in674_)
                      (if (macro-character-port? _out675_)
                          (std/misc/ports#copy-character-port _in674_ _out675_)
                          (std/misc/ports#copy-object-port _in674_ _out675_))
                      (std/misc/ports#copy-object-port _in674_ _out675_)))))))
  (define std/misc/ports#try-copy-byte-port
    (lambda (_in668_ _out669_)
      (macro-port-mutex-lock! _in668_)
      (if (or (let ((__tmp4276 (macro-character-port-rlo _in668_))
                    (__tmp4275 (macro-character-port-rhi _in668_)))
                (declare (not safe))
                (##fx< __tmp4276 __tmp4275))
              (macro-character-port-peek-eof? _in668_))
          (std/misc/ports#copy-character-port/lock _in668_ _out669_)
          (std/misc/ports#copy-byte-port/lock _in668_ _out669_))))
  (define std/misc/ports#copy-character-port
    (lambda (_in665_ _out666_)
      (macro-port-mutex-lock! _in665_)
      (std/misc/ports#copy-character-port/lock _in665_ _out666_)))
  (define std/misc/ports#copy-byte-port/lock
    (lambda (_in640_ _out641_)
      (letrec ((_loop643_
                (lambda ()
                  (let ((_rlo653_ (macro-byte-port-rlo _in640_))
                        (_rhi654_ (macro-byte-port-rhi _in640_)))
                    (if (let () (declare (not safe)) (##fx< _rlo653_ _rhi654_))
                        (let ((_rbuf656_ (macro-byte-port-rbuf _in640_)))
                          (with-exception-catcher
                           (lambda (_g657659_)
                             (if '#t
                                 (let ((_e662_ _g657659_))
                                   (if (eq? _in640_ _out641_)
                                       '#!void
                                       (macro-port-mutex-unlock! _in640_))
                                   (raise _e662_))
                                 (raise _g657659_)))
                           (lambda ()
                             (if (eq? _in640_ _out641_)
                                 (macro-port-mutex-unlock! _in640_)
                                 '#!void)
                             (write-subu8vector
                              _rbuf656_
                              _rlo653_
                              _rhi654_
                              _out641_)
                             (if (eq? _in640_ _out641_)
                                 (macro-port-mutex-lock! _in640_)
                                 '#!void)))
                          (macro-byte-port-rlo-set! _in640_ _rhi654_)
                          (_rbuf-fill644_))
                        (_rbuf-fill644_)))))
               (_rbuf-fill644_
                (lambda ()
                  (let* ((_rbuf647_ (macro-byte-port-rbuf _in640_))
                         (_res649_
                          ((macro-byte-port-rbuf-fill _in640_)
                           _in640_
                           (let ()
                             (declare (not safe))
                             (##u8vector-length _rbuf647_))
                           '#t)))
                    (if (eq? _res649_ ##err-code-EAGAIN)
                        (macro-port-mutex-unlock! _in640_)
                        (if (fixnum? _res649_)
                            (begin
                              (macro-port-mutex-unlock! _in640_)
                              (let ()
                                (declare (not safe))
                                (##raise-os-io-exception
                                 _in640_
                                 '#f
                                 _res649_
                                 std/misc/ports#copy-port
                                 _in640_
                                 _out641_)))
                            (if _res649_
                                (_loop643_)
                                (macro-port-mutex-unlock! _in640_))))))))
        (_loop643_))))
  (define std/misc/ports#copy-character-port/lock
    (lambda (_in615_ _out616_)
      (letrec ((_loop618_
                (lambda ()
                  (let ((_rlo628_ (macro-character-port-rlo _in615_))
                        (_rhi629_ (macro-character-port-rhi _in615_)))
                    (if (let () (declare (not safe)) (##fx< _rlo628_ _rhi629_))
                        (let ((_rbuf631_ (macro-character-port-rbuf _in615_)))
                          (with-exception-catcher
                           (lambda (_g632634_)
                             (if '#t
                                 (let ((_e637_ _g632634_))
                                   (if (eq? _in615_ _out616_)
                                       '#!void
                                       (macro-port-mutex-unlock! _in615_))
                                   (raise _e637_))
                                 (raise _g632634_)))
                           (lambda ()
                             (if (eq? _in615_ _out616_)
                                 (macro-port-mutex-unlock! _in615_)
                                 '#!void)
                             (write-substring
                              _rbuf631_
                              _rlo628_
                              _rhi629_
                              _out616_)
                             (if (eq? _in615_ _out616_)
                                 (macro-port-mutex-lock! _in615_)
                                 '#!void)))
                          (macro-character-port-rlo-set! _in615_ _rhi629_)
                          (_rbuf-fill619_))
                        (if (macro-character-port-peek-eof? _in615_)
                            (begin
                              (macro-character-port-peek-eof?-set! _in615_ '#f)
                              (macro-port-mutex-unlock! _in615_))
                            (_rbuf-fill619_))))))
               (_rbuf-fill619_
                (lambda ()
                  (let* ((_rbuf622_ (macro-character-port-rbuf _in615_))
                         (_res624_
                          ((macro-character-port-rbuf-fill _in615_)
                           _in615_
                           (let ()
                             (declare (not safe))
                             (##string-length _rbuf622_))
                           '#t)))
                    (if (eq? _res624_ ##err-code-EAGAIN)
                        (macro-port-mutex-unlock! _in615_)
                        (if (fixnum? _res624_)
                            (begin
                              (macro-port-mutex-unlock! _in615_)
                              (let ()
                                (declare (not safe))
                                (##raise-os-io-exception
                                 _in615_
                                 '#f
                                 _res624_
                                 std/misc/ports#copy-port
                                 _in615_
                                 _out616_)))
                            (if _res624_
                                (_loop618_)
                                (macro-port-mutex-unlock! _in615_))))))))
        (_loop618_))))
  (define std/misc/ports#copy-object-port
    (lambda (_in608_ _out609_)
      (let _lp611_ ((_next613_ (read _in608_)))
        (if (eof-object? _next613_)
            '#!void
            (begin (write _next613_ _out609_) (_lp611_ (read _in608_)))))))
  (define std/misc/ports#read-all-as-string
    (lambda (_port604_)
      (let ((_string606_ (read-line _port604_ '#f)))
        (if (string? _string606_) _string606_ '""))))
  (define std/misc/ports#read-file-string__%
    (lambda (_g4277_ _settings581584_ _file586_)
      (let ((_settings588_
             (if (eq? _settings581584_ absent-value) '() _settings581584_)))
        (call-with-input-file
         (cons 'path: (cons _file586_ _settings588_))
         std/misc/ports#read-all-as-string))))
  (define std/misc/ports#read-file-string__@
    (lambda (_keys580593_ . _args595_)
      (apply std/misc/ports#read-file-string__%
             _keys580593_
             (table-ref _keys580593_ 'settings: absent-value)
             _args595_)))
  (define std/misc/ports#read-file-string
    (lambda _args582601_
      (apply keyword-dispatch
             '#(settings:)
             std/misc/ports#read-file-string__@
             _args582601_)))
  (define std/misc/ports#read-all-as-lines__%
    (lambda (_g4278_ _separator545549_ _include-separator?546551_ _port553_)
      (let* ((_separator555_
              (if (eq? _separator545549_ absent-value)
                  '#\newline
                  _separator545549_))
             (_include-separator?557_
              (if (eq? _include-separator?546551_ absent-value)
                  '#f
                  _include-separator?546551_)))
        (let _loop559_ ((_lines561_ '()))
          (let ((_line563_
                 (read-line _port553_ _separator555_ _include-separator?557_)))
            (if (string? _line563_)
                (_loop559_ (cons _line563_ _lines561_))
                (reverse _lines561_)))))))
  (define std/misc/ports#read-all-as-lines__@
    (lambda (_keys544568_ . _args570_)
      (apply std/misc/ports#read-all-as-lines__%
             _keys544568_
             (table-ref _keys544568_ 'separator: absent-value)
             (table-ref _keys544568_ 'include-separator?: absent-value)
             _args570_)))
  (define std/misc/ports#read-all-as-lines
    (lambda _args547576_
      (apply keyword-dispatch
             '#(separator: #f include-separator?: #f)
             std/misc/ports#read-all-as-lines__@
             _args547576_)))
  (define std/misc/ports#read-file-lines__%
    (lambda (_g4279_ _settings520523_ _file525_)
      (let ((_settings527_
             (if (eq? _settings520523_ absent-value) '() _settings520523_)))
        (call-with-input-file
         (cons 'path: (cons _file525_ _settings527_))
         std/misc/ports#read-all-as-lines))))
  (define std/misc/ports#read-file-lines__@
    (lambda (_keys519532_ . _args534_)
      (apply std/misc/ports#read-file-lines__%
             _keys519532_
             (table-ref _keys519532_ 'settings: absent-value)
             _args534_)))
  (define std/misc/ports#read-file-lines
    (lambda _args521540_
      (apply keyword-dispatch
             '#(settings:)
             std/misc/ports#read-file-lines__@
             _args521540_)))
  (define std/misc/ports#read-all-as-u8vector__%
    (lambda (_port498_ _bufsize499_)
      (let _lp501_ ((_buf503_ (make-u8vector _bufsize499_)) (_u8s504_ '()))
        (let ((_len506_ (read-subu8vector _buf503_ '0 _bufsize499_ _port498_)))
          (if (= _len506_ _bufsize499_)
              (_lp501_ (make-u8vector _bufsize499_) (cons _buf503_ _u8s504_))
              (begin
                (u8vector-shrink! _buf503_ _len506_)
                (append-u8vectors (reverse (cons _buf503_ _u8s504_)))))))))
  (define std/misc/ports#read-all-as-u8vector__0
    (lambda (_port511_)
      (let ((_bufsize513_ '8192))
        (std/misc/ports#read-all-as-u8vector__% _port511_ _bufsize513_))))
  (define std/misc/ports#read-all-as-u8vector
    (lambda _g4281_
      (let ((_g4280_ (let () (declare (not safe)) (##length _g4281_))))
        (cond ((let () (declare (not safe)) (##fx= _g4280_ 1))
               (apply std/misc/ports#read-all-as-u8vector__0 _g4281_))
              ((let () (declare (not safe)) (##fx= _g4280_ 2))
               (apply std/misc/ports#read-all-as-u8vector__% _g4281_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/ports#read-all-as-u8vector
                _g4281_))))))
  (define std/misc/ports#read-file-u8vector__%
    (lambda (_g4282_ _settings465469_ _bufsize466471_ _file473_)
      (let* ((_settings475_
              (if (eq? _settings465469_ absent-value) '() _settings465469_))
             (_bufsize477_
              (if (eq? _bufsize466471_ absent-value) '8192 _bufsize466471_)))
        (call-with-input-file
         (cons 'path: (cons _file473_ _settings475_))
         (lambda (_g478480_)
           (std/misc/ports#read-all-as-u8vector__% _g478480_ _bufsize477_))))))
  (define std/misc/ports#read-file-u8vector__@
    (lambda (_keys464486_ . _args488_)
      (apply std/misc/ports#read-file-u8vector__%
             _keys464486_
             (table-ref _keys464486_ 'settings: absent-value)
             (table-ref _keys464486_ 'bufsize: absent-value)
             _args488_)))
  (define std/misc/ports#read-file-u8vector
    (lambda _args467494_
      (apply keyword-dispatch
             '#(settings: bufsize:)
             std/misc/ports#read-file-u8vector__@
             _args467494_)))
  (define std/misc/ports#write-file-string__%
    (lambda (_g4283_
             _settings432436_
             _newline-ending433438_
             _file440_
             _string441_)
      (let* ((_settings443_
              (if (eq? _settings432436_ absent-value) '() _settings432436_))
             (_newline-ending445_
              (if (eq? _newline-ending433438_ absent-value)
                  '#t
                  _newline-ending433438_)))
        (call-with-output-file
         (cons 'path: (cons _file440_ _settings443_))
         (lambda (_port447_)
           (display _string441_ _port447_)
           (if (and _newline-ending445_
                    (not (string-empty? _string441_))
                    (not (std/srfi/13#string-suffix?__0 '"\n" _string441_)))
               (newline _port447_)
               '#!void))))))
  (define std/misc/ports#write-file-string__@
    (lambda (_keys431452_ . _args454_)
      (apply std/misc/ports#write-file-string__%
             _keys431452_
             (table-ref _keys431452_ 'settings: absent-value)
             (table-ref _keys431452_ 'newline-ending: absent-value)
             _args454_)))
  (define std/misc/ports#write-file-string
    (lambda _args434460_
      (apply keyword-dispatch
             '#(settings: newline-ending:)
             std/misc/ports#write-file-string__@
             _args434460_)))
  (define std/misc/ports#write-file-lines__%
    (lambda (_g4284_
             _settings399403_
             _newline-ending400405_
             _file407_
             _list408_)
      (let* ((_settings410_
              (if (eq? _settings399403_ absent-value) '() _settings399403_))
             (_newline-ending412_
              (if (eq? _newline-ending400405_ absent-value)
                  '#t
                  _newline-ending400405_)))
        (letrec* ((_string414_ (string-join _list408_ '"\n")))
          (std/misc/ports#write-file-string__%
           '#f
           _settings410_
           _newline-ending412_
           _file407_
           _string414_)))))
  (define std/misc/ports#write-file-lines__@
    (lambda (_keys398419_ . _args421_)
      (apply std/misc/ports#write-file-lines__%
             _keys398419_
             (table-ref _keys398419_ 'settings: absent-value)
             (table-ref _keys398419_ 'newline-ending: absent-value)
             _args421_)))
  (define std/misc/ports#write-file-lines
    (lambda _args401427_
      (apply keyword-dispatch
             '#(settings: newline-ending:)
             std/misc/ports#write-file-lines__@
             _args401427_))))
