(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/db/postgresql-driver#postgresql::proto
    (let ((__tmp12568 (hash-copy std/actor/xdr#+xdr-default-type-registry+)))
      (declare (not safe))
      (##structure
       std/actor/proto#!protocol::t
       'std/db/postgresql-driver#postgresql
       '()
       __tmp12568)))
  (define std/db/postgresql-driver#postgresql.prepare::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.prepare::t
     '#f
     '2
     'postgresql.prepare
     '((final: . #t))
     '#f
     '(name sql)))
  (define std/db/postgresql-driver#postgresql.prepare?
    (make-struct-predicate std/db/postgresql-driver#postgresql.prepare::t))
  (define std/db/postgresql-driver#make-postgresql.prepare
    (lambda _$args6659_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.prepare::t
             _$args6659_)))
  (define std/db/postgresql-driver#postgresql.prepare-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.prepare::t
     '0))
  (define std/db/postgresql-driver#postgresql.prepare-sql
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.prepare::t
     '1))
  (define std/db/postgresql-driver#postgresql.prepare-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.prepare::t
     '0))
  (define std/db/postgresql-driver#postgresql.prepare-sql-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.prepare::t
     '1))
  (define std/db/postgresql-driver#xdr-postgresql.prepare-read
    (lambda (_buffer6657_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.prepare::t
       _buffer6657_)))
  (define std/db/postgresql-driver#xdr-postgresql.prepare-write
    (lambda (_obj6654_ _buffer6655_)
      (std/actor/xdr#xdr-write-struct _obj6654_ _buffer6655_)))
  (define std/db/postgresql-driver#postgresql.prepare::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.prepare-read
       std/db/postgresql-driver#xdr-postgresql.prepare-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.prepare::t
   std/db/postgresql-driver#postgresql.prepare::xdr)
  (define std/db/postgresql-driver#postgresql.exec::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.exec::t
     '#f
     '2
     'postgresql.exec
     '((final: . #t))
     '#f
     '(name params)))
  (define std/db/postgresql-driver#postgresql.exec?
    (make-struct-predicate std/db/postgresql-driver#postgresql.exec::t))
  (define std/db/postgresql-driver#make-postgresql.exec
    (lambda _$args6651_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.exec::t
             _$args6651_)))
  (define std/db/postgresql-driver#postgresql.exec-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.exec::t
     '0))
  (define std/db/postgresql-driver#postgresql.exec-params
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.exec::t
     '1))
  (define std/db/postgresql-driver#postgresql.exec-name-set!
    (make-struct-field-mutator std/db/postgresql-driver#postgresql.exec::t '0))
  (define std/db/postgresql-driver#postgresql.exec-params-set!
    (make-struct-field-mutator std/db/postgresql-driver#postgresql.exec::t '1))
  (define std/db/postgresql-driver#xdr-postgresql.exec-read
    (lambda (_buffer6649_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.exec::t
       _buffer6649_)))
  (define std/db/postgresql-driver#xdr-postgresql.exec-write
    (lambda (_obj6646_ _buffer6647_)
      (std/actor/xdr#xdr-write-struct _obj6646_ _buffer6647_)))
  (define std/db/postgresql-driver#postgresql.exec::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.exec-read
       std/db/postgresql-driver#xdr-postgresql.exec-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.exec::t
   std/db/postgresql-driver#postgresql.exec::xdr)
  (define std/db/postgresql-driver#postgresql.query::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.query::t
     '#f
     '2
     'postgresql.query
     '((final: . #t))
     '#f
     '(name params)))
  (define std/db/postgresql-driver#postgresql.query?
    (make-struct-predicate std/db/postgresql-driver#postgresql.query::t))
  (define std/db/postgresql-driver#make-postgresql.query
    (lambda _$args6643_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.query::t
             _$args6643_)))
  (define std/db/postgresql-driver#postgresql.query-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.query::t
     '0))
  (define std/db/postgresql-driver#postgresql.query-params
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.query::t
     '1))
  (define std/db/postgresql-driver#postgresql.query-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.query::t
     '0))
  (define std/db/postgresql-driver#postgresql.query-params-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.query::t
     '1))
  (define std/db/postgresql-driver#xdr-postgresql.query-read
    (lambda (_buffer6641_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.query::t
       _buffer6641_)))
  (define std/db/postgresql-driver#xdr-postgresql.query-write
    (lambda (_obj6638_ _buffer6639_)
      (std/actor/xdr#xdr-write-struct _obj6638_ _buffer6639_)))
  (define std/db/postgresql-driver#postgresql.query::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.query-read
       std/db/postgresql-driver#xdr-postgresql.query-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.query::t
   std/db/postgresql-driver#postgresql.query::xdr)
  (define std/db/postgresql-driver#postgresql.continue::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.continue::t
     '#f
     '1
     'postgresql.continue
     '((final: . #t))
     '#f
     '(token)))
  (define std/db/postgresql-driver#postgresql.continue?
    (make-struct-predicate std/db/postgresql-driver#postgresql.continue::t))
  (define std/db/postgresql-driver#make-postgresql.continue
    (lambda _$args6635_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.continue::t
             _$args6635_)))
  (define std/db/postgresql-driver#postgresql.continue-token
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.continue::t
     '0))
  (define std/db/postgresql-driver#postgresql.continue-token-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.continue::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.continue-read
    (lambda (_buffer6633_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.continue::t
       _buffer6633_)))
  (define std/db/postgresql-driver#xdr-postgresql.continue-write
    (lambda (_obj6630_ _buffer6631_)
      (std/actor/xdr#xdr-write-struct _obj6630_ _buffer6631_)))
  (define std/db/postgresql-driver#postgresql.continue::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.continue-read
       std/db/postgresql-driver#xdr-postgresql.continue-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.continue::t
   std/db/postgresql-driver#postgresql.continue::xdr)
  (define std/db/postgresql-driver#postgresql.reset::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.reset::t
     '#f
     '1
     'postgresql.reset
     '((final: . #t))
     '#f
     '(token)))
  (define std/db/postgresql-driver#postgresql.reset?
    (make-struct-predicate std/db/postgresql-driver#postgresql.reset::t))
  (define std/db/postgresql-driver#make-postgresql.reset
    (lambda _$args6627_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.reset::t
             _$args6627_)))
  (define std/db/postgresql-driver#postgresql.reset-token
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.reset::t
     '0))
  (define std/db/postgresql-driver#postgresql.reset-token-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.reset::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.reset-read
    (lambda (_buffer6625_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.reset::t
       _buffer6625_)))
  (define std/db/postgresql-driver#xdr-postgresql.reset-write
    (lambda (_obj6622_ _buffer6623_)
      (std/actor/xdr#xdr-write-struct _obj6622_ _buffer6623_)))
  (define std/db/postgresql-driver#postgresql.reset::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.reset-read
       std/db/postgresql-driver#xdr-postgresql.reset-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.reset::t
   std/db/postgresql-driver#postgresql.reset::xdr)
  (define std/db/postgresql-driver#postgresql.close::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.close::t
     '#f
     '1
     'postgresql.close
     '((final: . #t))
     '#f
     '(name)))
  (define std/db/postgresql-driver#postgresql.close?
    (make-struct-predicate std/db/postgresql-driver#postgresql.close::t))
  (define std/db/postgresql-driver#make-postgresql.close
    (lambda _$args6619_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.close::t
             _$args6619_)))
  (define std/db/postgresql-driver#postgresql.close-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.close::t
     '0))
  (define std/db/postgresql-driver#postgresql.close-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.close::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.close-read
    (lambda (_buffer6617_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.close::t
       _buffer6617_)))
  (define std/db/postgresql-driver#xdr-postgresql.close-write
    (lambda (_obj6614_ _buffer6615_)
      (std/actor/xdr#xdr-write-struct _obj6614_ _buffer6615_)))
  (define std/db/postgresql-driver#postgresql.close::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.close-read
       std/db/postgresql-driver#xdr-postgresql.close-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.close::t
   std/db/postgresql-driver#postgresql.close::xdr)
  (define std/db/postgresql-driver#postgresql.shutdown::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.shutdown::t
     '#f
     '0
     'postgresql.shutdown
     '((final: . #t))
     '#f
     '()))
  (define std/db/postgresql-driver#postgresql.shutdown?
    (make-struct-predicate std/db/postgresql-driver#postgresql.shutdown::t))
  (define std/db/postgresql-driver#make-postgresql.shutdown
    (lambda _$args6611_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.shutdown::t
             _$args6611_)))
  (define std/db/postgresql-driver#xdr-postgresql.shutdown-read
    (lambda (_buffer6609_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.shutdown::t
       _buffer6609_)))
  (define std/db/postgresql-driver#xdr-postgresql.shutdown-write
    (lambda (_obj6604_ _buffer6606_)
      (std/actor/xdr#xdr-write-struct _obj6604_ _buffer6606_)))
  (define std/db/postgresql-driver#postgresql.shutdown::xdr
    (let ()
      (declare (not safe))
      (##structure
       std/actor/xdr#XDR::t
       std/db/postgresql-driver#xdr-postgresql.shutdown-read
       std/db/postgresql-driver#xdr-postgresql.shutdown-write)))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.shutdown::t
   std/db/postgresql-driver#postgresql.shutdown::xdr)
  (define std/db/postgresql-driver#postgresql-prepare-statement!
    (lambda (_conn6583_ _name6584_ _sql6585_)
      (if (thread? _conn6583_)
          (let ((_driver6587_ _conn6583_))
            (let ((_token6589_
                   (let ()
                     (declare (not safe))
                     (##structure std/actor/proto#!token::t)))
                  (_dest6591_ _driver6587_))
              (std/actor/message#send-message__%
               _dest6591_
               (let ((__tmp12569
                      (let ()
                        (declare (not safe))
                        (##structure
                         std/db/postgresql-driver#postgresql.prepare::t
                         _name6584_
                         _sql6585_))))
                 (declare (not safe))
                 (##structure std/actor/proto#!call::t __tmp12569 _token6589_))
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token6589_ _dest6591_)))
          (let ((_$e6594_
                 (##structure-ref _conn6583_ '1 std/db/dbi#connection::t '#f)))
            (if _$e6594_
                ((lambda (_driver6597_)
                   (let ((_token6599_
                          (let ()
                            (declare (not safe))
                            (##structure std/actor/proto#!token::t)))
                         (_dest6601_ _driver6597_))
                     (std/actor/message#send-message__%
                      _dest6601_
                      (let ((__tmp12570
                             (let ()
                               (declare (not safe))
                               (##structure
                                std/db/postgresql-driver#postgresql.prepare::t
                                _name6584_
                                _sql6585_))))
                        (declare (not safe))
                        (##structure
                         std/actor/proto#!call::t
                         __tmp12570
                         _token6599_))
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token6599_ _dest6601_)))
                 _$e6594_)
                (error '"connection has been closed" _conn6583_))))))
  (define std/db/postgresql-driver#postgresql-close-statement!
    (lambda (_conn6574_ _name6575_)
      (let ((_driver65766578_
             (if (thread? _conn6574_)
                 _conn6574_
                 (##structure-ref
                  _conn6574_
                  '1
                  std/db/dbi#connection::t
                  '#f))))
        (if _driver65766578_
            (let ((_driver6581_ _driver65766578_))
              (std/actor/message#send-message__0
               _driver6581_
               (let ((__tmp12571
                      (let ()
                        (declare (not safe))
                        (##structure
                         std/db/postgresql-driver#postgresql.close::t
                         _name6575_))))
                 (declare (not safe))
                 (##structure std/actor/proto#!event::t __tmp12571))))
            '#f))))
  (define std/db/postgresql-driver#postgresql-exec!
    (lambda (_conn6553_ _name6554_ _bind6555_)
      (if (thread? _conn6553_)
          (let ((_driver6557_ _conn6553_))
            (let ((_token6559_
                   (let ()
                     (declare (not safe))
                     (##structure std/actor/proto#!token::t)))
                  (_dest6561_ _driver6557_))
              (std/actor/message#send-message__%
               _dest6561_
               (let ((__tmp12572
                      (let ()
                        (declare (not safe))
                        (##structure
                         std/db/postgresql-driver#postgresql.exec::t
                         _name6554_
                         _bind6555_))))
                 (declare (not safe))
                 (##structure std/actor/proto#!call::t __tmp12572 _token6559_))
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token6559_ _dest6561_)))
          (let ((_$e6564_
                 (##structure-ref _conn6553_ '1 std/db/dbi#connection::t '#f)))
            (if _$e6564_
                ((lambda (_driver6567_)
                   (let ((_token6569_
                          (let ()
                            (declare (not safe))
                            (##structure std/actor/proto#!token::t)))
                         (_dest6571_ _driver6567_))
                     (std/actor/message#send-message__%
                      _dest6571_
                      (let ((__tmp12573
                             (let ()
                               (declare (not safe))
                               (##structure
                                std/db/postgresql-driver#postgresql.exec::t
                                _name6554_
                                _bind6555_))))
                        (declare (not safe))
                        (##structure
                         std/actor/proto#!call::t
                         __tmp12573
                         _token6569_))
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token6569_ _dest6571_)))
                 _$e6564_)
                (error '"connection has been closed" _conn6553_))))))
  (define std/db/postgresql-driver#postgresql-query!
    (lambda (_conn6532_ _name6533_ _bind6534_)
      (if (thread? _conn6532_)
          (let ((_driver6536_ _conn6532_))
            (let ((_token6538_
                   (let ()
                     (declare (not safe))
                     (##structure std/actor/proto#!token::t)))
                  (_dest6540_ _driver6536_))
              (std/actor/message#send-message__%
               _dest6540_
               (let ((__tmp12574
                      (let ()
                        (declare (not safe))
                        (##structure
                         std/db/postgresql-driver#postgresql.query::t
                         _name6533_
                         _bind6534_))))
                 (declare (not safe))
                 (##structure std/actor/proto#!call::t __tmp12574 _token6538_))
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token6538_ _dest6540_)))
          (let ((_$e6543_
                 (##structure-ref _conn6532_ '1 std/db/dbi#connection::t '#f)))
            (if _$e6543_
                ((lambda (_driver6546_)
                   (let ((_token6548_
                          (let ()
                            (declare (not safe))
                            (##structure std/actor/proto#!token::t)))
                         (_dest6550_ _driver6546_))
                     (std/actor/message#send-message__%
                      _dest6550_
                      (let ((__tmp12575
                             (let ()
                               (declare (not safe))
                               (##structure
                                std/db/postgresql-driver#postgresql.query::t
                                _name6533_
                                _bind6534_))))
                        (declare (not safe))
                        (##structure
                         std/actor/proto#!call::t
                         __tmp12575
                         _token6548_))
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token6548_ _dest6550_)))
                 _$e6543_)
                (error '"connection has been closed" _conn6532_))))))
  (define std/db/postgresql-driver#postgresql-continue!
    (lambda (_conn6522_ _token6523_)
      (if (let ()
            (declare (not safe))
            (##structure-direct-instance-of?
             _token6523_
             'std/actor/proto#!token::t))
          (if (thread? _conn6522_)
              (let ((_driver6525_ _conn6522_))
                (std/actor/message#send-message__0
                 _driver6525_
                 (let ((__tmp12576
                        (let ()
                          (declare (not safe))
                          (##structure
                           std/db/postgresql-driver#postgresql.continue::t
                           _token6523_))))
                   (declare (not safe))
                   (##structure std/actor/proto#!event::t __tmp12576))))
              (let ((_$e6527_
                     (##structure-ref
                      _conn6522_
                      '1
                      std/db/dbi#connection::t
                      '#f)))
                (if _$e6527_
                    ((lambda (_driver6530_)
                       (std/actor/message#send-message__0
                        _driver6530_
                        (let ((__tmp12577
                               (let ()
                                 (declare (not safe))
                                 (##structure
                                  std/db/postgresql-driver#postgresql.continue::t
                                  _token6523_))))
                          (declare (not safe))
                          (##structure std/actor/proto#!event::t __tmp12577))))
                     _$e6527_)
                    (error '"connection has been closed" _conn6522_))))
          (error '"Bad argument; illegal query token" _token6523_))))
  (define std/db/postgresql-driver#postgresql-reset!
    (lambda (_conn6513_ _token6514_)
      (if (let ()
            (declare (not safe))
            (##structure-direct-instance-of?
             _token6514_
             'std/actor/proto#!token::t))
          (let ((_driver65156517_
                 (if (thread? _conn6513_)
                     _conn6513_
                     (##structure-ref
                      _conn6513_
                      '1
                      std/db/dbi#connection::t
                      '#f))))
            (if _driver65156517_
                (let ((_driver6520_ _driver65156517_))
                  (std/actor/message#send-message__0
                   _driver6520_
                   (let ((__tmp12578
                          (let ()
                            (declare (not safe))
                            (##structure
                             std/db/postgresql-driver#postgresql.reset::t
                             _token6514_))))
                     (declare (not safe))
                     (##structure std/actor/proto#!event::t __tmp12578))))
                '#f))
          (error '"Bad argument; illegal query token" _token6514_))))
  (define std/db/postgresql-driver#postgresql-close!
    (lambda (_conn6505_)
      (let ((_driver65066508_
             (if (thread? _conn6505_)
                 _conn6505_
                 (##structure-ref
                  _conn6505_
                  '1
                  std/db/dbi#connection::t
                  '#f))))
        (if _driver65066508_
            (let ((_driver6511_ _driver65066508_))
              (std/actor/message#send-message__0
               _driver6511_
               (let ((__tmp12579
                      (let ()
                        (declare (not safe))
                        (##structure
                         std/db/postgresql-driver#postgresql.shutdown::t))))
                 (declare (not safe))
                 (##structure std/actor/proto#!event::t __tmp12579))))
            '#f))))
  (define std/db/postgresql-driver#postgresql-connect!
    (lambda (_host5781_ _port5782_ _user5783_ _passwd5784_ _db5785_)
      (letrec* ((_sock5787_
                 (open-tcp-client
                  (cons 'server-address:
                        (cons _host5781_
                              (cons 'port-number: (cons _port5782_ '()))))))
                (_buffer5788_ (box (make-u8vector '1024)))
                (_start-driver!5789_
                 (lambda (_sock6408_)
                   (let _lp6410_ ()
                     (let* ((_g64126434_
                             (std/db/postgresql-driver#postgresql-recv!
                              _sock6408_
                              _buffer5788_))
                            (_else64166442_ (lambda () (_lp6410_))))
                       (let ((_K64286494_
                              (lambda ()
                                (gerbil/gambit/threads#spawn/name
                                 'postgresql-connection
                                 std/db/postgresql-driver#postgresql-driver
                                 _sock6408_)))
                             (_K64236473_
                              (lambda (_irritants6470_ _msg6471_)
                                (apply std/error#raise-io-error
                                       'postgresql-connect!
                                       _msg6471_
                                       _irritants6470_)))
                             (_K64186449_
                              (lambda (_irritants6446_ _msg6447_)
                                (std/logger#warning
                                 '"NOTICE: ~a ~a"
                                 _msg6447_
                                 _irritants6446_)
                                (_lp6410_))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g64126434_))
                             (let ((_tl64306499_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g64126434_)))
                                   (_hd64296497_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g64126434_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd64296497_ 'ReadyForQuery))
                                   (if (let ()
                                         (declare (not safe))
                                         (##pair? _tl64306499_))
                                       (let ((_tl64326502_
                                              (let ()
                                                (declare (not safe))
                                                (##cdr _tl64306499_))))
                                         (if (let ()
                                               (declare (not safe))
                                               (##null? _tl64326502_))
                                             (_K64286494_)
                                             (_lp6410_)))
                                       (_lp6410_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd64296497_ 'ErrorResponse))
                                       (if (let ()
                                             (declare (not safe))
                                             (##pair? _tl64306499_))
                                           (let ((_tl64276483_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _tl64306499_)))
                                                 (_hd64266481_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _tl64306499_))))
                                             (let ((_msg6486_ _hd64266481_)
                                                   (_irritants6488_
                                                    _tl64276483_))
                                               (_K64236473_
                                                _irritants6488_
                                                _msg6486_)))
                                           (_lp6410_))
                                       (if (let ()
                                             (declare (not safe))
                                             (##eq? _hd64296497_
                                                    'NoticeResponse))
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##pair? _tl64306499_))
                                               (let ((_tl64226459_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##cdr _tl64306499_)))
                                                     (_hd64216457_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##car _tl64306499_))))
                                                 (let ((_msg6462_ _hd64216457_)
                                                       (_irritants6464_
                                                        _tl64226459_))
                                                   (_K64186449_
                                                    _irritants6464_
                                                    _msg6462_)))
                                               (_lp6410_))
                                           (_lp6410_)))))
                             (_lp6410_)))))))
                (_authen-pass5959_
                 (lambda (_sock6330_ _pass6331_)
                   (std/db/postgresql-driver#postgresql-send!
                    _sock5787_
                    (cons 'PasswordMessage (cons _pass6331_ '())))
                   (let* ((_g63326349_
                           (std/db/postgresql-driver#postgresql-recv!
                            _sock5787_
                            _buffer5788_))
                          (_E63366353_
                           (lambda ()
                             (error '"No clause matching" _g63326349_))))
                     (let ((_K63436395_
                            (lambda () (_start-driver!5789_ _sock6330_)))
                           (_K63386374_
                            (lambda (_irritants6369_ _msg6371_)
                              (apply std/error#raise-io-error
                                     'postgresql-connect!
                                     _msg6371_
                                     _irritants6369_)))
                           (_K63376360_
                            (lambda (_unexpected6357_)
                              (std/error#raise-io-error
                               'postgresql-connect!
                               '"unexpected message"
                               _unexpected6357_))))
                       (if (let () (declare (not safe)) (##pair? _g63326349_))
                           (let ((_tl63456400_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _g63326349_)))
                                 (_hd63446398_
                                  (let ()
                                    (declare (not safe))
                                    (##car _g63326349_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##eq? _hd63446398_ 'AuthenticationRequest))
                                 (if (let ()
                                       (declare (not safe))
                                       (##pair? _tl63456400_))
                                     (let ((_tl63476405_
                                            (let ()
                                              (declare (not safe))
                                              (##cdr _tl63456400_)))
                                           (_hd63466403_
                                            (let ()
                                              (declare (not safe))
                                              (##car _tl63456400_))))
                                       (if (let ()
                                             (declare (not safe))
                                             (##eq? _hd63466403_
                                                    'AuthenticationOk))
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##null? _tl63476405_))
                                               (_K63436395_)
                                               (let ((_unexpected6363_
                                                      _g63326349_))
                                                 (_K63376360_
                                                  _unexpected6363_)))
                                           (let ((_unexpected6363_
                                                  _g63326349_))
                                             (_K63376360_ _unexpected6363_))))
                                     (let ((_unexpected6363_ _g63326349_))
                                       (_K63376360_ _unexpected6363_)))
                                 (if (let ()
                                       (declare (not safe))
                                       (##eq? _hd63446398_ 'ErrorResponse))
                                     (if (let ()
                                           (declare (not safe))
                                           (##pair? _tl63456400_))
                                         (let ((_tl63426384_
                                                (let ()
                                                  (declare (not safe))
                                                  (##cdr _tl63456400_)))
                                               (_hd63416382_
                                                (let ()
                                                  (declare (not safe))
                                                  (##car _tl63456400_))))
                                           (let ((_msg6387_ _hd63416382_)
                                                 (_irritants6389_
                                                  _tl63426384_))
                                             (_K63386374_
                                              _irritants6389_
                                              _msg6387_)))
                                         (let ((_unexpected6363_ _g63326349_))
                                           (_K63376360_ _unexpected6363_)))
                                     (let ((_unexpected6363_ _g63326349_))
                                       (_K63376360_ _unexpected6363_)))))
                           (let ((_unexpected6363_ _g63326349_))
                             (_K63376360_ _unexpected6363_)))))))
                (_authen-cleartext5960_
                 (lambda (_sock6328_)
                   (_authen-pass5959_ _sock6328_ _passwd5784_)))
                (_authen-md55961_
                 (lambda (_sock6310_ _salt6311_)
                   (letrec ((_md5-hex6313_
                             (lambda (_data6326_)
                               (std/text/hex#hex-encode__0
                                (std/crypto/digest#md5 _data6326_)))))
                     (let* ((_word16315_
                             (string-append _passwd5784_ _user5783_))
                            (_word26317_ (_md5-hex6313_ _word16315_))
                            (_word36319_
                             (u8vector-append
                              (std/text/utf8#string->utf8__0 _word26317_)
                              _salt6311_))
                            (_word46321_ (_md5-hex6313_ _word36319_))
                            (_pass6323_ (string-append '"md5" _word46321_)))
                       (_authen-pass5959_ _sock6310_ _pass6323_)))))
                (_authen-sasl5962_
                 (lambda (_sock6055_ _mechanisms6056_)
                   (if (member '"SCRAM-SHA-256" _mechanisms6056_)
                       '#!void
                       (std/error#raise-io-error
                        'postgresql-connect!
                        '"unknown SASL authentication mechanisms"
                        _mechanisms6056_))
                   (let* ((_ctx6058_
                           (std/net/sasl#scram-sha-256-begin '"" _passwd5784_))
                          (_msg6060_
                           (std/net/sasl#scram-client-first-message__0
                            _ctx6058_)))
                     (std/db/postgresql-driver#postgresql-send!
                      _sock5787_
                      (cons 'SASLInitialResponse
                            (cons '"SCRAM-SHA-256" (cons _msg6060_ '()))))
                     (let* ((_g60626081_
                             (std/db/postgresql-driver#postgresql-recv!
                              _sock5787_
                              _buffer5788_))
                            (_E60666085_
                             (lambda ()
                               (error '"No clause matching" _g60626081_))))
                       (let ((_K60736290_
                              (lambda (_msg6126_)
                                (std/net/sasl#scram-client-first-server-message!
                                 _ctx6058_
                                 _msg6126_)
                                (let ((_msg6128_
                                       (std/net/sasl#scram-client-final-message
                                        _ctx6058_)))
                                  (std/db/postgresql-driver#postgresql-send!
                                   _sock5787_
                                   (cons 'SASLResponse (cons _msg6128_ '())))
                                  (let* ((_g61296148_
                                          (std/db/postgresql-driver#postgresql-recv!
                                           _sock5787_
                                           _buffer5788_))
                                         (_E61336152_
                                          (lambda ()
                                            (error '"No clause matching"
                                                   _g61296148_))))
                                    (let ((_K61406270_
                                           (lambda (_msg6193_)
                                             (std/net/sasl#scram-client-final-server-message!
                                              _ctx6058_
                                              _msg6193_)
                                             (let* ((_g61946211_
                                                     (std/db/postgresql-driver#postgresql-recv!
                                                      _sock5787_
                                                      _buffer5788_))
                                                    (_E61986215_
                                                     (lambda ()
                                                       (error '"No clause matching"
                                                              _g61946211_))))
                                               (let ((_K62056257_
                                                      (lambda ()
                                                        (_start-driver!5789_
                                                         _sock6055_)))
                                                     (_K62006236_
                                                      (lambda (_irritants6231_
                                                               _msg6233_)
                                                        (apply std/error#raise-io-error
                                                               'postgresql-connect!
                                                               _msg6233_
                                                               _irritants6231_)))
                                                     (_K61996222_
                                                      (lambda (_unexpected6219_)
                                                        (std/error#raise-io-error
                                                         'postgresql-connect!
                                                         '"unexpected message"
                                                         _unexpected6219_))))
                                                 (if (let ()
                                                       (declare (not safe))
                                                       (##pair? _g61946211_))
                                                     (let ((_tl62076262_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##cdr _g61946211_)))
                                                           (_hd62066260_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##car _g61946211_))))
                                                       (if (let ()
                                                             (declare
                                                               (not safe))
                                                             (##eq? _hd62066260_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            'AuthenticationRequest))
                   (if (let () (declare (not safe)) (##pair? _tl62076262_))
                       (let ((_tl62096267_
                              (let ()
                                (declare (not safe))
                                (##cdr _tl62076262_)))
                             (_hd62086265_
                              (let ()
                                (declare (not safe))
                                (##car _tl62076262_))))
                         (if (let ()
                               (declare (not safe))
                               (##eq? _hd62086265_ 'AuthenticationOk))
                             (if (let ()
                                   (declare (not safe))
                                   (##null? _tl62096267_))
                                 (_K62056257_)
                                 (let ((_unexpected6225_ _g61946211_))
                                   (_K61996222_ _unexpected6225_)))
                             (let ((_unexpected6225_ _g61946211_))
                               (_K61996222_ _unexpected6225_))))
                       (let ((_unexpected6225_ _g61946211_))
                         (_K61996222_ _unexpected6225_)))
                   (if (let ()
                         (declare (not safe))
                         (##eq? _hd62066260_ 'ErrorResponse))
                       (if (let () (declare (not safe)) (##pair? _tl62076262_))
                           (let ((_tl62046246_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _tl62076262_)))
                                 (_hd62036244_
                                  (let ()
                                    (declare (not safe))
                                    (##car _tl62076262_))))
                             (let ((_msg6249_ _hd62036244_)
                                   (_irritants6251_ _tl62046246_))
                               (_K62006236_ _irritants6251_ _msg6249_)))
                           (let ((_unexpected6225_ _g61946211_))
                             (_K61996222_ _unexpected6225_)))
                       (let ((_unexpected6225_ _g61946211_))
                         (_K61996222_ _unexpected6225_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_unexpected6225_
                                                            _g61946211_))
                                                       (_K61996222_
                                                        _unexpected6225_)))))))
                                          (_K61356173_
                                           (lambda (_irritants6168_ _msg6170_)
                                             (apply std/error#raise-io-error
                                                    'postgresql-connect!
                                                    _msg6170_
                                                    _irritants6168_)))
                                          (_K61346159_
                                           (lambda (_unexpected6156_)
                                             (std/error#raise-io-error
                                              'postgresql-connect!
                                              '"unexpected message"
                                              _unexpected6156_))))
                                      (if (let ()
                                            (declare (not safe))
                                            (##pair? _g61296148_))
                                          (let ((_tl61426275_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##cdr _g61296148_)))
                                                (_hd61416273_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##car _g61296148_))))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##eq? _hd61416273_
                                                         'AuthenticationRequest))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##pair? _tl61426275_))
                                                    (let ((_tl61446280_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##cdr _tl61426275_)))
                                                          (_hd61436278_
                                                           (let ()
                                                             (declare
                                                               (not safe))
                                                             (##car _tl61426275_))))
                                                      (if (let ()
                                                            (declare
                                                              (not safe))
                                                            (##eq? _hd61436278_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           'AuthenticationSASLFinal))
                  (if (let () (declare (not safe)) (##pair? _tl61446280_))
                      (let ((_tl61466285_
                             (let ()
                               (declare (not safe))
                               (##cdr _tl61446280_)))
                            (_hd61456283_
                             (let ()
                               (declare (not safe))
                               (##car _tl61446280_))))
                        (if (let ()
                              (declare (not safe))
                              (##null? _tl61466285_))
                            (let ((_msg6288_ _hd61456283_))
                              (_K61406270_ _msg6288_))
                            (let ((_unexpected6162_ _g61296148_))
                              (_K61346159_ _unexpected6162_))))
                      (let ((_unexpected6162_ _g61296148_))
                        (_K61346159_ _unexpected6162_)))
                  (let ((_unexpected6162_ _g61296148_))
                    (_K61346159_ _unexpected6162_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (let ((_unexpected6162_
                                                           _g61296148_))
                                                      (_K61346159_
                                                       _unexpected6162_)))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##eq? _hd61416273_
                                                             'ErrorResponse))
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##pair? _tl61426275_))
                                                        (let ((_tl61396183_
                                                               (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (declare (not safe))
                         (##cdr _tl61426275_)))
                      (_hd61386181_
                       (let () (declare (not safe)) (##car _tl61426275_))))
                  (let ((_msg6186_ _hd61386181_)
                        (_irritants6188_ _tl61396183_))
                    (_K61356173_ _irritants6188_ _msg6186_)))
                (let ((_unexpected6162_ _g61296148_))
                  (_K61346159_ _unexpected6162_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (let ((_unexpected6162_
                                                           _g61296148_))
                                                      (_K61346159_
                                                       _unexpected6162_)))))
                                          (let ((_unexpected6162_ _g61296148_))
                                            (_K61346159_
                                             _unexpected6162_))))))))
                             (_K60686106_
                              (lambda (_irritants6101_ _msg6103_)
                                (apply std/error#raise-io-error
                                       'postgresql-connect!
                                       _msg6103_
                                       _irritants6101_)))
                             (_K60676092_
                              (lambda (_unexpected6089_)
                                (std/error#raise-io-error
                                 'postgresql-connect!
                                 '"unexpected message"
                                 _unexpected6089_))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g60626081_))
                             (let ((_tl60756295_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g60626081_)))
                                   (_hd60746293_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g60626081_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd60746293_
                                            'AuthenticationRequest))
                                   (if (let ()
                                         (declare (not safe))
                                         (##pair? _tl60756295_))
                                       (let ((_tl60776300_
                                              (let ()
                                                (declare (not safe))
                                                (##cdr _tl60756295_)))
                                             (_hd60766298_
                                              (let ()
                                                (declare (not safe))
                                                (##car _tl60756295_))))
                                         (if (let ()
                                               (declare (not safe))
                                               (##eq? _hd60766298_
                                                      'AuthenticationSASLContinue))
                                             (if (let ()
                                                   (declare (not safe))
                                                   (##pair? _tl60776300_))
                                                 (let ((_tl60796305_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##cdr _tl60776300_)))
                                                       (_hd60786303_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##car _tl60776300_))))
                                                   (if (let ()
                                                         (declare (not safe))
                                                         (##null? _tl60796305_))
                                                       (let ((_msg6308_
                                                              _hd60786303_))
                                                         (_K60736290_
                                                          _msg6308_))
                                                       (let ((_unexpected6095_
                                                              _g60626081_))
                                                         (_K60676092_
                                                          _unexpected6095_))))
                                                 (let ((_unexpected6095_
                                                        _g60626081_))
                                                   (_K60676092_
                                                    _unexpected6095_)))
                                             (let ((_unexpected6095_
                                                    _g60626081_))
                                               (_K60676092_
                                                _unexpected6095_))))
                                       (let ((_unexpected6095_ _g60626081_))
                                         (_K60676092_ _unexpected6095_)))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd60746293_ 'ErrorResponse))
                                       (if (let ()
                                             (declare (not safe))
                                             (##pair? _tl60756295_))
                                           (let ((_tl60726116_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _tl60756295_)))
                                                 (_hd60716114_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _tl60756295_))))
                                             (let ((_msg6119_ _hd60716114_)
                                                   (_irritants6121_
                                                    _tl60726116_))
                                               (_K60686106_
                                                _irritants6121_
                                                _msg6119_)))
                                           (let ((_unexpected6095_
                                                  _g60626081_))
                                             (_K60676092_ _unexpected6095_)))
                                       (let ((_unexpected6095_ _g60626081_))
                                         (_K60676092_ _unexpected6095_)))))
                             (let ((_unexpected6095_ _g60626081_))
                               (_K60676092_ _unexpected6095_)))))))))
        (std/logger#start-logger!__0)
        (with-exception-catcher
         (lambda (_g59635965_)
           (if '#t
               (let ((_e5968_ _g59635965_))
                 (close-port _sock5787_)
                 (raise _e5968_))
               (raise _g59635965_)))
         (lambda ()
           (std/db/postgresql-driver#postgresql-send!
            _sock5787_
            (cons 'StartupMessage
                  (cons (cons '"user" _user5783_)
                        (if _db5785_
                            (cons (cons '"database" _db5785_) '())
                            '()))))
           (let* ((_g59705987_
                   (std/db/postgresql-driver#postgresql-recv!
                    _sock5787_
                    _buffer5788_))
                  (_E59745991_
                   (lambda () (error '"No clause matching" _g59705987_))))
             (let ((_K59816038_
                    (lambda (_rest6032_ _what6033_)
                      (let ((_$e6035_ _what6033_))
                        (if (eq? 'AuthenticationOk _$e6035_)
                            (_start-driver!5789_ _sock5787_)
                            (if (eq? 'AuthenticationCleartextPassword _$e6035_)
                                (_authen-cleartext5960_ _sock5787_)
                                (if (eq? 'AuthenticationMD5Password _$e6035_)
                                    (_authen-md55961_
                                     _sock5787_
                                     (car _rest6032_))
                                    (if (eq? 'AuthenticationSASL _$e6035_)
                                        (_authen-sasl5962_
                                         _sock5787_
                                         _rest6032_)
                                        (std/error#raise-io-error
                                         'postgresql-connect!
                                         '"unsupported authentication mechanism"
                                         _what6033_))))))))
                   (_K59766012_
                    (lambda (_irritants6007_ _msg6009_)
                      (apply std/error#raise-io-error
                             'postgresql-connect!
                             _msg6009_
                             _irritants6007_)))
                   (_K59755998_
                    (lambda (_unexpected5995_)
                      (std/error#raise-io-error
                       'postgresql-connect!
                       '"unexpected message"
                       _unexpected5995_))))
               (if (let () (declare (not safe)) (##pair? _g59705987_))
                   (let ((_tl59836043_
                          (let () (declare (not safe)) (##cdr _g59705987_)))
                         (_hd59826041_
                          (let () (declare (not safe)) (##car _g59705987_))))
                     (if (let ()
                           (declare (not safe))
                           (##eq? _hd59826041_ 'AuthenticationRequest))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _tl59836043_))
                             (let ((_tl59856048_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _tl59836043_)))
                                   (_hd59846046_
                                    (let ()
                                      (declare (not safe))
                                      (##car _tl59836043_))))
                               (let ((_what6051_ _hd59846046_)
                                     (_rest6053_ _tl59856048_))
                                 (_K59816038_ _rest6053_ _what6051_)))
                             (let ((_unexpected6001_ _g59705987_))
                               (_K59755998_ _unexpected6001_)))
                         (if (let ()
                               (declare (not safe))
                               (##eq? _hd59826041_ 'ErrorResponse))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _tl59836043_))
                                 (let ((_tl59806022_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _tl59836043_)))
                                       (_hd59796020_
                                        (let ()
                                          (declare (not safe))
                                          (##car _tl59836043_))))
                                   (let ((_msg6025_ _hd59796020_)
                                         (_irritants6027_ _tl59806022_))
                                     (_K59766012_ _irritants6027_ _msg6025_)))
                                 (let ((_unexpected6001_ _g59705987_))
                                   (_K59755998_ _unexpected6001_)))
                             (let ((_unexpected6001_ _g59705987_))
                               (_K59755998_ _unexpected6001_)))))
                   (let ((_unexpected6001_ _g59705987_))
                     (_K59755998_ _unexpected6001_))))))))))
  (define std/db/postgresql-driver#postgresql-driver
    (lambda (_sock4600_)
      (letrec* ((_query-limit4602_ '1000)
                (_query-output4603_ '#f)
                (_query-token4604_ '#f)
                (_buffer4605_ (box (make-u8vector '1024)))
                (_deferred-close4606_ '())
                (_send!4607_
                 (lambda (_msg5779_)
                   (std/db/postgresql-driver#postgresql-send!
                    _sock4600_
                    _msg5779_)))
                (_recv!4608_
                 (lambda ()
                   (let* ((_g57305741_
                           (std/db/postgresql-driver#postgresql-recv!
                            _sock4600_
                            _buffer4605_))
                          (_E57335745_
                           (lambda ()
                             (error '"No clause matching" _g57305741_))))
                     (let ((_K57355762_
                            (lambda (_irritants5759_ _msg5760_)
                              (_notice!4609_ _msg5760_ _irritants5759_)
                              (_recv!4608_)))
                           (_K57345751_ (lambda (_msg5749_) _msg5749_)))
                       (if (let () (declare (not safe)) (##pair? _g57305741_))
                           (let ((_tl57375767_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _g57305741_)))
                                 (_hd57365765_
                                  (let ()
                                    (declare (not safe))
                                    (##car _g57305741_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##eq? _hd57365765_ 'NoticeResponse))
                                 (if (let ()
                                       (declare (not safe))
                                       (##pair? _tl57375767_))
                                     (let ((_tl57395772_
                                            (let ()
                                              (declare (not safe))
                                              (##cdr _tl57375767_)))
                                           (_hd57385770_
                                            (let ()
                                              (declare (not safe))
                                              (##car _tl57375767_))))
                                       (let ((_msg5775_ _hd57385770_)
                                             (_irritants5777_ _tl57395772_))
                                         (_K57355762_
                                          _irritants5777_
                                          _msg5775_)))
                                     (let ((_msg5754_ _g57305741_))
                                       (_K57345751_ _msg5754_)))
                                 (let ((_msg5754_ _g57305741_))
                                   (_K57345751_ _msg5754_))))
                           (let ((_msg5754_ _g57305741_))
                             (_K57345751_ _msg5754_)))))))
                (_notice!4609_
                 (lambda (_msg5727_ _irritants5728_)
                   (std/logger#warning
                    '"NOTICE: ~a ~a"
                    _msg5727_
                    _irritants5728_)))
                (_resync!4610_
                 (lambda ()
                   (let _lp5692_ ()
                     (let* ((_g56945704_ (_recv!4608_))
                            (_else56965712_ (lambda () (_lp5692_)))
                            (_K56985716_ (lambda () '#!void)))
                       (if (let () (declare (not safe)) (##pair? _g56945704_))
                           (let ((_hd56995719_
                                  (let ()
                                    (declare (not safe))
                                    (##car _g56945704_)))
                                 (_tl57005721_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _g56945704_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##eq? _hd56995719_ 'ReadyForQuery))
                                 (if (let ()
                                       (declare (not safe))
                                       (##pair? _tl57005721_))
                                     (let ((_tl57025724_
                                            (let ()
                                              (declare (not safe))
                                              (##cdr _tl57005721_))))
                                       (if (let ()
                                             (declare (not safe))
                                             (##null? _tl57025724_))
                                           '#!void
                                           (_lp5692_)))
                                     (_lp5692_))
                                 (_lp5692_)))
                           (_lp5692_))))))
                (_maybe-sync!4611_
                 (lambda ()
                   (if _query-output4603_
                       (begin
                         (std/misc/channel#channel-sync
                          _query-output4603_
                          (make-struct-instance
                           std/db/dbi#sql-error::t
                           '"portal expired"
                           '()
                           'postgresql-query-pump!))
                         (std/misc/channel#channel-close _query-output4603_)
                         (set! _query-output4603_ '#f)
                         (set! _query-token4604_ '#f)
                         (_resync!4610_)
                         (let ((_to-close5689_ _deferred-close4606_))
                           (set! _deferred-close4606_ '())
                           (for-each _close4616_ _to-close5689_)))
                       '#!void)))
                (_prepare4612_
                 (lambda (_name5533_ _sql5534_)
                   (letrec* ((_params5536_ '#f) (_cols5537_ '#f))
                     (_maybe-sync!4611_)
                     (_send!4607_
                      (cons 'Parse (cons _name5533_ (cons _sql5534_ '()))))
                     (_send!4607_
                      (cons 'Describe (cons '#\S (cons _name5533_ '()))))
                     (_send!4607_ '(Sync))
                     (let* ((_g55385551_ (_recv!4608_))
                            (_E55415555_
                             (lambda ()
                               (error '"No clause matching" _g55385551_))))
                       (let ((_K55475583_ (lambda () '#!void))
                             (_K55425562_
                              (lambda (_irritants5559_ _msg5560_)
                                (_resync!4610_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-prepare!
                                       _msg5560_
                                       _irritants5559_))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g55385551_))
                             (let ((_tl55495588_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g55385551_)))
                                   (_hd55485586_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g55385551_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd55485586_ 'ParseComplete))
                                   (if (let ()
                                         (declare (not safe))
                                         (##null? _tl55495588_))
                                       '#!void
                                       (_E55415555_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd55485586_ 'ErrorResponse))
                                       (if (let ()
                                             (declare (not safe))
                                             (##pair? _tl55495588_))
                                           (let ((_tl55465572_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _tl55495588_)))
                                                 (_hd55455570_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _tl55495588_))))
                                             (let ((_msg5575_ _hd55455570_)
                                                   (_irritants5577_
                                                    _tl55465572_))
                                               (_K55425562_
                                                _irritants5577_
                                                _msg5575_)))
                                           (_E55415555_))
                                       (_E55415555_))))
                             (_E55415555_))))
                     (let* ((_g55905603_ (_recv!4608_))
                            (_E55935607_
                             (lambda ()
                               (error '"No clause matching" _g55905603_))))
                       (let ((_K55995636_
                              (lambda (_query-params5634_)
                                (set! _params5536_ _query-params5634_)))
                             (_K55945614_
                              (lambda (_irritants5611_ _msg5612_)
                                (_resync!4610_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-prepare!
                                       _msg5612_
                                       _irritants5611_))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g55905603_))
                             (let ((_tl56015641_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g55905603_)))
                                   (_hd56005639_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g55905603_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd56005639_
                                            'ParameterDescription))
                                   (let ((_query-params5644_ _tl56015641_))
                                     (_K55995636_ _query-params5644_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd56005639_ 'ErrorResponse))
                                       (if (let ()
                                             (declare (not safe))
                                             (##pair? _tl56015641_))
                                           (let ((_tl55985624_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _tl56015641_)))
                                                 (_hd55975622_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _tl56015641_))))
                                             (let ((_msg5627_ _hd55975622_)
                                                   (_irritants5629_
                                                    _tl55985624_))
                                               (_K55945614_
                                                _irritants5629_
                                                _msg5627_)))
                                           (_E55935607_))
                                       (_E55935607_))))
                             (_E55935607_))))
                     (let* ((_g56455656_ (_recv!4608_))
                            (_E56485660_
                             (lambda ()
                               (error '"No clause matching" _g56455656_))))
                       (let ((_K56525678_
                              (lambda (_fields5676_)
                                (set! _cols5537_ _fields5676_)))
                             (_K56495665_ (lambda () (set! _cols5537_ '()))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g56455656_))
                             (let ((_tl56545683_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g56455656_)))
                                   (_hd56535681_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g56455656_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd56535681_ 'RowDescription))
                                   (let ((_fields5686_ _tl56545683_))
                                     (_K56525678_ _fields5686_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd56535681_ 'NoData))
                                       (if (let ()
                                             (declare (not safe))
                                             (##null? _tl56545683_))
                                           (_K56495665_)
                                           (_E56485660_))
                                       (_E56485660_))))
                             (_E56485660_))))
                     (_resync!4610_)
                     (values _params5536_ _cols5537_))))
                (_exec4613_
                 (lambda (_name5374_ _params5375_)
                   (letrec* ((_res5377_ '#f))
                     (_maybe-sync!4611_)
                     (_send!4607_
                      (cons 'Bind (cons '"" (cons _name5374_ _params5375_))))
                     (_send!4607_ '(Execute "" 1))
                     (_send!4607_ '(Sync))
                     (let* ((_g53785391_ (_recv!4608_))
                            (_E53815395_
                             (lambda ()
                               (error '"No clause matching" _g53785391_))))
                       (let ((_K53875423_ (lambda () '#!void))
                             (_K53825402_
                              (lambda (_irritants5399_ _msg5400_)
                                (_resync!4610_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-exec!
                                       _msg5400_
                                       _irritants5399_))))
                         (if (let ()
                               (declare (not safe))
                               (##pair? _g53785391_))
                             (let ((_tl53895428_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _g53785391_)))
                                   (_hd53885426_
                                    (let ()
                                      (declare (not safe))
                                      (##car _g53785391_))))
                               (if (let ()
                                     (declare (not safe))
                                     (##eq? _hd53885426_ 'BindComplete))
                                   (if (let ()
                                         (declare (not safe))
                                         (##null? _tl53895428_))
                                       '#!void
                                       (_E53815395_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd53885426_ 'ErrorResponse))
                                       (if (let ()
                                             (declare (not safe))
                                             (##pair? _tl53895428_))
                                           (let ((_tl53865412_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _tl53895428_)))
                                                 (_hd53855410_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _tl53895428_))))
                                             (let ((_msg5415_ _hd53855410_)
                                                   (_irritants5417_
                                                    _tl53865412_))
                                               (_K53825402_
                                                _irritants5417_
                                                _msg5415_)))
                                           (_E53815395_))
                                       (_E53815395_))))
                             (_E53815395_))))
                     (let _lp5431_ ()
                       (let* ((_g54335456_ (_recv!4608_))
                              (_E54385460_
                               (lambda ()
                                 (error '"No clause matching" _g54335456_))))
                         (let ((_K54525523_ (lambda (_cols5521_) (_lp5431_)))
                               (_K54475503_
                                (lambda (_tag5501_)
                                  (set! _res5377_ _tag5501_)))
                               (_K54445489_ (lambda () '#!void))
                               (_K54395467_
                                (lambda (_irritants5464_ _msg5465_)
                                  (_resync!4610_)
                                  (apply std/db/dbi#raise-sql-error
                                         'postgreql-exec
                                         _msg5465_
                                         _irritants5464_))))
                           (let ((___match1240112402_
                                  (lambda (_hd54455492_ _tl54465494_)
                                    (if (let ()
                                          (declare (not safe))
                                          (##eq? _hd54455492_
                                                 'EmptyQueryResponse))
                                        (if (let ()
                                              (declare (not safe))
                                              (##null? _tl54465494_))
                                            '#!void
                                            (_E54385460_))
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _hd54455492_
                                                     'ErrorResponse))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##pair? _tl54465494_))
                                                (let ((_tl54435477_
                                                       (let ()
                                                         (declare (not safe))
                                                         (##cdr _tl54465494_)))
                                                      (_hd54425475_
                                                       (let ()
                                                         (declare (not safe))
                                                         (##car _tl54465494_))))
                                                  (let ((_msg5480_
                                                         _hd54425475_)
                                                        (_irritants5482_
                                                         _tl54435477_))
                                                    (_K54395467_
                                                     _irritants5482_
                                                     _msg5480_)))
                                                (_E54385460_))
                                            (_E54385460_))))))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _g54335456_))
                                 (let ((_tl54545528_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _g54335456_)))
                                       (_hd54535526_
                                        (let ()
                                          (declare (not safe))
                                          (##car _g54335456_))))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd54535526_ 'DataRow))
                                       (let ((_cols5531_ _tl54545528_))
                                         (_K54525523_ _cols5531_))
                                       (if (let ()
                                             (declare (not safe))
                                             (##eq? _hd54535526_
                                                    'CommandComplete))
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##pair? _tl54545528_))
                                               (let ((_tl54515513_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##cdr _tl54545528_)))
                                                     (_hd54505511_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##car _tl54545528_))))
                                                 (if (let ()
                                                       (declare (not safe))
                                                       (##null? _tl54515513_))
                                                     (let ((_tag5516_
                                                            _hd54505511_))
                                                       (_K54475503_ _tag5516_))
                                                     (_E54385460_)))
                                               (_E54385460_))
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##eq? _hd54535526_
                                                        'PortalSuspended))
                                               (if (let ()
                                                     (declare (not safe))
                                                     (##null? _tl54545528_))
                                                   '#!void
                                                   (_E54385460_))
                                               (___match1240112402_
                                                _hd54535526_
                                                _tl54545528_)))))
                                 (_E54385460_))))))
                     (_resync!4610_)
                     _res5377_)))
                (_query-start4614_
                 (lambda (_name5316_ _params5317_)
                   (_maybe-sync!4611_)
                   (_send!4607_
                    (cons 'Bind (cons '"" (cons _name5316_ _params5317_))))
                   (_send!4607_ '(Execute "" 0))
                   (_send!4607_ '(Sync))
                   (let* ((_g53185331_ (_recv!4608_))
                          (_E53215335_
                           (lambda ()
                             (error '"No clause matching" _g53185331_))))
                     (let ((_K53275366_
                            (lambda ()
                              (let ((_ch5363_
                                     (let ((__obj12567
                                            (make-object
                                             std/misc/channel#channel::t
                                             '5)))
                                       (std/misc/channel#channel:::init!__%
                                        __obj12567
                                        _query-limit4602_)
                                       __obj12567))
                                    (_token5364_
                                     (let ()
                                       (declare (not safe))
                                       (##structure
                                        std/actor/proto#!token::t))))
                                (set! _query-output4603_ _ch5363_)
                                (set! _query-token4604_ _token5364_)
                                (values _ch5363_ _token5364_))))
                           (_K53225342_
                            (lambda (_irritants5339_ _msg5340_)
                              (_resync!4610_)
                              (apply std/db/dbi#raise-sql-error
                                     'postgresql-query!
                                     _msg5340_
                                     _irritants5339_))))
                       (if (let () (declare (not safe)) (##pair? _g53185331_))
                           (let ((_tl53295371_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _g53185331_)))
                                 (_hd53285369_
                                  (let ()
                                    (declare (not safe))
                                    (##car _g53185331_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##eq? _hd53285369_ 'BindComplete))
                                 (if (let ()
                                       (declare (not safe))
                                       (##null? _tl53295371_))
                                     (_K53275366_)
                                     (_E53215335_))
                                 (if (let ()
                                       (declare (not safe))
                                       (##eq? _hd53285369_ 'ErrorResponse))
                                     (if (let ()
                                           (declare (not safe))
                                           (##pair? _tl53295371_))
                                         (let ((_tl53265352_
                                                (let ()
                                                  (declare (not safe))
                                                  (##cdr _tl53295371_)))
                                               (_hd53255350_
                                                (let ()
                                                  (declare (not safe))
                                                  (##car _tl53295371_))))
                                           (let ((_msg5355_ _hd53255350_)
                                                 (_irritants5357_
                                                  _tl53265352_))
                                             (_K53225342_
                                              _irritants5357_
                                              _msg5355_)))
                                         (_E53215335_))
                                     (_E53215335_))))
                           (_E53215335_))))))
                (_query-pump4615_
                 (lambda ()
                   (call-with-current-continuation
                    (lambda (_break5212_)
                      (let _lp5214_ ()
                        (let* ((_g52165239_ (_recv!4608_))
                               (_E52215243_
                                (lambda ()
                                  (error '"No clause matching" _g52165239_))))
                          (let ((_K52355306_
                                 (lambda (_cols5304_)
                                   (if (std/misc/channel#channel-try-put
                                        _query-output4603_
                                        _cols5304_)
                                       (_lp5214_)
                                       (begin
                                         (std/misc/channel#channel-sync
                                          _query-output4603_
                                          _cols5304_
                                          _query-token4604_)
                                         (_break5212_)))))
                                (_K52305286_ (lambda (_tag5284_) '#!void))
                                (_K52275272_ (lambda () '#!void))
                                (_K52225250_
                                 (lambda (_irritants5247_ _msg5248_)
                                   (std/misc/channel#channel-sync
                                    _query-output4603_
                                    (make-struct-instance
                                     std/db/dbi#sql-error::t
                                     _msg5248_
                                     _irritants5247_
                                     'postgresql-query!)))))
                            (let ((___match1246312464_
                                   (lambda (_hd52285275_ _tl52295277_)
                                     (if (let ()
                                           (declare (not safe))
                                           (##eq? _hd52285275_
                                                  'EmptyQueryResponse))
                                         (if (let ()
                                               (declare (not safe))
                                               (##null? _tl52295277_))
                                             '#!void
                                             (_E52215243_))
                                         (if (let ()
                                               (declare (not safe))
                                               (##eq? _hd52285275_
                                                      'ErrorResponse))
                                             (if (let ()
                                                   (declare (not safe))
                                                   (##pair? _tl52295277_))
                                                 (let ((_tl52265260_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##cdr _tl52295277_)))
                                                       (_hd52255258_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##car _tl52295277_))))
                                                   (let ((_msg5263_
                                                          _hd52255258_)
                                                         (_irritants5265_
                                                          _tl52265260_))
                                                     (_K52225250_
                                                      _irritants5265_
                                                      _msg5263_)))
                                                 (_E52215243_))
                                             (_E52215243_))))))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _g52165239_))
                                  (let ((_tl52375311_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _g52165239_)))
                                        (_hd52365309_
                                         (let ()
                                           (declare (not safe))
                                           (##car _g52165239_))))
                                    (if (let ()
                                          (declare (not safe))
                                          (##eq? _hd52365309_ 'DataRow))
                                        (let ((_cols5314_ _tl52375311_))
                                          (_K52355306_ _cols5314_))
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _hd52365309_
                                                     'CommandComplete))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##pair? _tl52375311_))
                                                (let ((_tl52345296_
                                                       (let ()
                                                         (declare (not safe))
                                                         (##cdr _tl52375311_)))
                                                      (_hd52335294_
                                                       (let ()
                                                         (declare (not safe))
                                                         (##car _tl52375311_))))
                                                  (if (let ()
                                                        (declare (not safe))
                                                        (##null? _tl52345296_))
                                                      (let ((_tag5299_
                                                             _hd52335294_))
                                                        (_K52305286_
                                                         _tag5299_))
                                                      (_E52215243_)))
                                                (_E52215243_))
                                            (if (let ()
                                                  (declare (not safe))
                                                  (##eq? _hd52365309_
                                                         'PortalSuspended))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##null? _tl52375311_))
                                                    '#!void
                                                    (_E52215243_))
                                                (___match1246312464_
                                                 _hd52365309_
                                                 _tl52375311_)))))
                                  (_E52215243_))))))
                      (std/misc/channel#channel-close _query-output4603_)
                      (set! _query-output4603_ '#f)
                      (set! _query-token4604_ '#f)
                      (_resync!4610_)))))
                (_close4616_
                 (lambda (_name5157_)
                   (if _query-output4603_
                       (set! _deferred-close4606_
                             (cons _name5157_ _deferred-close4606_))
                       (begin
                         (_send!4607_
                          (cons 'Close (cons '#\S (cons _name5157_ '()))))
                         (_send!4607_ '(Sync))
                         (let* ((_g51585171_ (_recv!4608_))
                                (_E51615175_
                                 (lambda ()
                                   (error '"No clause matching" _g51585171_))))
                           (let ((_K51675203_ (lambda () '#!void))
                                 (_K51625182_
                                  (lambda (_irritants5179_ _msg5180_)
                                    (std/logger#warning
                                     '"error closing statement ~a: ~a"
                                     _name5157_
                                     _msg5180_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _g51585171_))
                                 (let ((_tl51695208_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _g51585171_)))
                                       (_hd51685206_
                                        (let ()
                                          (declare (not safe))
                                          (##car _g51585171_))))
                                   (if (let ()
                                         (declare (not safe))
                                         (##eq? _hd51685206_ 'CloseComplete))
                                       (if (let ()
                                             (declare (not safe))
                                             (##null? _tl51695208_))
                                           '#!void
                                           (_E51615175_))
                                       (if (let ()
                                             (declare (not safe))
                                             (##eq? _hd51685206_
                                                    'ErrorResponse))
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##pair? _tl51695208_))
                                               (let ((_tl51665192_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##cdr _tl51695208_)))
                                                     (_hd51655190_
                                                      (let ()
                                                        (declare (not safe))
                                                        (##car _tl51695208_))))
                                                 (let ((_msg5195_ _hd51655190_)
                                                       (_irritants5197_
                                                        _tl51665192_))
                                                   (_K51625182_
                                                    _irritants5197_
                                                    _msg5195_)))
                                               (_E51615175_))
                                           (_E51615175_))))
                                 (_E51615175_))))
                         (_resync!4610_)))))
                (_shutdown!4617_
                 (lambda ()
                   (_send!4607_ '(Sync))
                   (_resync!4610_)
                   (_send!4607_ '(Terminate))
                   (raise 'shutdown)))
                (_loop4828_
                 (lambda ()
                   (let _loop48394841_ ()
                     (let ((_next4845_ (thread-mailbox-next)))
                       ((lambda (_$message4848_)
                          (let* ((_$message48504860_ _$message4848_)
                                 (_else48524868_ (lambda () (_loop48394841_)))
                                 (_K48545133_
                                  (lambda (_$options4871_
                                           _$dest4873_
                                           _$source4875_
                                           _$value4877_)
                                    (let* ((_$value48944933_ _$value4877_)
                                           (_else49034941_
                                            (lambda () (_loop48394841_))))
                                      (let ((_K49275112_
                                             (lambda (_k5097_
                                                      _sql5098_
                                                      _name5099_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g51005102_)
                                                  (if '#t
                                                      (let ((_e5105_ _g51005102_))
                                                        (std/actor/message#send-message__%
                                                         _$source4875_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##structure
                                                            std/actor/proto#!error::t
                                                            _e5105_
                                                            _k5097_))
                                                         '#f
                                                         '#f)
                                                        (if (let ()
                                                              (declare
                                                                (not safe))
                                                              (##structure-instance-of?
                                                               _e5105_
                                                               'std/db/dbi#sql-error::t))
                                                            '#!void
                                                            (raise _e5105_)))
                                                      (raise _g51005102_)))
                                                (lambda ()
                                                  (let ((_res5109_
                                                         (_prepare4612_
                                                          _name5099_
                                                          _sql5098_)))
                                                    (std/actor/message#send-message__%
                                                     _$source4875_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##structure
                                                        std/actor/proto#!value::t
                                                        _res5109_
                                                        _k5097_))
                                                     '#f
                                                     '#f))))))
                                            (_K49225073_
                                             (lambda (_k5058_
                                                      _params5059_
                                                      _name5060_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g50615063_)
                                                  (if '#t
                                                      (let ((_e5066_ _g50615063_))
                                                        (std/actor/message#send-message__%
                                                         _$source4875_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##structure
                                                            std/actor/proto#!error::t
                                                            _e5066_
                                                            _k5058_))
                                                         '#f
                                                         '#f)
                                                        (if (let ()
                                                              (declare
                                                                (not safe))
                                                              (##structure-instance-of?
                                                               _e5066_
                                                               'std/db/dbi#sql-error::t))
                                                            '#!void
                                                            (raise _e5066_)))
                                                      (raise _g50615063_)))
                                                (lambda ()
                                                  (let ((_res5070_
                                                         (_exec4613_
                                                          _name5060_
                                                          _params5059_)))
                                                    (std/actor/message#send-message__%
                                                     _$source4875_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##structure
                                                        std/actor/proto#!value::t
                                                        _res5070_
                                                        _k5058_))
                                                     '#f
                                                     '#f))))))
                                            (_K49175033_
                                             (lambda (_k5018_
                                                      _params5019_
                                                      _name5020_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g50215023_)
                                                  (if '#t
                                                      (let ((_e5026_ _g50215023_))
                                                        (std/actor/message#send-message__%
                                                         _$source4875_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##structure
                                                            std/actor/proto#!error::t
                                                            _e5026_
                                                            _k5018_))
                                                         '#f
                                                         '#f)
                                                        (if (let ()
                                                              (declare
                                                                (not safe))
                                                              (##structure-instance-of?
                                                               _e5026_
                                                               'std/db/dbi#sql-error::t))
                                                            '#!void
                                                            (raise _e5026_)))
                                                      (raise _g50215023_)))
                                                (lambda ()
                                                  (let ((_res5030_
                                                         (_query-start4614_
                                                          _name5020_
                                                          _params5019_)))
                                                    (std/actor/message#send-message__%
                                                     _$source4875_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##structure
                                                        std/actor/proto#!value::t
                                                        _res5030_
                                                        _k5018_))
                                                     '#f
                                                     '#f))))
                                               (_query-pump4615_)))
                                            (_K49145003_
                                             (lambda (_token5001_)
                                               (thread-mailbox-extract-and-rewind)
                                               (if (eq? _token5001_
                                                        _query-token4604_)
                                                   (_query-pump4615_)
                                                   '#!void)))
                                            (_K49114986_
                                             (lambda (_token4984_)
                                               (thread-mailbox-extract-and-rewind)
                                               (if (eq? _token4984_
                                                        _query-token4604_)
                                                   (_maybe-sync!4611_)
                                                   '#!void)))
                                            (_K49084969_
                                             (lambda (_name4967_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_close4616_ _name4967_)))
                                            (_K49064957_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_shutdown!4617_)))
                                            (_K49054947_
                                             (lambda (_bogus4945_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message: ~a"
                                                _bogus4945_))))
                                        (let ((_try-match48985014_
                                               (lambda ()
                                                 (if (let ()
                                                       (declare (not safe))
                                                       (##structure-direct-instance-of?
                                                        _$value48944933_
                                                        'std/actor/proto#!event::t))
                                                     (let ((_e49155006_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _$value48944933_
                                                               '1))))
                                                       (if (let ()
                                                             (declare
                                                               (not safe))
                                                             (##structure-direct-instance-of?
                                                              _e49155006_
                                                              'std/db/postgresql-driver#postgresql.continue::t))
                                                           (let* ((_e49165009_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (let ()
                             (declare (not safe))
                             (##vector-ref _e49155006_ '1)))
                          (_token5012_ _e49165009_))
                     (_K49145003_ _token5012_))
                   (if (let ()
                         (declare (not safe))
                         (##structure-direct-instance-of?
                          _e49155006_
                          'std/db/postgresql-driver#postgresql.reset::t))
                       (let* ((_e49134992_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _e49155006_ '1)))
                              (_token4995_ _e49134992_))
                         (_K49114986_ _token4995_))
                       (if (let ()
                             (declare (not safe))
                             (##structure-direct-instance-of?
                              _e49155006_
                              'std/db/postgresql-driver#postgresql.close::t))
                           (let* ((_e49104975_
                                   (let ()
                                     (declare (not safe))
                                     (##vector-ref _e49155006_ '1)))
                                  (_name4978_ _e49104975_))
                             (_K49084969_ _name4978_))
                           (if (let ()
                                 (declare (not safe))
                                 (##structure-direct-instance-of?
                                  _e49155006_
                                  'std/db/postgresql-driver#postgresql.shutdown::t))
                               (_K49064957_)
                               (let ((_bogus4950_ _$value48944933_))
                                 (_K49054947_ _bogus4950_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_bogus4950_
                                                            _$value48944933_))
                                                       (_K49054947_
                                                        _bogus4950_))))))
                                          (if (let ()
                                                (declare (not safe))
                                                (##structure-direct-instance-of?
                                                 _$value48944933_
                                                 'std/actor/proto#!call::t))
                                              (let ((_e49285115_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##vector-ref
                                                        _$value48944933_
                                                        '1))))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##structure-direct-instance-of?
                                                       _e49285115_
                                                       'std/db/postgresql-driver#postgresql.prepare::t))
                                                    (let* ((_e49305118_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e49285115_
                                                               '1)))
                                                           (_e49315123_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e49285115_
                                                               '2)))
                                                           (_e49295128_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _$value48944933_
                                                               '2))))
                                                      (let ((_name5121_
                                                             _e49305118_)
                                                            (_sql5126_
                                                             _e49315123_)
                                                            (_k5131_ _e49295128_))
                                                        (_K49275112_
                                                         _k5131_
                                                         _sql5126_
                                                         _name5121_)))
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##structure-direct-instance-of?
                                                           _e49285115_
                                                           'std/db/postgresql-driver#postgresql.exec::t))
                                                        (let* ((_e49255079_
                                                                (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (declare (not safe))
                          (##vector-ref _e49285115_ '1)))
                       (_e49265084_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _e49285115_ '2)))
                       (_e49245089_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _$value48944933_ '2))))
                  (let ((_name5082_ _e49255079_)
                        (_params5087_ _e49265084_)
                        (_k5092_ _e49245089_))
                    (_K49225073_ _k5092_ _params5087_ _name5082_)))
                (if (let ()
                      (declare (not safe))
                      (##structure-direct-instance-of?
                       _e49285115_
                       'std/db/postgresql-driver#postgresql.query::t))
                    (let* ((_e49205039_
                            (let ()
                              (declare (not safe))
                              (##vector-ref _e49285115_ '1)))
                           (_e49215044_
                            (let ()
                              (declare (not safe))
                              (##vector-ref _e49285115_ '2)))
                           (_e49195049_
                            (let ()
                              (declare (not safe))
                              (##vector-ref _$value48944933_ '2))))
                      (let ((_name5042_ _e49205039_)
                            (_params5047_ _e49215044_)
                            (_k5052_ _e49195049_))
                        (_K49175033_ _k5052_ _params5047_ _name5042_)))
                    (let ((_bogus4950_ _$value48944933_))
                      (_K49054947_ _bogus4950_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_try-match48985014_))))))))
                            (if (let ()
                                  (declare (not safe))
                                  (##structure-direct-instance-of?
                                   _$message48504860_
                                   'std/actor/message#message::t))
                                (let* ((_e48555136_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message48504860_
                                           '1)))
                                       (_$value5139_ _e48555136_)
                                       (_e48565141_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message48504860_
                                           '2)))
                                       (_$source5144_ _e48565141_)
                                       (_e48575146_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message48504860_
                                           '3)))
                                       (_$dest5149_ _e48575146_)
                                       (_e48585151_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _$message48504860_
                                           '4)))
                                       (_$options5154_ _e48585151_))
                                  (_K48545133_
                                   _$options5154_
                                   _$dest5149_
                                   _$source5144_
                                   _$value5139_))
                                (_loop48394841_))))
                        _next4845_)))
                   (_loop4828_))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g48294832_)
              (if '#t
                  (let ((_e4835_ _g48294832_))
                    (if (eq? _e4835_ 'shutdown)
                        '#!void
                        (begin
                          (std/logger#log-error '"unhandled exception" _e4835_)
                          (raise _e4835_))))
                  (raise _g48294832_)))
            (lambda () (_loop4828_))))
         (lambda ()
           (if _query-output4603_
               (begin
                 (std/misc/channel#channel-sync
                  _query-output4603_
                  (make-struct-instance
                   std/db/dbi#sql-error::t
                   '"connection error"
                   '()
                   'postgresql-driver))
                 (std/misc/channel#channel-close _query-output4603_))
               '#!void)
           (close-port _sock4600_))))))
  (define std/db/postgresql-driver#postgresql-send!
    (lambda (_sock4515_ _msg4516_)
      (letrec ((_marshal-and-write4518_
                (lambda (_tid4587_ _body4588_ _marshal4589_)
                  (let* ((_payload4591_ (_marshal4589_ _body4588_))
                         (_payload-len4593_
                          (if (u8vector? _payload4591_)
                              (u8vector-length _payload4591_)
                              (if (let ()
                                    (declare (not safe))
                                    (##structure-instance-of?
                                     _payload4591_
                                     'std/net/bio/buffer#chunked-output-buffer::t))
                                  (std/net/bio/buffer#chunked-output-length
                                   _payload4591_)
                                  (std/error#raise-io-error
                                   'postgresql-send!
                                   '"unexpected payload"
                                   _tid4587_
                                   _body4588_
                                   _payload4591_)))))
                    (if _tid4587_ (write-u8 _tid4587_ _sock4515_) '#!void)
                    (_write-u324519_
                     (let () (declare (not safe)) (##fx+ _payload-len4593_ '4))
                     _sock4515_)
                    (if (u8vector? _payload4591_)
                        (let ((_len4596_ (u8vector-length _payload4591_)))
                          (if (let ()
                                (declare (not safe))
                                (##fx> _len4596_ '0))
                              (write-subu8vector
                               _payload4591_
                               '0
                               _len4596_
                               _sock4515_)
                              '#!void))
                        (for-each
                         (lambda (_u8v4598_)
                           (write-subu8vector
                            _u8v4598_
                            '0
                            (u8vector-length _u8v4598_)
                            _sock4515_))
                         (std/net/bio/buffer#chunked-output-chunks
                          _payload4591_)))
                    (force-output _sock4515_))))
               (_write-u324519_
                (lambda (_u324584_ _sock4585_)
                  (write-u8
                   (let ((__tmp12580
                          (let ()
                            (declare (not safe))
                            (##fxarithmetic-shift-right _u324584_ '24))))
                     (declare (not safe))
                     (##fxand __tmp12580 '255))
                   _sock4585_)
                  (write-u8
                   (let ((__tmp12581
                          (let ()
                            (declare (not safe))
                            (##fxarithmetic-shift-right _u324584_ '16))))
                     (declare (not safe))
                     (##fxand __tmp12581 '255))
                   _sock4585_)
                  (write-u8
                   (let ((__tmp12582
                          (let ()
                            (declare (not safe))
                            (##fxarithmetic-shift-right _u324584_ '8))))
                     (declare (not safe))
                     (##fxand __tmp12582 '255))
                   _sock4585_)
                  (write-u8
                   (let () (declare (not safe)) (##fxand _u324584_ '255))
                   _sock4585_))))
        (let* ((_msg45204527_ _msg4516_)
               (_E45224531_
                (lambda () (error '"No clause matching" _msg45204527_)))
               (_K45234572_
                (lambda (_body4534_ _tag4535_)
                  (let ((_$e4537_
                         (table-ref
                          std/db/postgresql-driver#+frontend-messages+
                          _tag4535_
                          '#f)))
                    (if _$e4537_
                        ((lambda (_e45394541_)
                           (let* ((_g45434550_ _e45394541_)
                                  (_E45454554_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _g45434550_)))
                                  (_K45464560_
                                   (lambda (_marshal4557_ _tid4558_)
                                     (_marshal-and-write4518_
                                      _tid4558_
                                      _body4534_
                                      _marshal4557_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _g45434550_))
                                 (let ((_hd45474563_
                                        (let ()
                                          (declare (not safe))
                                          (##car _g45434550_)))
                                       (_tl45484565_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _g45434550_))))
                                   (let* ((_tid4568_ _hd45474563_)
                                          (_marshal4570_ _tl45484565_))
                                     (_K45464560_ _marshal4570_ _tid4568_)))
                                 (_E45454554_))))
                         _$e4537_)
                        (if (eq? _tag4535_ 'StartupMessage)
                            (_marshal-and-write4518_
                             '#f
                             _body4534_
                             std/db/postgresql-driver#marshal-startup)
                            (std/error#raise-io-error
                             'postgresql-send!
                             '"cannot marshal; unknown message tag"
                             _msg4516_)))))))
          (if (let () (declare (not safe)) (##pair? _msg45204527_))
              (let ((_hd45244575_
                     (let () (declare (not safe)) (##car _msg45204527_)))
                    (_tl45254577_
                     (let () (declare (not safe)) (##cdr _msg45204527_))))
                (let* ((_tag4580_ _hd45244575_) (_body4582_ _tl45254577_))
                  (_K45234572_ _body4582_ _tag4580_)))
              (_E45224531_))))))
  (define std/db/postgresql-driver#postgresql-recv!
    (lambda (_sock4441_ _buf4442_)
      (letrec ((_read-u324444_
                (lambda (_sock4505_ _u8v4506_)
                  (let ((_rd4508_
                         (read-subu8vector _u8v4506_ '0 '4 _sock4505_)))
                    (if (let () (declare (not safe)) (##fx< _rd4508_ '4))
                        (std/error#raise-io-error
                         'postgresql-recv!
                         '"premature end of input"
                         _rd4508_)
                        (let ((_$e4510_
                               (let ((__tmp12583
                                      (let ()
                                        (declare (not safe))
                                        (##u8vector-ref _u8v4506_ '0))))
                                 (declare (not safe))
                                 (##fxarithmetic-shift-left? __tmp12583 '24))))
                          (if _$e4510_
                              ((lambda (_bits4513_)
                                 (let ((__tmp12587
                                        (let ((__tmp12588
                                               (let ()
                                                 (declare (not safe))
                                                 (##u8vector-ref
                                                  _u8v4506_
                                                  '1))))
                                          (declare (not safe))
                                          (##fxarithmetic-shift-left
                                           __tmp12588
                                           '16)))
                                       (__tmp12585
                                        (let ((__tmp12586
                                               (let ()
                                                 (declare (not safe))
                                                 (##u8vector-ref
                                                  _u8v4506_
                                                  '2))))
                                          (declare (not safe))
                                          (##fxarithmetic-shift-left
                                           __tmp12586
                                           '8)))
                                       (__tmp12584
                                        (let ()
                                          (declare (not safe))
                                          (##u8vector-ref _u8v4506_ '3))))
                                   (declare (not safe))
                                   (##fxior _bits4513_
                                            __tmp12587
                                            __tmp12585
                                            __tmp12584)))
                               _$e4510_)
                              (bitwise-ior
                               (arithmetic-shift
                                (let ()
                                  (declare (not safe))
                                  (##u8vector-ref _u8v4506_ '0))
                                '24)
                               (let ((__tmp12589
                                      (let ()
                                        (declare (not safe))
                                        (##u8vector-ref _u8v4506_ '1))))
                                 (declare (not safe))
                                 (##fxarithmetic-shift-left __tmp12589 '16))
                               (let ((__tmp12590
                                      (let ()
                                        (declare (not safe))
                                        (##u8vector-ref _u8v4506_ '2))))
                                 (declare (not safe))
                                 (##fxarithmetic-shift-left __tmp12590 '8))
                               (let ()
                                 (declare (not safe))
                                 (##u8vector-ref _u8v4506_ '3))))))))))
        (let* ((_tid4446_ (read-u8 _sock4441_))
               (_g12591_
                (if (eof-object? _tid4446_)
                    (std/error#raise-io-error
                     'postgresql-recv!
                     '"connection closed")
                    '#!void))
               (_payload-len4449_
                (_read-u324444_ _sock4441_ (unbox _buf4442_)))
               (_payload-len4451_
                (let () (declare (not safe)) (##fx- _payload-len4449_ '4)))
               (_u8buf4457_
                (let ((_u8buf4453_ (unbox _buf4442_)))
                  (if (let ((__tmp12592 (u8vector-length _u8buf4453_)))
                        (declare (not safe))
                        (##fx< __tmp12592 _payload-len4451_))
                      (let ((_u8buf4455_ (make-u8vector _payload-len4451_)))
                        (set-box! _buf4442_ _u8buf4455_)
                        _u8buf4455_)
                      _u8buf4453_)))
               (_rd4459_
                (if (let () (declare (not safe)) (##fx> _payload-len4451_ '0))
                    (read-subu8vector
                     _u8buf4457_
                     '0
                     _payload-len4451_
                     _sock4441_)
                    '0))
               (_g12593_
                (if (let ()
                      (declare (not safe))
                      (##fx< _rd4459_ _payload-len4451_))
                    (std/error#raise-io-error
                     'postgresql-recv!
                     '"premature end of input"
                     _rd4459_
                     _tid4446_
                     _payload-len4451_)
                    '#!void))
               (_bio4462_
                (std/net/bio/buffer#open-input-buffer__%
                 _u8buf4457_
                 '0
                 _payload-len4451_)))
          (let ((_$e4465_
                 (vector-ref
                  std/db/postgresql-driver#+backend-messages+
                  _tid4446_)))
            (if _$e4465_
                ((lambda (_e44674469_)
                   (let* ((_g44714478_ _e44674469_)
                          (_E44734482_
                           (lambda ()
                             (error '"No clause matching" _g44714478_)))
                          (_K44744493_
                           (lambda (_unmarshal4485_ _tag4486_)
                             (let* ((_body4488_ (_unmarshal4485_ _bio4462_))
                                    (_msg4490_ (cons _tag4486_ _body4488_)))
                               _msg4490_))))
                     (if (let () (declare (not safe)) (##pair? _g44714478_))
                         (let ((_hd44754496_
                                (let ()
                                  (declare (not safe))
                                  (##car _g44714478_)))
                               (_tl44764498_
                                (let ()
                                  (declare (not safe))
                                  (##cdr _g44714478_))))
                           (let* ((_tag4501_ _hd44754496_)
                                  (_unmarshal4503_ _tl44764498_))
                             (_K44744493_ _unmarshal4503_ _tag4501_)))
                         (_E44734482_))))
                 _$e4465_)
                (std/error#raise-io-error
                 'postgresql-recv!
                 '"unexpected backend message"
                 _tid4446_)))))))
  (define std/db/postgresql-driver#unmarshal-ignore
    (lambda (_bio4439_) '(...)))
  (define std/db/postgresql-driver#unmarshal-empty (lambda (_bio4437_) '()))
  (define std/db/postgresql-driver#unmarshal-authen-request
    (lambda (_bio4409_)
      (let* ((_t4411_ (std/net/bio/input#bio-read-u32 _bio4409_))
             (_$e4413_ _t4411_))
        (let ((_default44154419_ (lambda () (cons _t4411_ (cons '... '()))))
              (_table44164421_ '#(0 #f 1 2 #f 3 4 5 6 7 8 9 10)))
          (if (fixnum? _$e4413_)
              (if (and (let () (declare (not safe)) (##fx>= _$e4413_ '0))
                       (let () (declare (not safe)) (##fx< _$e4413_ '13)))
                  (let ((_x4424_ (let ()
                                   (declare (not safe))
                                   (##vector-ref _table44164421_ _$e4413_))))
                    (if _x4424_
                        (if (let () (declare (not safe)) (##fx< _x4424_ '5))
                            (if (let ()
                                  (declare (not safe))
                                  (##fx< _x4424_ '2))
                                (if (let ()
                                      (declare (not safe))
                                      (##fx= _x4424_ '0))
                                    '(AuthenticationOk)
                                    '(AuthenticationKerberosV5))
                                (if (let ()
                                      (declare (not safe))
                                      (##fx= _x4424_ '2))
                                    '(AuthenticationCleartextPassword)
                                    (if (let ()
                                          (declare (not safe))
                                          (##fx= _x4424_ '3))
                                        (let ((_salt4427_ (make-u8vector '4)))
                                          (std/net/bio/input#bio-read-bytes
                                           _salt4427_
                                           _bio4409_)
                                          (cons 'AuthenticationMD5Password
                                                (cons _salt4427_ '())))
                                        '(AuthenticationSCMCredential))))
                            (if (let ()
                                  (declare (not safe))
                                  (##fx< _x4424_ '8))
                                (if (let ()
                                      (declare (not safe))
                                      (##fx= _x4424_ '5))
                                    '(AuthenticationGSS)
                                    (if (let ()
                                          (declare (not safe))
                                          (##fx= _x4424_ '6))
                                        (let ((_data4429_
                                               (std/db/postgresql-driver#unmarshal-bytes-rest
                                                _bio4409_)))
                                          (cons 'AuthenticationGSSContinue
                                                (cons _data4429_ '())))
                                        '(AuthenticationSSPI)))
                                (if (let ()
                                      (declare (not safe))
                                      (##fx= _x4424_ '8))
                                    (let ((_mechanisms4431_
                                           (std/db/postgresql-driver#unmarshal-string-list
                                            _bio4409_)))
                                      (cons 'AuthenticationSASL
                                            _mechanisms4431_))
                                    (if (let ()
                                          (declare (not safe))
                                          (##fx= _x4424_ '9))
                                        (let ((_data4433_
                                               (std/db/postgresql-driver#unmarshal-string-rest
                                                _bio4409_)))
                                          (cons 'AuthenticationSASLContinue
                                                (cons _data4433_ '())))
                                        (let ((_data4435_
                                               (std/db/postgresql-driver#unmarshal-string-rest
                                                _bio4409_)))
                                          (cons 'AuthenticationSASLFinal
                                                (cons _data4435_ '())))))))
                        (_default44154419_)))
                  (_default44154419_))
              (_default44154419_))))))
  (define std/db/postgresql-driver#unmarshal-string-list
    (lambda (_bio4401_)
      (let _lp4403_ ((_r4405_ '()))
        (let ((_next4407_
               (std/db/postgresql-driver#unmarshal-string _bio4401_)))
          (if (string-empty? _next4407_)
              (reverse _r4405_)
              (_lp4403_ (cons _next4407_ _r4405_)))))))
  (define std/db/postgresql-driver#unmarshal-string
    (lambda (_bio4393_)
      (let _lp4395_ ((_bytes4397_ '()))
        (let ((_next4399_ (std/net/bio/input#bio-read-u8 _bio4393_)))
          (if (let () (declare (not safe)) (##fx= _next4399_ '0))
              (std/text/utf8#utf8->string__0
               (list->u8vector (reverse _bytes4397_)))
              (_lp4395_ (cons _next4399_ _bytes4397_)))))))
  (define std/db/postgresql-driver#unmarshal-bytes-rest
    (lambda (_bio4386_)
      (let* ((_count4388_ (std/net/bio/input#bio-input-count _bio4386_))
             (_data4390_ (make-u8vector _count4388_)))
        (std/net/bio/input#bio-read-bytes _data4390_ _bio4386_)
        _data4390_)))
  (define std/db/postgresql-driver#unmarshal-string-rest
    (lambda (_bio4382_)
      (let ((_count4384_ (std/net/bio/input#bio-input-count _bio4382_)))
        (std/net/bio/input#bio-input-utf8-decode _count4384_ _bio4382_))))
  (define std/db/postgresql-driver#unmarshal-complete
    (lambda (_bio4378_)
      (let ((_tag4380_ (std/db/postgresql-driver#unmarshal-string _bio4378_)))
        (cons _tag4380_ '()))))
  (define std/db/postgresql-driver#unmarshal-data-row
    (lambda (_bio4365_)
      (let ((_count4367_ (std/net/bio/input#bio-read-u16 _bio4365_)))
        (let _lp4369_ ((_i4371_ '0) (_r4372_ '()))
          (if (let () (declare (not safe)) (##fx< _i4371_ _count4367_))
              (let ((_len4374_ (std/net/bio/input#bio-read-s32 _bio4365_)))
                (if (let () (declare (not safe)) (##fx>= _len4374_ '0))
                    (let ((_str4376_
                           (std/net/bio/input#bio-input-utf8-decode
                            _len4374_
                            _bio4365_)))
                      (_lp4369_
                       (let () (declare (not safe)) (##fx+ _i4371_ '1))
                       (cons _str4376_ _r4372_)))
                    (_lp4369_
                     (let () (declare (not safe)) (##fx+ _i4371_ '1))
                     (cons '#f _r4372_))))
              (reverse _r4372_))))))
  (define std/db/postgresql-driver#unmarshal-error-notice
    (lambda (_bio4350_)
      (let _lp4352_ ((_r4354_ '()))
        (let ((_t4356_ (std/net/bio/input#bio-read-u8 _bio4350_)))
          (if (let () (declare (not safe)) (##fx= _t4356_ '0))
              (let* ((_alist4358_ (reverse _r4354_))
                     (_msg4360_ (assgetq '#\M _alist4358_)))
                (cons _msg4360_ _alist4358_))
              (let ((_field4363_
                     (std/db/postgresql-driver#unmarshal-string _bio4350_)))
                (_lp4352_
                 (cons (cons (integer->char _t4356_) _field4363_)
                       _r4354_))))))))
  (define std/db/postgresql-driver#unmarshal-param-description
    (lambda (_bio4339_)
      (let ((_count4341_ (std/net/bio/input#bio-read-u16 _bio4339_)))
        (let _lp4343_ ((_i4345_ '0) (_r4346_ '()))
          (if (let () (declare (not safe)) (##fx< _i4345_ _count4341_))
              (let ((_oid4348_ (std/net/bio/input#bio-read-u32 _bio4339_)))
                (_lp4343_
                 (let () (declare (not safe)) (##fx+ _i4345_ '1))
                 (cons _oid4348_ _r4346_)))
              (reverse _r4346_))))))
  (define std/db/postgresql-driver#unmarshal-row-description
    (lambda (_bio4315_)
      (let ((_count4317_ (std/net/bio/input#bio-read-u16 _bio4315_)))
        (let _lp4319_ ((_i4321_ '0) (_r4322_ '()))
          (if (let () (declare (not safe)) (##fx< _i4321_ _count4317_))
              (let* ((_field-name4324_
                      (std/db/postgresql-driver#unmarshal-string _bio4315_))
                     (_table-id4326_
                      (std/net/bio/input#bio-read-u32 _bio4315_))
                     (_attr-id4328_ (std/net/bio/input#bio-read-u16 _bio4315_))
                     (_type-id4330_ (std/net/bio/input#bio-read-u32 _bio4315_))
                     (_type-sz4332_ (std/net/bio/input#bio-read-s16 _bio4315_))
                     (_modifier4334_
                      (std/net/bio/input#bio-read-s32 _bio4315_))
                     (_fmt4336_ (std/net/bio/input#bio-read-u16 _bio4315_)))
                (_lp4319_
                 (let () (declare (not safe)) (##fx+ _i4321_ '1))
                 (cons (cons _field-name4324_
                             (cons _table-id4326_
                                   (cons _attr-id4328_
                                         (cons _type-id4330_
                                               (cons _type-sz4332_
                                                     (cons _modifier4334_
                                                           (cons _fmt4336_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         '())))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                       _r4322_)))
              (reverse _r4322_))))))
  (define std/db/postgresql-driver#unmarshal-ready
    (lambda (_bio4311_)
      (let ((_status4313_ (std/net/bio/input#bio-read-u8 _bio4311_)))
        (cons (integer->char _status4313_) '()))))
  (define std/db/postgresql-driver#marshal-fail
    (lambda (_what4307_)
      (lambda (_body4309_)
        (std/error#raise-io-error
         'postgresql-send!
         '"Cannot marshal; unsupported message"
         (cons _what4307_ _body4309_)))))
  (define std/db/postgresql-driver#marshal-empty (lambda (_body4305_) '#u8()))
  (define std/db/postgresql-driver#marshal-string
    (lambda (_str4302_ _bio4303_)
      (std/net/bio/output#bio-write-string _str4302_ _bio4303_)
      (std/net/bio/output#bio-write-u8 '0 _bio4303_)))
  (define std/db/postgresql-driver#marshal-startup
    (lambda (_body4236_)
      (let* ((_body42374251_ _body4236_)
             (_E42394255_
              (lambda () (error '"No clause matching" _body42374251_)))
             (_K42404266_
              (lambda (_value4258_ _param4259_)
                (let ((_bio4261_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/net/bio/output#bio-write-u32 '196608 _bio4261_)
                  (for-each
                   (lambda (_param4263_ _value4264_)
                     (std/db/postgresql-driver#marshal-string
                      _param4263_
                      _bio4261_)
                     (std/db/postgresql-driver#marshal-string
                      _value4264_
                      _bio4261_))
                   _param4259_
                   _value4258_)
                  (std/net/bio/output#bio-write-u8 '0 _bio4261_)))))
        (letrec ((_splice-rest42434269_
                  (lambda (_rest42474276_ _value4278_ _param4279_)
                    (if (let () (declare (not safe)) (##null? _rest42474276_))
                        (_K42404266_ _value4278_ _param4279_)
                        (_E42394255_))))
                 (_splice-try42454271_
                  (lambda (_hd42464281_
                           _rest42474283_
                           _value42414284_
                           _param42424286_)
                    (if (let () (declare (not safe)) (##pair? _hd42464281_))
                        (let ((_hd42484289_
                               (let ()
                                 (declare (not safe))
                                 (##car _hd42464281_)))
                              (_tl42494291_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _hd42464281_))))
                          (let* ((_param4294_ _hd42484289_)
                                 (_value4296_ _tl42494291_))
                            (_splice-loop42444273_
                             (let ()
                               (declare (not safe))
                               (##cdr _rest42474283_))
                             (cons _value4296_ _value42414284_)
                             (cons _param4294_ _param42424286_))))
                        (_splice-rest42434269_
                         _rest42474283_
                         (reverse _value42414284_)
                         (reverse _param42424286_)))))
                 (_splice-loop42444273_
                  (lambda (_rest42474298_ _value42414299_ _param42424300_)
                    (if (pair? _rest42474298_)
                        (_splice-try42454271_
                         (let () (declare (not safe)) (##car _rest42474298_))
                         _rest42474298_
                         _value42414299_
                         _param42424300_)
                        (_splice-rest42434269_
                         _rest42474298_
                         (reverse _value42414299_)
                         (reverse _param42424300_))))))
          (_splice-loop42444273_ _body42374251_ '() '())))))
  (define std/db/postgresql-driver#marshal-bind
    (lambda (_body4190_)
      (let* ((_body41914200_ _body4190_)
             (_E41934204_
              (lambda () (error '"No clause matching" _body41914200_)))
             (_K41944217_
              (lambda (_params4207_ _stmt-name4208_ _portal-name4209_)
                (let ((_bio4211_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _portal-name4209_
                   _bio4211_)
                  (std/db/postgresql-driver#marshal-string
                   _stmt-name4208_
                   _bio4211_)
                  (std/net/bio/output#bio-write-u16 '0 _bio4211_)
                  (std/net/bio/output#bio-write-u16
                   (length _params4207_)
                   _bio4211_)
                  (for-each
                   (lambda (_param4213_)
                     (if (not _param4213_)
                         (std/net/bio/output#bio-write-s32 '-1 _bio4211_)
                         (if (string? _param4213_)
                             (let ((_len4215_
                                    (std/text/utf8#string-utf8-length__0
                                     _param4213_)))
                               (std/net/bio/output#bio-write-u32
                                _len4215_
                                _bio4211_)
                               (std/net/bio/output#bio-write-string
                                _param4213_
                                _bio4211_))
                             (if (u8vector? _param4213_)
                                 (begin
                                   (std/net/bio/output#bio-write-u32
                                    (u8vector-length _param4213_)
                                    _bio4211_)
                                   (std/net/bio/output#bio-write-bytes
                                    _param4213_
                                    _bio4211_))
                                 (std/error#raise-io-error
                                  'postgresql-send!
                                  '"Cannot marshal; bad parameter"
                                  _param4213_)))))
                   _params4207_)
                  (std/net/bio/output#bio-write-u16 '0 _bio4211_)
                  _bio4211_))))
        (if (let () (declare (not safe)) (##pair? _body41914200_))
            (let ((_hd41954220_
                   (let () (declare (not safe)) (##car _body41914200_)))
                  (_tl41964222_
                   (let () (declare (not safe)) (##cdr _body41914200_))))
              (let ((_portal-name4225_ _hd41954220_))
                (if (let () (declare (not safe)) (##pair? _tl41964222_))
                    (let ((_hd41974227_
                           (let () (declare (not safe)) (##car _tl41964222_)))
                          (_tl41984229_
                           (let () (declare (not safe)) (##cdr _tl41964222_))))
                      (let* ((_stmt-name4232_ _hd41974227_)
                             (_params4234_ _tl41984229_))
                        (_K41944217_
                         _params4234_
                         _stmt-name4232_
                         _portal-name4225_)))
                    (_E41934204_))))
            (_E41934204_)))))
  (define std/db/postgresql-driver#marshal-close
    (lambda (_body4188_)
      (std/db/postgresql-driver#marshal-describe _body4188_)))
  (define std/db/postgresql-driver#marshal-describe
    (lambda (_body4149_)
      (let* ((_body41504159_ _body4149_)
             (_E41524163_
              (lambda () (error '"No clause matching" _body41504159_)))
             (_K41534171_
              (lambda (_name4166_ _what4167_)
                (let ((_bio4169_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/net/bio/output#bio-write-u8
                   (char->integer _what4167_)
                   _bio4169_)
                  (std/db/postgresql-driver#marshal-string
                   _name4166_
                   _bio4169_)
                  _bio4169_))))
        (if (let () (declare (not safe)) (##pair? _body41504159_))
            (let ((_hd41544174_
                   (let () (declare (not safe)) (##car _body41504159_)))
                  (_tl41554176_
                   (let () (declare (not safe)) (##cdr _body41504159_))))
              (let ((_what4179_ _hd41544174_))
                (if (let () (declare (not safe)) (##pair? _tl41554176_))
                    (let ((_hd41564181_
                           (let () (declare (not safe)) (##car _tl41554176_)))
                          (_tl41574183_
                           (let () (declare (not safe)) (##cdr _tl41554176_))))
                      (let ((_name4186_ _hd41564181_))
                        (if (let ()
                              (declare (not safe))
                              (##null? _tl41574183_))
                            (_K41534171_ _name4186_ _what4179_)
                            (_E41524163_))))
                    (_E41524163_))))
            (_E41524163_)))))
  (define std/db/postgresql-driver#marshal-exec
    (lambda (_body4110_)
      (let* ((_body41114120_ _body4110_)
             (_E41134124_
              (lambda () (error '"No clause matching" _body41114120_)))
             (_K41144132_
              (lambda (_limit4127_ _portal4128_)
                (let ((_bio4130_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _portal4128_
                   _bio4130_)
                  (std/net/bio/output#bio-write-u32 '0 _bio4130_)
                  _bio4130_))))
        (if (let () (declare (not safe)) (##pair? _body41114120_))
            (let ((_hd41154135_
                   (let () (declare (not safe)) (##car _body41114120_)))
                  (_tl41164137_
                   (let () (declare (not safe)) (##cdr _body41114120_))))
              (let ((_portal4140_ _hd41154135_))
                (if (let () (declare (not safe)) (##pair? _tl41164137_))
                    (let ((_hd41174142_
                           (let () (declare (not safe)) (##car _tl41164137_)))
                          (_tl41184144_
                           (let () (declare (not safe)) (##cdr _tl41164137_))))
                      (let ((_limit4147_ _hd41174142_))
                        (if (let ()
                              (declare (not safe))
                              (##null? _tl41184144_))
                            (_K41144132_ _limit4147_ _portal4140_)
                            (_E41134124_))))
                    (_E41134124_))))
            (_E41134124_)))))
  (define std/db/postgresql-driver#marshal-parse
    (lambda (_body4071_)
      (let* ((_body40724081_ _body4071_)
             (_E40744085_
              (lambda () (error '"No clause matching" _body40724081_)))
             (_K40754093_
              (lambda (_sql4088_ _stmt4089_)
                (let ((_bio4091_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _stmt4089_
                   _bio4091_)
                  (std/db/postgresql-driver#marshal-string _sql4088_ _bio4091_)
                  (std/net/bio/output#bio-write-u16 '0 _bio4091_)
                  _bio4091_))))
        (if (let () (declare (not safe)) (##pair? _body40724081_))
            (let ((_hd40764096_
                   (let () (declare (not safe)) (##car _body40724081_)))
                  (_tl40774098_
                   (let () (declare (not safe)) (##cdr _body40724081_))))
              (let ((_stmt4101_ _hd40764096_))
                (if (let () (declare (not safe)) (##pair? _tl40774098_))
                    (let ((_hd40784103_
                           (let () (declare (not safe)) (##car _tl40774098_)))
                          (_tl40794105_
                           (let () (declare (not safe)) (##cdr _tl40774098_))))
                      (let ((_sql4108_ _hd40784103_))
                        (if (let ()
                              (declare (not safe))
                              (##null? _tl40794105_))
                            (_K40754093_ _sql4108_ _stmt4101_)
                            (_E40744085_))))
                    (_E40744085_))))
            (_E40744085_)))))
  (define std/db/postgresql-driver#marshal-passwd
    (lambda (_body4042_)
      (let* ((_body40434050_ _body4042_)
             (_E40454054_
              (lambda () (error '"No clause matching" _body40434050_)))
             (_K40464061_
              (lambda (_passwd4057_)
                (let ((_bio4059_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _passwd4057_
                   _bio4059_)
                  _bio4059_))))
        (if (let () (declare (not safe)) (##pair? _body40434050_))
            (let ((_hd40474064_
                   (let () (declare (not safe)) (##car _body40434050_)))
                  (_tl40484066_
                   (let () (declare (not safe)) (##cdr _body40434050_))))
              (let ((_passwd4069_ _hd40474064_))
                (if (let () (declare (not safe)) (##null? _tl40484066_))
                    (_K40464061_ _passwd4069_)
                    (_E40454054_))))
            (_E40454054_)))))
  (define std/db/postgresql-driver#marshal-query
    (lambda (_body4013_)
      (let* ((_body40144021_ _body4013_)
             (_E40164025_
              (lambda () (error '"No clause matching" _body40144021_)))
             (_K40174032_
              (lambda (_sql4028_)
                (let ((_bio4030_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string _sql4028_ _bio4030_)
                  _bio4030_))))
        (if (let () (declare (not safe)) (##pair? _body40144021_))
            (let ((_hd40184035_
                   (let () (declare (not safe)) (##car _body40144021_)))
                  (_tl40194037_
                   (let () (declare (not safe)) (##cdr _body40144021_))))
              (let ((_sql4040_ _hd40184035_))
                (if (let () (declare (not safe)) (##null? _tl40194037_))
                    (_K40174032_ _sql4040_)
                    (_E40164025_))))
            (_E40164025_)))))
  (define std/db/postgresql-driver#marshal-sasl-initial-reponse
    (lambda (_body3972_)
      (let* ((_body39733982_ _body3972_)
             (_E39753986_
              (lambda () (error '"No clause matching" _body39733982_)))
             (_K39763996_
              (lambda (_data3989_ _mechanism3990_)
                (let ((_bio3992_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _mechanism3990_
                   _bio3992_)
                  (if _data3989_
                      (let ((_len3994_
                             (std/text/utf8#string-utf8-length__0 _data3989_)))
                        (std/net/bio/output#bio-write-u32 _len3994_ _bio3992_)
                        (std/net/bio/output#bio-write-string
                         _data3989_
                         _bio3992_))
                      (std/net/bio/output#bio-write-s32 '-1 _bio3992_))
                  _bio3992_))))
        (if (let () (declare (not safe)) (##pair? _body39733982_))
            (let ((_hd39773999_
                   (let () (declare (not safe)) (##car _body39733982_)))
                  (_tl39784001_
                   (let () (declare (not safe)) (##cdr _body39733982_))))
              (let ((_mechanism4004_ _hd39773999_))
                (if (let () (declare (not safe)) (##pair? _tl39784001_))
                    (let ((_hd39794006_
                           (let () (declare (not safe)) (##car _tl39784001_)))
                          (_tl39804008_
                           (let () (declare (not safe)) (##cdr _tl39784001_))))
                      (let ((_data4011_ _hd39794006_))
                        (if (let ()
                              (declare (not safe))
                              (##null? _tl39804008_))
                            (_K39763996_ _data4011_ _mechanism4004_)
                            (_E39753986_))))
                    (_E39753986_))))
            (_E39753986_)))))
  (define std/db/postgresql-driver#marshal-sasl-response
    (lambda (_body3945_)
      (let* ((_body39463953_ _body3945_)
             (_E39483957_
              (lambda () (error '"No clause matching" _body39463953_)))
             (_K39493962_
              (lambda (_data3960_)
                (std/text/utf8#string->utf8__0 _data3960_))))
        (if (let () (declare (not safe)) (##pair? _body39463953_))
            (let ((_hd39503965_
                   (let () (declare (not safe)) (##car _body39463953_)))
                  (_tl39513967_
                   (let () (declare (not safe)) (##cdr _body39463953_))))
              (let ((_data3970_ _hd39503965_))
                (if (let () (declare (not safe)) (##null? _tl39513967_))
                    (std/text/utf8#string->utf8__0 _data3970_)
                    (_E39483957_))))
            (_E39483957_)))))
  (define std/db/postgresql-driver#+backend-messages+ (make-vector '256 '#f))
  (define std/db/postgresql-driver#+frontend-messages+ (make-table 'test: eq?))
  (let ((_t3943_ (char->integer '#\R)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3943_
     (cons 'AuthenticationRequest
           std/db/postgresql-driver#unmarshal-authen-request)))
  (let ((_t3941_ (char->integer '#\K)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3941_
     (cons 'BackendKeyData std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3939_ (char->integer '#\2)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3939_
     (cons 'BindComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3937_ (char->integer '#\3)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3937_
     (cons 'CloseComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3935_ (char->integer '#\C)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3935_
     (cons 'CommandComplete std/db/postgresql-driver#unmarshal-complete)))
  (let ((_t3933_ (char->integer '#\d)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3933_
     (cons 'CopyData std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3931_ (char->integer '#\c)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3931_
     (cons 'CopyDone std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3929_ (char->integer '#\G)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3929_
     (cons 'CopyInResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3927_ (char->integer '#\H)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3927_
     (cons 'CopyOutResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3925_ (char->integer '#\W)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3925_
     (cons 'CopyBothResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3923_ (char->integer '#\D)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3923_
     (cons 'DataRow std/db/postgresql-driver#unmarshal-data-row)))
  (let ((_t3921_ (char->integer '#\I)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3921_
     (cons 'EmptyQueryResponse std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3919_ (char->integer '#\E)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3919_
     (cons 'ErrorResponse std/db/postgresql-driver#unmarshal-error-notice)))
  (let ((_t3917_ (char->integer '#\V)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3917_
     (cons 'FunctionCallResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3915_ (char->integer '#\v)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3915_
     (cons 'NegotiateProtocolVersion
           std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3913_ (char->integer '#\n)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3913_
     (cons 'NoData std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3911_ (char->integer '#\N)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3911_
     (cons 'NoticeResponse std/db/postgresql-driver#unmarshal-error-notice)))
  (let ((_t3909_ (char->integer '#\A)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3909_
     (cons 'NotificationResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3907_ (char->integer '#\t)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3907_
     (cons 'ParameterDescription
           std/db/postgresql-driver#unmarshal-param-description)))
  (let ((_t3905_ (char->integer '#\S)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3905_
     (cons 'ParameterStatus std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t3903_ (char->integer '#\1)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3903_
     (cons 'ParseComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3901_ (char->integer '#\s)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3901_
     (cons 'PortalSuspended std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t3899_ (char->integer '#\Z)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3899_
     (cons 'ReadyForQuery std/db/postgresql-driver#unmarshal-ready)))
  (let ((_t3896_ (char->integer '#\T)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t3896_
     (cons 'RowDescription
           std/db/postgresql-driver#unmarshal-row-description)))
  (let ((_t3894_ (char->integer '#\B)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Bind
     (cons _t3894_ std/db/postgresql-driver#marshal-bind)))
  (let ((_t3892_ (char->integer '#\C)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Close
     (cons _t3892_ std/db/postgresql-driver#marshal-close)))
  (let ((_t3890_ (char->integer '#\d)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyData
     (cons _t3890_ (std/db/postgresql-driver#marshal-fail 'CopyData))))
  (let ((_t3888_ (char->integer '#\c)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyDone
     (cons _t3888_ (std/db/postgresql-driver#marshal-fail 'CopyDone))))
  (let ((_t3886_ (char->integer '#\f)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyFail
     (cons _t3886_ (std/db/postgresql-driver#marshal-fail 'CopyFail))))
  (let ((_t3884_ (char->integer '#\D)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Describe
     (cons _t3884_ std/db/postgresql-driver#marshal-describe)))
  (let ((_t3882_ (char->integer '#\E)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Execute
     (cons _t3882_ std/db/postgresql-driver#marshal-exec)))
  (let ((_t3880_ (char->integer '#\H)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Flush
     (cons _t3880_ std/db/postgresql-driver#marshal-empty)))
  (let ((_t3878_ (char->integer '#\F)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'FunctionCall
     (cons _t3878_ (std/db/postgresql-driver#marshal-fail 'FunctionCall))))
  (let ((_t3876_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'GSSResponse
     (cons _t3876_ (std/db/postgresql-driver#marshal-fail 'GSSResponse))))
  (let ((_t3874_ (char->integer '#\P)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Parse
     (cons _t3874_ std/db/postgresql-driver#marshal-parse)))
  (let ((_t3872_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'PasswordMessage
     (cons _t3872_ std/db/postgresql-driver#marshal-passwd)))
  (let ((_t3870_ (char->integer '#\Q)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Query
     (cons _t3870_ std/db/postgresql-driver#marshal-query)))
  (let ((_t3868_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'SASLInitialResponse
     (cons _t3868_ std/db/postgresql-driver#marshal-sasl-initial-reponse)))
  (let ((_t3866_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'SASLResponse
     (cons _t3866_ std/db/postgresql-driver#marshal-sasl-response)))
  (let ((_t3864_ (char->integer '#\S)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Sync
     (cons _t3864_ std/db/postgresql-driver#marshal-empty)))
  (let ((_t3861_ (char->integer '#\X)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Terminate
     (cons _t3861_ std/db/postgresql-driver#marshal-empty))))
