(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/web/fastcgi#fastcgi-request::t
    (make-struct-type
     'std/web/fastcgi#fastcgi-request::t
     '#f
     '6
     'fastcgi-request
     '()
     '#f
     '(port id keepalive role params stdin)))
  (define std/web/fastcgi#fastcgi-request?
    (make-struct-predicate std/web/fastcgi#fastcgi-request::t))
  (define std/web/fastcgi#make-fastcgi-request
    (lambda _$args1040_
      (apply make-struct-instance
             std/web/fastcgi#fastcgi-request::t
             _$args1040_)))
  (define std/web/fastcgi#fastcgi-request-port
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '0))
  (define std/web/fastcgi#fastcgi-request-id
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '1))
  (define std/web/fastcgi#fastcgi-request-keepalive
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '2))
  (define std/web/fastcgi#fastcgi-request-role
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '3))
  (define std/web/fastcgi#fastcgi-request-params
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '4))
  (define std/web/fastcgi#fastcgi-request-stdin
    (make-struct-field-accessor std/web/fastcgi#fastcgi-request::t '5))
  (define std/web/fastcgi#fastcgi-request-port-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '0))
  (define std/web/fastcgi#fastcgi-request-id-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '1))
  (define std/web/fastcgi#fastcgi-request-keepalive-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '2))
  (define std/web/fastcgi#fastcgi-request-role-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '3))
  (define std/web/fastcgi#fastcgi-request-params-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '4))
  (define std/web/fastcgi#fastcgi-request-stdin-set!
    (make-struct-field-mutator std/web/fastcgi#fastcgi-request::t '5))
  (define std/web/fastcgi#start-fastcgi-server!
    (lambda (_address1037_ _respond1038_)
      (std/logger#start-logger!__0)
      (gerbil/gambit/threads#spawn
       std/web/fastcgi#fastcgi-server
       (open-tcp-server (std/net/address#inet-address->string _address1037_))
       _respond1038_)))
  (define std/web/fastcgi#fastcgi-server
    (lambda (_sock1022_ _respond1023_)
      (let _lp1025_ ()
        (with-exception-catcher
         (lambda (_g10271029_)
           (if '#t
               (let ((_e1032_ _g10271029_))
                 (std/logger#log-error '"error accepting connection" _e1032_))
               (raise _g10271029_)))
         (lambda ()
           (let ((_client1035_ (read _sock1022_)))
             (gerbil/gambit/threads#spawn
              std/web/fastcgi#fastcgi-connection
              _client1035_
              _respond1023_))))
        (_lp1025_))))
  (define std/web/fastcgi#fastcgi-connection
    (lambda (_port1004_ _respond1005_)
      (letrec ((_loop1007_
                (lambda ()
                  (let ((_req1020_
                         (std/web/fastcgi#fastcgi-accept _port1004_)))
                    (if (eof-object? _req1020_)
                        '#!void
                        (if (eq? (##structure-ref
                                  _req1020_
                                  '4
                                  std/web/fastcgi#fastcgi-request::t
                                  '#f)
                                 'FCGI-RESPONDER)
                            (begin
                              (_respond1005_ _req1020_)
                              (std/web/fastcgi#fastcgi-request-end__0
                               _req1020_)
                              (if (##structure-ref
                                   _req1020_
                                   '3
                                   std/web/fastcgi#fastcgi-request::t
                                   '#f)
                                  (_loop1007_)
                                  '#!void))
                            (begin
                              (std/web/fastcgi#fastcgi-request-end__%
                               _req1020_
                               '1
                               std/web/fastcgi#FCGI-UNKNOWN-ROLE)
                              (if (##structure-ref
                                   _req1020_
                                   '3
                                   std/web/fastcgi#fastcgi-request::t
                                   '#f)
                                  (_loop1007_)
                                  '#!void))))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g10081011_)
              (if '#t
                  (let ((_e1014_ _g10081011_))
                    (std/logger#log-error '"error responding" _e1014_))
                  (raise _g10081011_)))
            (lambda () (_loop1007_))))
         (lambda ()
           (with-exception-catcher
            void
            (lambda () (close-port _port1004_))))))))
  (define std/web/fastcgi#fastcgi-accept
    (lambda (_port760_)
      (letrec ((_begin-request762_
                (lambda (_port883_)
                  (let* ((_g884894_
                          (std/web/fastcgi#fcgi-read-record _port883_))
                         (_E887898_
                          (lambda () (error '"No clause matching" _g884894_))))
                    (let ((_K889986_
                           (lambda (_body912_ _reqid913_ _type914_)
                             (if (eq? _type914_
                                      std/web/fastcgi#FCGI-BEGIN-REQUEST)
                                 (let ((_g4709_ (std/web/fastcgi#fcgi-begin-request-e
                                                 _body912_)))
                                   (begin
                                     (let ((_g4710_ (let ()
                                                      (declare (not safe))
                                                      (if (##values? _g4709_)
                                                          (##vector-length
                                                           _g4709_)
                                                          1))))
                                       (if (not (let ()
                                                  (declare (not safe))
                                                  (##fx= _g4710_ 2)))
                                           (error "Context expects 2 values"
                                                  _g4710_)))
                                     (let ((_role916_
                                            (let ()
                                              (declare (not safe))
                                              (##vector-ref _g4709_ 0)))
                                           (_flags917_
                                            (let ()
                                              (declare (not safe))
                                              (##vector-ref _g4709_ 1))))
                                       (let ((_keepalive919_
                                              (not (zero? (fxand _flags917_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         std/web/fastcgi#FCGI-KEEP-CONN)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                         (_receive-request-data763_
                                          _port883_
                                          _reqid913_
                                          _keepalive919_
                                          _role916_)))))
                                 (if (eq? _type914_
                                          std/web/fastcgi#FCGI-GET-VALUES)
                                     (let* ((_keys922_
                                             (std/web/fastcgi#fcgi-get-values-e
                                              _body912_))
                                            (_resp981_
                                             (let ((_iterable949_ _keys922_)
                                                   (_iter-do951_
                                                    (lambda (_val924_ _r926_)
                                                      (let* ((_val927932_
                                                              _val924_)
                                                             (_E929936_
                                                              (lambda ()
                                                                (error '"No clause matching"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               _val927932_)))
                     (_K930944_
                      (lambda (_key939_)
                        (let ((_$e941_ _key939_))
                          (if (eq? 'FCGI_MAX_CONNS _$e941_)
                              (cons (cons _key939_ '"1") _r926_)
                              (if (eq? 'FCGI_MAX_REQS _$e941_)
                                  (cons (cons _key939_ '"1") _r926_)
                                  (if (eq? 'FCGI_MPXS_CONNS _$e941_)
                                      (cons (cons _key939_ '"0") _r926_)
                                      _r926_))))))
                     (_key947_ _val927932_))
                (_K930944_ _key947_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_r953_ '()))
                                               (if (pair? _iterable949_)
                                                   (foldl1 _iter-do951_
                                                           _r953_
                                                           _iterable949_)
                                                   (if (null? _iterable949_)
                                                       _r953_
                                                       (let* ((_it955_ (std/iter#iter
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                _iterable949_))
                      (_next!958_
                       (let ()
                         (declare (not safe))
                         (##unchecked-structure-ref
                          _it955_
                          '2
                          std/iter#iterator::t
                          '#f))))
                 (declare (not safe))
                 (let _lp963_ ((_rval966_ '()))
                   (let ((_val969_ (_next!958_ _it955_)))
                     (if (eq? std/iter#iter-end _val969_)
                         (begin
                           (let ((_$e971_ (##unchecked-structure-ref
                                           _it955_
                                           '3
                                           std/iter#iterator::t
                                           '#f)))
                             (if _$e971_
                                 ((lambda (_g973975_) (_g973975_ _it955_))
                                  _$e971_)
                                 '#!void))
                           _rval966_)
                         (let ((_xval978_ (_iter-do951_ _val969_ _rval966_)))
                           (_lp963_ _xval978_))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                            (_data983_
                                             (std/web/fastcgi#fcgi-get-values-result-data
                                              _resp981_)))
                                       (std/web/fastcgi#fcgi-write-record__0
                                        _port883_
                                        std/web/fastcgi#FCGI-GET-VALUES-RESULT
                                        _reqid913_
                                        _data983_)
                                       (_begin-request762_ _port883_))
                                     (if (eq? _reqid913_ '0)
                                         (begin
                                           (std/web/fastcgi#fcgi-write-record__0
                                            _port883_
                                            std/web/fastcgi#FCGI-UNKNOWN-TYPE
                                            _reqid913_
                                            (std/web/fastcgi#fcgi-unknown-type-data
                                             _type914_))
                                           (_begin-request762_ _port883_))
                                         (begin
                                           (std/logger#warning
                                            '"fastcgi-accept: unexpected message type ~a"
                                            _type914_)
                                           (_begin-request762_ _port883_)))))))
                          (_K888904_ (lambda (_eof902_) _eof902_)))
                      (let ((_try-match886909_
                             (lambda ()
                               (if (eof-object? _g884894_)
                                   (let ((_eof907_ _g884894_))
                                     (_K888904_ _eof907_))
                                   (_E887898_)))))
                        (if (let ((__tmp4711
                                   (if (let ()
                                         (declare (not safe))
                                         (##values? _g884894_))
                                       (let ()
                                         (declare (not safe))
                                         (##vector-length _g884894_))
                                       '1)))
                              (declare (not safe))
                              (##fx= __tmp4711 '3))
                            (let* ((_e890989_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref _g884894_ '0)))
                                   (_e891994_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref _g884894_ '1)))
                                   (_e892999_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref _g884894_ '2))))
                              (let ((_type992_ _e890989_)
                                    (_reqid997_ _e891994_)
                                    (_body1002_ _e892999_))
                                (_K889986_ _body1002_ _reqid997_ _type992_)))
                            (_try-match886909_)))))))
               (_receive-request-data763_
                (lambda (_port765_ _id766_ _keepalive767_ _role768_)
                  (letrec* ((_params770_ (make-table 'test: eq?)))
                    (let _lp772_ ((_end-params774_ '#f)
                                  (_end-stdin775_ '#f)
                                  (_stdin776_ '()))
                      (if (and _end-params774_ _end-stdin775_)
                          (let ((__tmp4712
                                 (append-u8vectors (reverse _stdin776_))))
                            (declare (not safe))
                            (##structure
                             std/web/fastcgi#fastcgi-request::t
                             _port765_
                             _id766_
                             _keepalive767_
                             _role768_
                             _params770_
                             __tmp4712))
                          (let* ((_g777787_
                                  (std/web/fastcgi#fcgi-read-record _port765_))
                                 (_E780791_
                                  (lambda ()
                                    (error '"No clause matching" _g777787_))))
                            (let ((_K782865_
                                   (lambda (_body802_ _reqid803_ _type804_)
                                     (if (eq? _reqid803_ _id766_)
                                         (if (eq? _type804_
                                                  std/web/fastcgi#FCGI-PARAMS)
                                             (if (zero? (u8vector-length
                                                         _body802_))
                                                 (_lp772_ '#t
                                                          _end-stdin775_
                                                          _stdin776_)
                                                 (let ((_alist806_
                                                        (std/web/fastcgi#fcgi-params-e
                                                         _body802_)))
                                                   (let ((_iterable839_
                                                          _alist806_)
                                                         (_iter-do841_
                                                          (lambda (_val808_)
                                                            (let* ((_val810817_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _val808_)
                           (_E812821_
                            (lambda ()
                              (error '"No clause matching" _val810817_)))
                           (_K813827_
                            (lambda (_value824_ _key825_)
                              (table-set! _params770_ _key825_ _value824_))))
                      (if (let () (declare (not safe)) (##pair? _val810817_))
                          (let ((_hd814830_
                                 (let ()
                                   (declare (not safe))
                                   (##car _val810817_)))
                                (_tl815832_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _val810817_))))
                            (let* ((_key835_ _hd814830_)
                                   (_value837_ _tl815832_))
                              (_K813827_ _value837_ _key835_)))
                          (_E812821_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (if (pair? _iterable839_)
                                                         (for-each
                                                          _iter-do841_
                                                          _iterable839_)
                                                         (if (null? _iterable839_)
                                                             '#!void
                                                             (let* ((_it844_ (std/iter#iter
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                      _iterable839_))
                            (_next!847_
                             (let ()
                               (declare (not safe))
                               (##unchecked-structure-ref
                                _it844_
                                '2
                                std/iter#iterator::t
                                '#f))))
                       (declare (not safe))
                       (begin
                         (let _lp852_ ()
                           (let ((_val856_ (_next!847_ _it844_)))
                             (if (eq? std/iter#iter-end _val856_)
                                 '#!void
                                 (begin (_iter-do841_ _val856_) (_lp852_)))))
                         (let ((_$e858_ (##unchecked-structure-ref
                                         _it844_
                                         '3
                                         std/iter#iterator::t
                                         '#f)))
                           (if _$e858_
                               ((lambda (_g860862_) (_g860862_ _it844_))
                                _$e858_)
                               '#!void))
                         '#!void)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_lp772_ '#f
                                                            _end-stdin775_
                                                            _stdin776_)))
                                             (if (eq? _type804_
                                                      std/web/fastcgi#FCGI-STDIN)
                                                 (if (zero? (u8vector-length
                                                             _body802_))
                                                     (_lp772_ _end-params774_
                                                              '#t
                                                              _stdin776_)
                                                     (_lp772_ _end-params774_
                                                              '#f
                                                              (cons _body802_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _stdin776_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (if (eq? _type804_
                                                          std/web/fastcgi#FCGI-ABORT-REQUEST)
                                                     (std/error#raise-io-error
                                                      'fastcgi-accept
                                                      '"Connection aborted")
                                                     (begin
                                                       (std/logger#warning
                                                        '"fastcgi-accept: unexpected message type ~a"
                                                        _type804_)
                                                       (_lp772_ _end-params774_
                                                                _end-stdin775_
                                                                _stdin776_)))))
                                         (begin
                                           (std/logger#warning
                                            '"fastcgi-accept: unexpected message request ~a"
                                            _reqid803_)
                                           (_lp772_ _end-params774_
                                                    _end-stdin775_
                                                    _stdin776_)))))
                                  (_K781796_
                                   (lambda ()
                                     (std/error#raise-io-error
                                      'fastcgi-accept
                                      '"Premature port end"
                                      _port765_))))
                              (let ((_try-match779799_
                                     (lambda ()
                                       (if (eof-object? _g777787_)
                                           (_K781796_)
                                           (_E780791_)))))
                                (if (let ((__tmp4713
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##values? _g777787_))
                                               (let ()
                                                 (declare (not safe))
                                                 (##vector-length _g777787_))
                                               '1)))
                                      (declare (not safe))
                                      (##fx= __tmp4713 '3))
                                    (let* ((_e783868_
                                            (let ()
                                              (declare (not safe))
                                              (##vector-ref _g777787_ '0)))
                                           (_e784873_
                                            (let ()
                                              (declare (not safe))
                                              (##vector-ref _g777787_ '1)))
                                           (_e785878_
                                            (let ()
                                              (declare (not safe))
                                              (##vector-ref _g777787_ '2))))
                                      (let ((_type871_ _e783868_)
                                            (_reqid876_ _e784873_)
                                            (_body881_ _e785878_))
                                        (_K782865_
                                         _body881_
                                         _reqid876_
                                         _type871_)))
                                    (_try-match779799_)))))))))))
        (_begin-request762_ _port760_))))
  (define std/web/fastcgi#fastcgi-write-stdout
    (lambda (_req728_ _data729_)
      (let* ((_req730737_ _req728_)
             (_E732741_ (lambda () (error '"No clause matching" _req730737_)))
             (_K733747_
              (lambda (_reqid744_ _port745_)
                (if _port745_
                    (std/web/fastcgi#fcgi-write-data
                     _port745_
                     std/web/fastcgi#FCGI-STDOUT
                     _reqid744_
                     _data729_)
                    (error '"request ended; no port" _req728_)))))
        (if (let ()
              (declare (not safe))
              (##structure-instance-of?
               _req730737_
               'std/web/fastcgi#fastcgi-request::t))
            (let* ((_e734750_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req730737_ '1)))
                   (_port753_ _e734750_)
                   (_e735755_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req730737_ '2)))
                   (_reqid758_ _e735755_))
              (_K733747_ _reqid758_ _port753_))
            (_E732741_)))))
  (define std/web/fastcgi#fastcgi-write-stderr
    (lambda (_req696_ _data697_)
      (let* ((_req698705_ _req696_)
             (_E700709_ (lambda () (error '"No clause matching" _req698705_)))
             (_K701715_
              (lambda (_reqid712_ _port713_)
                (if _port713_
                    (std/web/fastcgi#fcgi-write-data
                     _port713_
                     std/web/fastcgi#FCGI-STDERR
                     _reqid712_
                     _data697_)
                    (error '"request ended; no port" _req696_)))))
        (if (let ()
              (declare (not safe))
              (##structure-instance-of?
               _req698705_
               'std/web/fastcgi#fastcgi-request::t))
            (let* ((_e702718_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req698705_ '1)))
                   (_port721_ _e702718_)
                   (_e703723_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req698705_ '2)))
                   (_reqid726_ _e703723_))
              (_K701715_ _reqid726_ _port721_))
            (_E700709_)))))
  (define std/web/fastcgi#fastcgi-request-end__%
    (lambda (_req645_ _app-status646_ _proto-status647_)
      (let* ((_req648655_ _req645_)
             (_E650659_ (lambda () (error '"No clause matching" _req648655_)))
             (_K651665_
              (lambda (_reqid662_ _port663_)
                (if _port663_
                    (begin
                      (std/web/fastcgi#fcgi-write-record__0
                       _port663_
                       std/web/fastcgi#FCGI-STDOUT
                       _reqid662_
                       '#u8())
                      (std/web/fastcgi#fcgi-write-record__0
                       _port663_
                       std/web/fastcgi#FCGI-STDERR
                       _reqid662_
                       '#u8())
                      (std/web/fastcgi#fcgi-write-record__0
                       _port663_
                       std/web/fastcgi#FCGI-END-REQUEST
                       _reqid662_
                       (std/web/fastcgi#fcgi-end-request-data
                        _app-status646_
                        _proto-status647_))
                      (##structure-set!
                       _req645_
                       '#f
                       '1
                       std/web/fastcgi#fastcgi-request::t
                       '#f))
                    '#!void))))
        (if (let ()
              (declare (not safe))
              (##structure-instance-of?
               _req648655_
               'std/web/fastcgi#fastcgi-request::t))
            (let* ((_e652668_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req648655_ '1)))
                   (_port671_ _e652668_)
                   (_e653673_
                    (let ()
                      (declare (not safe))
                      (##vector-ref _req648655_ '2)))
                   (_reqid676_ _e653673_))
              (_K651665_ _reqid676_ _port671_))
            (_E650659_)))))
  (define std/web/fastcgi#fastcgi-request-end__0
    (lambda (_req681_)
      (let* ((_app-status683_ '0)
             (_proto-status685_ std/web/fastcgi#FCGI-REQUEST-COMPLETE))
        (std/web/fastcgi#fastcgi-request-end__%
         _req681_
         _app-status683_
         _proto-status685_))))
  (define std/web/fastcgi#fastcgi-request-end__1
    (lambda (_req687_ _app-status688_)
      (let ((_proto-status690_ std/web/fastcgi#FCGI-REQUEST-COMPLETE))
        (std/web/fastcgi#fastcgi-request-end__%
         _req687_
         _app-status688_
         _proto-status690_))))
  (define std/web/fastcgi#fastcgi-request-end
    (lambda _g4715_
      (let ((_g4714_ (let () (declare (not safe)) (##length _g4715_))))
        (cond ((let () (declare (not safe)) (##fx= _g4714_ 1))
               (apply std/web/fastcgi#fastcgi-request-end__0 _g4715_))
              ((let () (declare (not safe)) (##fx= _g4714_ 2))
               (apply std/web/fastcgi#fastcgi-request-end__1 _g4715_))
              ((let () (declare (not safe)) (##fx= _g4714_ 3))
               (apply std/web/fastcgi#fastcgi-request-end__% _g4715_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/web/fastcgi#fastcgi-request-end
                _g4715_))))))
  (define std/web/fastcgi#FCGI-BEGIN-REQUEST '1)
  (define std/web/fastcgi#FCGI-ABORT-REQUEST '2)
  (define std/web/fastcgi#FCGI-END-REQUEST '3)
  (define std/web/fastcgi#FCGI-PARAMS '4)
  (define std/web/fastcgi#FCGI-STDIN '5)
  (define std/web/fastcgi#FCGI-STDOUT '6)
  (define std/web/fastcgi#FCGI-STDERR '7)
  (define std/web/fastcgi#FCGI-DATA '8)
  (define std/web/fastcgi#FCGI-GET-VALUES '9)
  (define std/web/fastcgi#FCGI-GET-VALUES-RESULT '10)
  (define std/web/fastcgi#FCGI-UNKNOWN-TYPE '11)
  (define std/web/fastcgi#FCGI-RESPONDER '1)
  (define std/web/fastcgi#FCGI-AUTHORIZER '2)
  (define std/web/fastcgi#FCGI-FILTER '3)
  (define std/web/fastcgi#FCGI-KEEP-CONN '1)
  (define std/web/fastcgi#FCGI-REQUEST-COMPLETE '0)
  (define std/web/fastcgi#FCGI-CANT-MPX-CONN '1)
  (define std/web/fastcgi#FCGI-OVERLOADED '2)
  (define std/web/fastcgi#FCGI-UNKNOWN-ROLE '3)
  (define std/web/fastcgi#fcgi-read-record
    (lambda (_port614_)
      (call-with-current-continuation
       (lambda (_return616_)
         (let* ((_head618_ (make-u8vector '8))
                (_rd620_ (read-subu8vector _head618_ '0 '8 _port614_))
                (_g4716_ (if (zero? _rd620_)
                             (_return616_ (eof-object))
                             '#!void))
                (_g4717_ (if (fx< _rd620_ '8)
                             (std/error#raise-io-error
                              'fcgi-read-record
                              '"incomplete record")
                             '#!void))
                (_ver624_ (u8vector-ref _head618_ '0))
                (_g4718_ (if (= _ver624_ '1)
                             '#!void
                             (std/error#raise-io-error
                              'fcgi-read-record
                              '"version mismatch"
                              _ver624_)))
                (_type627_ (u8vector-ref _head618_ '1))
                (_rid629_
                 (fxior (fxarithmetic-shift (u8vector-ref _head618_ '2) '8)
                        (u8vector-ref _head618_ '3)))
                (_clen631_
                 (fxior (fxarithmetic-shift (u8vector-ref _head618_ '4) '8)
                        (u8vector-ref _head618_ '5)))
                (_plen633_ (u8vector-ref _head618_ '6))
                (_dlen635_ (fx+ _clen631_ _plen633_))
                (_data637_ (make-u8vector _dlen635_))
                (_rd639_ (if (fxpositive? _dlen635_)
                             (read-subu8vector
                              _data637_
                              '0
                              _dlen635_
                              _port614_)
                             _rd620_))
                (_g4719_ (if (fx< _rd639_ _dlen635_)
                             (std/error#raise-io-error
                              'fcgi-read-record
                              '"incomplete record")
                             '#!void))
                (_g4720_ (if (fxpositive? _plen633_)
                             (u8vector-shrink! _data637_ _clen631_)
                             '#!void)))
           (values _type627_ _rid629_ _data637_))))))
  (define std/web/fastcgi#fcgi-read-key-value-pairs
    (lambda (_port571_)
      (letrec ((_read-length573_
                (lambda (_port598_)
                  (let ((_nb0600_ (read-u8 _port598_)))
                    (if (eof-object? _nb0600_)
                        _nb0600_
                        (if (zero? (fxarithmetic-shift _nb0600_ '-7))
                            _nb0600_
                            (let* ((_nb3602_ (fxand _nb0600_ '127))
                                   (_nb2604_ (read-u8 _port598_))
                                   (_g4721_ (if (eof-object? _nb2604_)
                                                (std/error#raise-io-error
                                                 'fcgi-read-key-value-pairs
                                                 '"premature port end")
                                                '#!void))
                                   (_nb1607_ (read-u8 _port598_))
                                   (_g4722_ (if (eof-object? _nb1607_)
                                                (std/error#raise-io-error
                                                 'fcgi-read-key-value-pairs
                                                 '"premature port end")
                                                '#!void))
                                   (_nb0610_ (read-u8 _port598_))
                                   (_g4723_ (if (eof-object? _nb0610_)
                                                (std/error#raise-io-error
                                                 'fcgi-read-key-value-pairs
                                                 '"premature port end")
                                                '#!void)))
                              (fxior (fxarithmetic-shift _nb3602_ '24)
                                     (fxarithmetic-shift _nb2604_ '16)
                                     (fxarithmetic-shift _nb1607_ '8)
                                     _nb0610_))))))))
        (let _lp575_ ((_klen577_ (_read-length573_ _port571_)) (_r578_ '()))
          (if (eof-object? _klen577_)
              (reverse _r578_)
              (let* ((_vlen580_ (_read-length573_ _port571_))
                     (_g4724_ (if (eof-object? _vlen580_)
                                  (std/error#raise-io-error
                                   'fcgi-read-key-value-pairs
                                   '"premature port end")
                                  '#!void))
                     (_kdata583_ (make-u8vector _klen577_))
                     (_rd585_ (read-subu8vector
                               _kdata583_
                               '0
                               _klen577_
                               _port571_))
                     (_g4725_ (if (fx< _rd585_ _klen577_)
                                  (std/error#raise-io-error
                                   'fcgi-read-key-value-pairs
                                   '"premature port end")
                                  '#!void))
                     (_vdata588_ (make-u8vector _vlen580_))
                     (_rd590_ (read-subu8vector
                               _vdata588_
                               '0
                               _vlen580_
                               _port571_))
                     (_g4726_ (if (fx< _rd590_ _vlen580_)
                                  (std/error#raise-io-error
                                   'fcgi-read-key-value-pairs
                                   '"premature port end")
                                  '#!void))
                     (_key593_
                      (string->symbol
                       (std/text/utf8#utf8->string__0 _kdata583_)))
                     (_value595_ (std/text/utf8#utf8->string__0 _vdata588_)))
                (_lp575_ (_read-length573_ _port571_)
                         (cons (cons _key593_ _value595_) _r578_))))))))
  (define std/web/fastcgi#fcgi-write-record__%
    (lambda (_port527_ _type528_ _reqid529_ _data530_ _start531_ _end532_)
      (let* ((_head534_ (make-u8vector '8))
             (_end539_
              (let ((_$e536_ _end532_))
                (if _$e536_ _$e536_ (u8vector-length _data530_))))
             (_clen541_ (fx- _end539_ _start531_)))
        (u8vector-set! _head534_ '0 '1)
        (u8vector-set! _head534_ '1 _type528_)
        (u8vector-set!
         _head534_
         '2
         (fxand (fxarithmetic-shift _reqid529_ '-8) '255))
        (u8vector-set! _head534_ '3 (fxand _reqid529_ '255))
        (u8vector-set!
         _head534_
         '4
         (fxand (fxarithmetic-shift _clen541_ '-8) '255))
        (u8vector-set! _head534_ '5 (fxand _clen541_ '255))
        (write-subu8vector _head534_ '0 '8 _port527_)
        (write-subu8vector _data530_ _start531_ _end539_ _port527_)
        (force-output _port527_))))
  (define std/web/fastcgi#fcgi-write-record__0
    (lambda (_port547_ _type548_ _reqid549_ _data550_)
      (let* ((_start552_ '0) (_end554_ '#f))
        (std/web/fastcgi#fcgi-write-record__%
         _port547_
         _type548_
         _reqid549_
         _data550_
         _start552_
         _end554_))))
  (define std/web/fastcgi#fcgi-write-record__1
    (lambda (_port556_ _type557_ _reqid558_ _data559_ _start560_)
      (let ((_end562_ '#f))
        (std/web/fastcgi#fcgi-write-record__%
         _port556_
         _type557_
         _reqid558_
         _data559_
         _start560_
         _end562_))))
  (define std/web/fastcgi#fcgi-write-record
    (lambda _g4728_
      (let ((_g4727_ (let () (declare (not safe)) (##length _g4728_))))
        (cond ((let () (declare (not safe)) (##fx= _g4727_ 4))
               (apply std/web/fastcgi#fcgi-write-record__0 _g4728_))
              ((let () (declare (not safe)) (##fx= _g4727_ 5))
               (apply std/web/fastcgi#fcgi-write-record__1 _g4728_))
              ((let () (declare (not safe)) (##fx= _g4727_ 6))
               (apply std/web/fastcgi#fcgi-write-record__% _g4728_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/web/fastcgi#fcgi-write-record
                _g4728_))))))
  (define std/web/fastcgi#fcgi-write-data
    (lambda (_port510_ _type511_ _reqid512_ _data513_)
      (let* ((_data515_
              (if (string? _data513_)
                  (std/text/utf8#string->utf8__0 _data513_)
                  _data513_))
             (_len517_ (u8vector-length _data515_)))
        (let _lp520_ ((_start522_ '0))
          (if (fx> (fx- _len517_ _start522_) '65535)
              (let ((_end524_ (fx+ _start522_ '65535)))
                (std/web/fastcgi#fcgi-write-record__%
                 _port510_
                 _type511_
                 _reqid512_
                 _data515_
                 _start522_
                 _end524_)
                (_lp520_ _end524_))
              (std/web/fastcgi#fcgi-write-record__%
               _port510_
               _type511_
               _reqid512_
               _data515_
               _start522_
               _len517_))))))
  (define std/web/fastcgi#fcgi-write-key-value-pairs
    (lambda (_port431_ _alst432_)
      (letrec ((_write-length434_
                (lambda (_port502_ _len503_)
                  (if (fx< _len503_ '128)
                      (write-u8 _len503_ _port502_)
                      (let ((_nb3505_
                             (fxior (fxand (fxarithmetic-shift _len503_ '-24)
                                           '127)
                                    '128))
                            (_nb2506_
                             (fxand (fxarithmetic-shift _len503_ '-16) '255))
                            (_nb1507_
                             (fxand (fxarithmetic-shift _len503_ '-8) '255))
                            (_nb0508_ (fxand _len503_ '255)))
                        (write-u8 _nb3505_ _port502_)
                        (write-u8 _nb2506_ _port502_)
                        (write-u8 _nb1507_ _port502_)
                        (write-u8 _nb0508_ _port502_))))))
        (let ((_iterable476_ _alst432_)
              (_iter-do478_
               (lambda (_val436_)
                 (let* ((_val438445_ _val436_)
                        (_E440449_
                         (lambda () (error '"No clause matching" _val438445_)))
                        (_K441464_
                         (lambda (_value452_ _key453_)
                           (let* ((_kdata455_
                                   (std/text/utf8#string->utf8__0
                                    (symbol->string _key453_)))
                                  (_klen457_ (u8vector-length _kdata455_))
                                  (_vdata459_
                                   (if (string? _value452_)
                                       (std/text/utf8#string->utf8__0
                                        _value452_)
                                       _value452_))
                                  (_vlen461_ (u8vector-length _vdata459_)))
                             (_write-length434_ _port431_ _klen457_)
                             (_write-length434_ _port431_ _vlen461_)
                             (write-subu8vector
                              _kdata455_
                              '0
                              _klen457_
                              _port431_)
                             (write-subu8vector
                              _vdata459_
                              '0
                              _vlen461_
                              _port431_)))))
                   (if (let () (declare (not safe)) (##pair? _val438445_))
                       (let ((_hd442467_
                              (let ()
                                (declare (not safe))
                                (##car _val438445_)))
                             (_tl443469_
                              (let ()
                                (declare (not safe))
                                (##cdr _val438445_))))
                         (let* ((_key472_ _hd442467_) (_value474_ _tl443469_))
                           (_K441464_ _value474_ _key472_)))
                       (_E440449_))))))
          (if (pair? _iterable476_)
              (for-each _iter-do478_ _iterable476_)
              (if (null? _iterable476_)
                  '#!void
                  (let* ((_it481_ (std/iter#iter _iterable476_))
                         (_next!484_
                          (let ()
                            (declare (not safe))
                            (##unchecked-structure-ref
                             _it481_
                             '2
                             std/iter#iterator::t
                             '#f))))
                    (declare (not safe))
                    (begin
                      (let _lp489_ ()
                        (let ((_val493_ (_next!484_ _it481_)))
                          (if (eq? std/iter#iter-end _val493_)
                              '#!void
                              (begin (_iter-do478_ _val493_) (_lp489_)))))
                      (let ((_$e495_ (##unchecked-structure-ref
                                      _it481_
                                      '3
                                      std/iter#iterator::t
                                      '#f)))
                        (if _$e495_
                            ((lambda (_g497499_) (_g497499_ _it481_)) _$e495_)
                            '#!void))
                      '#!void))))))))
  (define std/web/fastcgi#fcgi-begin-request-e
    (lambda (_data426_)
      (let ((_role428_
             (fxior (fxarithmetic-shift (u8vector-ref _data426_ '0) '8)
                    (u8vector-ref _data426_ '1)))
            (_flags429_ (u8vector-ref _data426_ '2)))
        (if (eq? _role428_ std/web/fastcgi#FCGI-RESPONDER)
            (values 'FCGI-RESPONDER _flags429_)
            (if (eq? _role428_ std/web/fastcgi#FCGI-AUTHORIZER)
                (values 'FCGI-AUTHORIZER _flags429_)
                (if (eq? _role428_ std/web/fastcgi#FCGI-FILTER)
                    (values 'FCGI-FILTER _flags429_)
                    (values _role428_ _flags429_)))))))
  (define std/web/fastcgi#fcgi-get-values-e
    (lambda (_data424_)
      (map car
           (std/web/fastcgi#fcgi-read-key-value-pairs
            (open-input-u8vector _data424_)))))
  (define std/web/fastcgi#fcgi-params-e
    (lambda (_data422_)
      (std/web/fastcgi#fcgi-read-key-value-pairs
       (open-input-u8vector _data422_))))
  (define std/web/fastcgi#fcgi-get-values-result-data
    (lambda (_alst418_)
      (let ((_outp420_ (open-output-u8vector)))
        (std/web/fastcgi#fcgi-write-key-value-pairs _outp420_ _alst418_)
        (get-output-u8vector _outp420_))))
  (define std/web/fastcgi#fcgi-unknown-type-data
    (lambda (_type414_)
      (let ((_data416_ (make-u8vector '8)))
        (u8vector-set! _data416_ '0 _type414_)
        _data416_)))
  (define std/web/fastcgi#fcgi-end-request-data
    (lambda (_app-status409_ _proto-status410_)
      (let ((_data412_ (make-u8vector '8)))
        (u8vector-set!
         _data412_
         '0
         (fxand (fxarithmetic-shift _app-status409_ '-24) '255))
        (u8vector-set!
         _data412_
         '1
         (fxand (fxarithmetic-shift _app-status409_ '-16) '255))
        (u8vector-set!
         _data412_
         '2
         (fxand (fxarithmetic-shift _app-status409_ '-8) '255))
        (u8vector-set! _data412_ '3 (fxand _app-status409_ '255))
        (u8vector-set! _data412_ '4 _proto-status410_)
        _data412_))))
