(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/signal-handler#system-signal-handler
    (make-promise
     (lambda ()
       (let ((__obj4377
              (make-object std/os/signal-handler#signal-handler::t '4)))
         (std/os/signal-handler#signal-handler:::init! __obj4377)
         __obj4377))))
  (define std/os/signal-handler#add-signal-handler!
    (lambda (_signo774_ _thunk775_)
      (if (and (fx> _signo774_ '0) (fx< _signo774_ std/os/signal#SIGMAX))
          '#!void
          (error '"Invalid signal" _signo774_))
      (let ((_handler777_ (force std/os/signal-handler#system-signal-handler)))
        (std/os/signal-handler#signal-handler-add!
         _handler777_
         _signo774_
         _thunk775_))))
  (define std/os/signal-handler#remove-signal-handler!
    (lambda (_signo770_)
      (if (and (fx> _signo770_ '0) (fx< _signo770_ std/os/signal#SIGMAX))
          '#!void
          (error '"Invalid signal" _signo770_))
      (let ((_handler772_ (force std/os/signal-handler#system-signal-handler)))
        (std/os/signal-handler#signal-handler-remove!
         _handler772_
         _signo770_))))
  (define std/os/signal-handler#signal-handler::t
    (make-struct-type
     'std/os/signal-handler#signal-handler::t
     '#f
     '4
     'signal-handler
     '((final: . #t))
     ':init!
     '(handlers default-handlers kq mx)))
  (define std/os/signal-handler#signal-handler?
    (make-struct-predicate std/os/signal-handler#signal-handler::t))
  (define std/os/signal-handler#make-signal-handler
    (lambda _$args767_
      (apply make-struct-instance
             std/os/signal-handler#signal-handler::t
             _$args767_)))
  (define std/os/signal-handler#signal-handler-handlers
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '0))
  (define std/os/signal-handler#signal-handler-default-handlers
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '1))
  (define std/os/signal-handler#signal-handler-kq
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '2))
  (define std/os/signal-handler#signal-handler-mx
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '3))
  (define std/os/signal-handler#signal-handler-handlers-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '0))
  (define std/os/signal-handler#signal-handler-default-handlers-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '1))
  (define std/os/signal-handler#signal-handler-kq-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '2))
  (define std/os/signal-handler#signal-handler-mx-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '3))
  (define std/os/signal-handler#signal-handler:::init!
    (lambda (_self756_)
      (let* ((_handlers758_ (make-vector std/os/signal#SIGMAX '#f))
             (_default-handlers760_ (make-vector std/os/signal#SIGMAX '#f))
             (_kq762_ (std/os/kqueue#kqueue))
             (_mx764_ (make-mutex 'signal-handler)))
        (if (let ((__tmp4378
                   (let () (declare (not safe)) (##vector-length _self756_))))
              (declare (not safe))
              (##fx< '4 __tmp4378))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! _self756_ '1 _handlers758_))
              (let ()
                (declare (not safe))
                (##vector-set! _self756_ '2 _default-handlers760_))
              (let ()
                (declare (not safe))
                (##vector-set! _self756_ '3 _kq762_))
              (let ()
                (declare (not safe))
                (##vector-set! _self756_ '4 _mx764_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self756_))
        (std/logger#start-logger!__0)
        (gerbil/gambit/threads#spawn/name
         'signal-handler
         std/os/signal-handler#signal-handler-wait
         _self756_))))
  (bind-method!
   std/os/signal-handler#signal-handler::t
   ':init!
   std/os/signal-handler#signal-handler:::init!
   '#f)
  (define std/os/signal-handler#signal-handler-wait
    (lambda (_sh525_)
      (with-exception-catcher
       (lambda (_g526528_)
         (if '#t
             (let ((_e531_ _g526528_))
               (std/logger#log-error '"Error handling signals" _e531_)
               (raise _e531_))
             (raise _g526528_)))
       (lambda ()
         (letrec* ((_events577_ (std/os/kqueue#make-kevents '4)))
           (let* ((_sh578587_ _sh525_)
                  (_E580591_
                   (lambda () (error '"No clause matching" _sh578587_)))
                  (_K581611_
                   (lambda (_mx594_
                            _kq595_
                            _default-handlers596_
                            _handlers597_)
                     (let _wait-loop599_ ()
                       (let ((__tmp4379 (std/os/fd#fd-io-in _kq595_)))
                         (declare (not safe))
                         (##wait-for-io! __tmp4379 '#t))
                       (let ((_n602_ (std/os/kqueue#kqueue-poll
                                      _kq595_
                                      _events577_
                                      '4)))
                         (if (let ()
                               (declare (not safe))
                               (##fxpositive? _n602_))
                             (let _event-loop604_ ((_i606_ '0))
                               (if (fx< _i606_ _n602_)
                                   (begin
                                     (if (let ((__tmp4380
                                                (let ((__tmp4381
                                                       (std/os/kqueue#kevent-flags
                                                        _events577_
                                                        _i606_)))
                                                  (declare (not safe))
                                                  (##fxand __tmp4381
                                                           std/os/kqueue#EV_ERROR))))
                                           (declare (not safe))
                                           (##fxzero? __tmp4380))
                                         (if (fx= (std/os/kqueue#kevent-filter
                                                   _events577_
                                                   _i606_)
                                                  std/os/kqueue#EVFILT_SIGNAL)
                                             (let ((_event-handler609_
                                                    (gerbil/gambit/threads#with-lock
                                                     _mx594_
                                                     (lambda ()
                                                       (vector-ref
                                                        _handlers597_
                                                        (std/os/kqueue#kevent-ident
                                                         _events577_
                                                         _i606_))))))
                                               (if _event-handler609_
                                                   (std/os/signal-handler#signal-handler-dispatch
                                                    _event-handler609_)
                                                   '#!void))
                                             '#!void)
                                         (std/os/error#raise-os-error
                                          (std/os/kqueue#kevent-data
                                           _events577_
                                           _i606_)
                                          std/os/signal-handler#signal-handler-wait))
                                     (_event-loop604_ (fx+ _i606_ '1)))
                                   '#!void))
                             '#!void))
                       (_wait-loop599_)))))
             (if (let ()
                   (declare (not safe))
                   (##structure-direct-instance-of?
                    _sh578587_
                    'std/os/signal-handler#signal-handler::t))
                 (let* ((_e582614_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _sh578587_ '1)))
                        (_handlers617_ _e582614_)
                        (_e583619_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _sh578587_ '2)))
                        (_default-handlers622_ _e583619_)
                        (_e584624_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _sh578587_ '3)))
                        (_kq627_ _e584624_)
                        (_e585629_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _sh578587_ '4)))
                        (_mx632_ _e585629_))
                   (_K581611_
                    _mx632_
                    _kq627_
                    _default-handlers622_
                    _handlers617_))
                 (_E580591_))))))))
  (define std/os/signal-handler#signal-handler-add!
    (lambda (_sh475_ _signo476_ _thunk477_)
      (let* ((_sh478487_ _sh475_)
             (_E480491_ (lambda () (error '"No clause matching" _sh478487_)))
             (_K481502_
              (lambda (_mx494_ _kq495_ _default-handlers496_ _handlers497_)
                (gerbil/gambit/threads#with-lock
                 _mx494_
                 (lambda ()
                   (let ((_ev500_ (std/os/kqueue#make-kevents '1)))
                     (vector-set! _handlers497_ _signo476_ _thunk477_)
                     (std/os/kqueue#kqueue-kevent-add__0
                      _kq495_
                      _signo476_
                      std/os/kqueue#EVFILT_SIGNAL)
                     (std/os/signal-handler#ignore-signal!
                      _sh475_
                      _signo476_)))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _sh478487_
               'std/os/signal-handler#signal-handler::t))
            (let* ((_e482505_
                    (let () (declare (not safe)) (##vector-ref _sh478487_ '1)))
                   (_handlers508_ _e482505_)
                   (_e483510_
                    (let () (declare (not safe)) (##vector-ref _sh478487_ '2)))
                   (_default-handlers513_ _e483510_)
                   (_e484515_
                    (let () (declare (not safe)) (##vector-ref _sh478487_ '3)))
                   (_kq518_ _e484515_)
                   (_e485520_
                    (let () (declare (not safe)) (##vector-ref _sh478487_ '4)))
                   (_mx523_ _e485520_))
              (_K481502_ _mx523_ _kq518_ _default-handlers513_ _handlers508_))
            (_E480491_)))))
  (define std/os/signal-handler#signal-handler-remove!
    (lambda (_sh426_ _signo427_)
      (let* ((_sh428437_ _sh426_)
             (_E430441_ (lambda () (error '"No clause matching" _sh428437_)))
             (_K431452_
              (lambda (_mx444_ _kq445_ _default-handlers446_ _handlers447_)
                (gerbil/gambit/threads#with-lock
                 _mx444_
                 (lambda ()
                   (let ((_ev450_ (std/os/kqueue#make-kevents '1)))
                     (std/os/signal-handler#restore-signal! _sh426_ _signo427_)
                     (std/os/kqueue#kqueue-kevent-del
                      _kq445_
                      _signo427_
                      std/os/kqueue#EVFILT_SIGNAL)
                     (vector-set! _handlers447_ _signo427_ '#f)))))))
        (if (let ()
              (declare (not safe))
              (##structure-direct-instance-of?
               _sh428437_
               'std/os/signal-handler#signal-handler::t))
            (let* ((_e432455_
                    (let () (declare (not safe)) (##vector-ref _sh428437_ '1)))
                   (_handlers458_ _e432455_)
                   (_e433460_
                    (let () (declare (not safe)) (##vector-ref _sh428437_ '2)))
                   (_default-handlers463_ _e433460_)
                   (_e434465_
                    (let () (declare (not safe)) (##vector-ref _sh428437_ '3)))
                   (_kq468_ _e434465_)
                   (_e435470_
                    (let () (declare (not safe)) (##vector-ref _sh428437_ '4)))
                   (_mx473_ _e435470_))
              (_K431452_ _mx473_ _kq468_ _default-handlers463_ _handlers458_))
            (_E430441_)))))
  (define std/os/signal-handler#ignore-signal!
    (lambda (_sh418_ _signo419_)
      (let* ((_default-handlers421_
              (##direct-structure-ref
               _sh418_
               '2
               std/os/signal-handler#signal-handler::t
               '#f))
             (_default-handler423_
              (std/os/signal-handler#set-signal!
               _signo419_
               std/os/signal-handler#SIG_IGN)))
        (if (vector-ref _default-handlers421_ _signo419_)
            '#!void
            (vector-set!
             _default-handlers421_
             _signo419_
             _default-handler423_)))))
  (define std/os/signal-handler#restore-signal!
    (lambda (_sh410_ _signo411_)
      (let* ((_default-handlers413_
              (##direct-structure-ref
               _sh410_
               '2
               std/os/signal-handler#signal-handler::t
               '#f))
             (_default-handler415_
              (vector-ref _default-handlers413_ _signo411_)))
        (if (vector-ref _default-handlers413_ _signo411_)
            (std/os/signal-handler#set-signal! _signo411_ _default-handler415_)
            '#!void))))
  (c-declare "#include <signal.h>")
  (namespace ("std/os/signal-handler#" SIG_IGN set-signal!))
  (define SIG_IGN
    ((c-lambda () (pointer "void") "___return((void *)SIG_IGN);")))
  (define set-signal!
    (c-lambda
     (int (pointer "void"))
     (pointer "void")
     "___return((void*)signal(___arg1, (void (*)(int))(___arg2)));"))
  (define std/os/signal-handler#signal-handler-dispatch
    (lambda (_handler401_)
      (with-exception-catcher
       (lambda (_g402404_)
         (if '#t
             (let ((_e407_ _g402404_))
               (std/logger#log-error
                '"error dispatching signal handler"
                _e407_))
             (raise _g402404_)))
       (lambda () (_handler401_))))))
