/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class CalAmpProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_NULL = 0;
    public static final int MSG_ACK = 1;
    public static final int MSG_EVENT_REPORT = 2;
    public static final int MSG_ID_REPORT = 3;
    public static final int MSG_USER_DATA = 4;
    public static final int MSG_APP_DATA = 5;
    public static final int MSG_CONFIG = 6;
    public static final int MSG_UNIT_REQUEST = 7;
    public static final int MSG_LOCATE_REPORT = 8;
    public static final int MSG_USER_DATA_ACC = 9;
    public static final int MSG_MINI_EVENT_REPORT = 10;
    public static final int MSG_MINI_USER_DATA = 11;
    public static final int SERVICE_UNACKNOWLEDGED = 0;
    public static final int SERVICE_ACKNOWLEDGED = 1;
    public static final int SERVICE_RESPONSE = 2;

    public CalAmpProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type, int index, int result) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)10);
            response.writeByte(2);
            response.writeByte(1);
            response.writeShort(index);
            response.writeByte(type);
            response.writeByte(result);
            response.writeByte(0);
            response.writeMedium(0);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private Position decodePosition(DeviceSession deviceSession, int type, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(buf.readUnsignedInt() * 1000L));
        if (type != 10) {
            buf.readUnsignedInt();
        }
        position.setLatitude((double)buf.readInt() * 1.0E-7);
        position.setLongitude((double)buf.readInt() * 1.0E-7);
        if (type != 10) {
            position.setAltitude((double)buf.readInt() * 0.01);
            position.setSpeed(UnitsConverter.knotsFromCps(buf.readUnsignedInt()));
        }
        position.setCourse(buf.readShort());
        if (type == 10) {
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        }
        if (type == 10) {
            position.set("sat", buf.getUnsignedByte(buf.readerIndex()) & 0xF);
            position.setValid((buf.readUnsignedByte() & 0x20) == 0);
        } else {
            position.set("sat", buf.readUnsignedByte());
            position.setValid((buf.readUnsignedByte() & 8) == 0);
        }
        if (type != 10) {
            position.set("carrier", buf.readUnsignedShort());
            position.set("rssi", buf.readShort());
        }
        position.set("modem", buf.readUnsignedByte());
        if (type != 10) {
            position.set("hdop", buf.readUnsignedByte());
        }
        short input = buf.readUnsignedByte();
        position.set("input", Integer.valueOf(input));
        position.set("ignition", BitUtil.check(input, 0));
        if (type != 10) {
            position.set("status", buf.readUnsignedByte());
        }
        if (type == 2 || type == 10) {
            if (type != 10) {
                buf.readUnsignedByte();
            }
            position.set("event", buf.readUnsignedByte());
        }
        if (type == 2 || type == 8 || type == 10) {
            int accType = BitUtil.from(buf.getUnsignedByte(buf.readerIndex()), 6);
            int accCount = BitUtil.to(buf.readUnsignedByte(), 6);
            if (type != 10) {
                position.set("append", buf.readUnsignedByte());
            }
            if (accType == 1) {
                buf.readUnsignedInt();
                buf.readUnsignedInt();
            }
            for (int i = 0; i < accCount; ++i) {
                if (buf.readableBytes() < 4) continue;
                position.set("acc" + i, buf.readUnsignedInt());
            }
        } else if (type == 4) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.set("result", buf.readCharSequence(buf.readUnsignedShort(), StandardCharsets.US_ASCII).toString().trim());
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        ByteBuf buf = (ByteBuf)msg;
        if (BitUtil.check(buf.getByte(buf.readerIndex()), 7)) {
            short content = buf.readUnsignedByte();
            if (BitUtil.check(content, 0)) {
                String id = ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)buf.readUnsignedByte())).replace("f", "");
                this.getDeviceSession(channel, remoteAddress, id);
            }
            if (BitUtil.check(content, 1)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            if (BitUtil.check(content, 2)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            if (BitUtil.check(content, 3)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            if (BitUtil.check(content, 4)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
            if (BitUtil.check(content, 5)) {
                buf.skipBytes((int)buf.readUnsignedByte());
            }
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0])) == null) {
            return null;
        }
        short service = buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        int index = buf.readUnsignedShort();
        if (service == 1) {
            this.sendResponse(channel, remoteAddress, type, index, 0);
        }
        if (type == 2 || type == 8 || type == 10 || type == 4) {
            return this.decodePosition(deviceSession, type, buf);
        }
        return null;
    }
}

