/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintImage;
import org.w3c.tools.codec.Base64Decoder;

public class JRPrintImageSourceObject {
    private JRPrintImage printImage = null;
    private boolean isEmbedded = false;

    public void setPrintImage(JRPrintImage printImage) {
        this.printImage = printImage;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public void setImageSource(String imageSource) throws JRException {
        if (this.isEmbedded) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(imageSource.getBytes("UTF-8"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64Decoder decoder = new Base64Decoder(bais, baos);
                decoder.process();
                this.printImage.setRenderer(JRImageRenderer.getInstance(baos.toByteArray()));
            }
            catch (Exception e) {
                throw new JRException("Error decoding embedded image.", e);
            }
        } else {
            this.printImage.setRenderer(JRImageRenderer.getInstance(imageSource));
        }
    }
}

