/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.collector;

import io.prometheus.client.Collector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MetricSamples {
    private final Map<String, Collector.MetricFamilySamples> samplesByMetricName;

    public MetricSamples(Map<String, Collector.MetricFamilySamples> input) {
        this.samplesByMetricName = input;
    }

    public MetricSamples() {
        this(new HashMap<String, Collector.MetricFamilySamples>());
    }

    public void addSamplesIfNotPresent(String metricName, Collector.MetricFamilySamples samples) {
        this.samplesByMetricName.putIfAbsent(metricName, samples);
    }

    public void addSampleIfMetricExists(String metricName, Collector.MetricFamilySamples.Sample sample) {
        Collector.MetricFamilySamples sampleFamily = this.samplesByMetricName.get(metricName);
        if (sampleFamily == null) {
            return;
        }
        if (!sampleFamily.samples.contains(sample)) {
            sampleFamily.samples.add(sample);
        }
    }

    public void addAll(MetricSamples other) {
        for (Map.Entry<String, Collector.MetricFamilySamples> entry : other.samplesByMetricName.entrySet()) {
            String key = entry.getKey();
            if (this.samplesByMetricName.containsKey(key)) {
                for (Collector.MetricFamilySamples.Sample sample : entry.getValue().samples) {
                    this.addSampleIfMetricExists(key, sample);
                }
                continue;
            }
            this.samplesByMetricName.put(key, entry.getValue());
        }
    }

    public List<Collector.MetricFamilySamples> asList() {
        return this.samplesByMetricName.values().stream().filter(value -> !value.samples.isEmpty()).collect(Collectors.toList());
    }
}

