/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul - u64vec2(10ul, 12ul)) => u64vec2(18446744073709551606ul, 18446744073709551604ul)
 * (0ul - u64vec2(42ul, 48ul)) => u64vec2(18446744073709551574ul, 18446744073709551568ul)
 * (3ul - u64vec2(10ul, 12ul)) => u64vec2(18446744073709551609ul, 18446744073709551607ul)
 * (3ul - u64vec2(42ul, 48ul)) => u64vec2(18446744073709551577ul, 18446744073709551571ul)
 * (1192ul - u64vec2(10ul, 12ul)) => u64vec2(1182ul, 1180ul)
 * (1192ul - u64vec2(42ul, 48ul)) => u64vec2(1150ul, 1144ul)
 * (1048576ul - u64vec2(10ul, 12ul)) => u64vec2(1048566ul, 1048564ul)
 * (1048576ul - u64vec2(42ul, 48ul)) => u64vec2(1048534ul, 1048528ul)
 * (4251475ul - u64vec2(10ul, 12ul)) => u64vec2(4251465ul, 4251463ul)
 * (4251475ul - u64vec2(42ul, 48ul)) => u64vec2(4251433ul, 4251427ul)
 * (29852643761ul - u64vec2(10ul, 12ul)) => u64vec2(29852643751ul, 29852643749ul)
 * (29852643761ul - u64vec2(42ul, 48ul)) => u64vec2(29852643719ul, 29852643713ul)
 * (4398046511104ul - u64vec2(10ul, 12ul)) => u64vec2(4398046511094ul, 4398046511092ul)
 * (4398046511104ul - u64vec2(42ul, 48ul)) => u64vec2(4398046511062ul, 4398046511056ul)
 * (3948976685146ul - u64vec2(10ul, 12ul)) => u64vec2(3948976685136ul, 3948976685134ul)
 * (3948976685146ul - u64vec2(42ul, 48ul)) => u64vec2(3948976685104ul, 3948976685098ul)
 * (135763469567146206ul - u64vec2(10ul, 12ul)) => u64vec2(135763469567146196ul, 135763469567146194ul)
 * (135763469567146206ul - u64vec2(42ul, 48ul)) => u64vec2(135763469567146164ul, 135763469567146158ul)
 * (11654173250180970009ul - u64vec2(10ul, 12ul)) => u64vec2(11654173250180969999ul, 11654173250180969997ul)
 * (11654173250180970009ul - u64vec2(42ul, 48ul)) => u64vec2(11654173250180969967ul, 11654173250180969961ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul - u64vec2(10ul, 12ul)), u64vec2(18446744073709551606ul, 18446744073709551604ul))) ? 1 : -1] array0;
  float[all(equal((0ul - u64vec2(42ul, 48ul)), u64vec2(18446744073709551574ul, 18446744073709551568ul))) ? 1 : -1] array1;
  float[all(equal((3ul - u64vec2(10ul, 12ul)), u64vec2(18446744073709551609ul, 18446744073709551607ul))) ? 1 : -1] array2;
  float[all(equal((3ul - u64vec2(42ul, 48ul)), u64vec2(18446744073709551577ul, 18446744073709551571ul))) ? 1 : -1] array3;
  float[all(equal((1192ul - u64vec2(10ul, 12ul)), u64vec2(1182ul, 1180ul))) ? 1 : -1] array4;
  float[all(equal((1192ul - u64vec2(42ul, 48ul)), u64vec2(1150ul, 1144ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul - u64vec2(10ul, 12ul)), u64vec2(1048566ul, 1048564ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul - u64vec2(42ul, 48ul)), u64vec2(1048534ul, 1048528ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul - u64vec2(10ul, 12ul)), u64vec2(4251465ul, 4251463ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul - u64vec2(42ul, 48ul)), u64vec2(4251433ul, 4251427ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul - u64vec2(10ul, 12ul)), u64vec2(29852643751ul, 29852643749ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul - u64vec2(42ul, 48ul)), u64vec2(29852643719ul, 29852643713ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul - u64vec2(10ul, 12ul)), u64vec2(4398046511094ul, 4398046511092ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul - u64vec2(42ul, 48ul)), u64vec2(4398046511062ul, 4398046511056ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul - u64vec2(10ul, 12ul)), u64vec2(3948976685136ul, 3948976685134ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul - u64vec2(42ul, 48ul)), u64vec2(3948976685104ul, 3948976685098ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul - u64vec2(10ul, 12ul)), u64vec2(135763469567146196ul, 135763469567146194ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul - u64vec2(42ul, 48ul)), u64vec2(135763469567146164ul, 135763469567146158ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul - u64vec2(10ul, 12ul)), u64vec2(11654173250180969999ul, 11654173250180969997ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul - u64vec2(42ul, 48ul)), u64vec2(11654173250180969967ul, 11654173250180969961ul))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
