/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Contexts;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtils;

public class ContextExpression {
    private HashSet<String> contexts = new HashSet();
    private String originalString = null;

    public ContextExpression() {
    }

    public ContextExpression(String ... contexts) {
        if (contexts.length == 1) {
            this.parseContextString(contexts[0]);
        } else {
            for (String context : contexts) {
                this.parseContextString(context.toLowerCase());
            }
        }
    }

    public ContextExpression(String contexts) {
        this.parseContextString(contexts);
        this.originalString = contexts;
    }

    public ContextExpression(Collection<String> contexts) {
        if (contexts != null) {
            for (String context : contexts) {
                this.contexts.add(context.toLowerCase());
            }
        }
    }

    private void parseContextString(String contexts) {
        if ((contexts = StringUtils.trimToNull(contexts)) == null) {
            return;
        }
        for (String context : StringUtils.splitAndTrim(contexts, ",")) {
            this.contexts.add(context.toLowerCase());
        }
    }

    public boolean add(String context) {
        return this.contexts.add(context.toLowerCase());
    }

    public Set<String> getContexts() {
        return Collections.unmodifiableSet(this.contexts);
    }

    public String toString() {
        if (this.originalString != null) {
            return this.originalString;
        }
        return "(" + StringUtils.join(new TreeSet<String>(this.contexts), "), (") + ")";
    }

    public boolean matches(Contexts runtimeContexts) {
        if (runtimeContexts == null || runtimeContexts.isEmpty()) {
            return true;
        }
        if (this.contexts.size() == 0) {
            return true;
        }
        for (String expression : this.contexts) {
            if (!this.matches(expression, runtimeContexts)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String expression, Contexts runtimeContexts) {
        if (runtimeContexts.isEmpty()) {
            return true;
        }
        if (expression.trim().equals(":TRUE")) {
            return true;
        }
        if (expression.trim().equals(":FALSE")) {
            return false;
        }
        while (expression.contains("(")) {
            Pattern pattern = Pattern.compile("(.*?)\\((.*?)\\)(.*)");
            Matcher matcher = pattern.matcher(expression);
            if (!matcher.matches()) {
                throw new UnexpectedLiquibaseException("Cannot parse context pattern " + expression);
            }
            String parenExpression = matcher.group(2);
            parenExpression = ":" + String.valueOf(this.matches(parenExpression, runtimeContexts)).toUpperCase();
            expression = matcher.group(1) + " " + parenExpression + " " + matcher.group(3);
        }
        String[] orSplit = expression.split("\\s+or\\s+");
        if (orSplit.length > 1) {
            for (String split : orSplit) {
                if (!this.matches(split, runtimeContexts)) continue;
                return true;
            }
            return false;
        }
        String[] andSplit = expression.split("\\s+and\\s+");
        if (andSplit.length > 1) {
            for (String split : andSplit) {
                if (this.matches(split, runtimeContexts)) continue;
                return false;
            }
            return true;
        }
        boolean notExpression = false;
        if (expression.startsWith("!")) {
            notExpression = true;
            expression = expression.substring(1);
        }
        for (String context : runtimeContexts.getContexts()) {
            if (!context.equalsIgnoreCase(expression)) continue;
            return !notExpression;
        }
        return notExpression;
    }

    public boolean isEmpty() {
        return this.contexts == null || this.contexts.size() == 0;
    }

    public static boolean matchesAll(Collection<ContextExpression> expressions, Contexts contexts) {
        if (expressions == null || expressions.isEmpty()) {
            return true;
        }
        if (contexts == null || contexts.isEmpty()) {
            return true;
        }
        for (ContextExpression expression : expressions) {
            if (expression.matches(contexts)) continue;
            return false;
        }
        return true;
    }
}

