/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.framework.provider.SwingInvocation;
import com.sun.star.script.provider.XScriptContext;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScopeProvider;

public class ScriptEditorForJavaScript
extends ScriptEditor {
    private static ScriptEditorForJavaScript theScriptEditorForJavaScript;
    private static String JSTEMPLATE;
    private static Main rhinoWindow;
    private URL scriptURL;
    private static Map<String, ScriptEditorForJavaScript> BEING_EDITED;

    public static synchronized ScriptEditorForJavaScript getEditor() {
        if (theScriptEditorForJavaScript == null) {
            theScriptEditorForJavaScript = new ScriptEditorForJavaScript();
        }
        return theScriptEditorForJavaScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEditorForJavaScript getEditor(URL uRL) {
        Map<String, ScriptEditorForJavaScript> map = BEING_EDITED;
        synchronized (map) {
            return BEING_EDITED.get(uRL.toExternalForm());
        }
    }

    public boolean isModified() {
        return rhinoWindow.isModified(this.scriptURL);
    }

    public String getText() {
        return rhinoWindow.getText(this.scriptURL);
    }

    public String getURL() {
        return this.scriptURL.toString();
    }

    @Override
    public String getTemplate() {
        return JSTEMPLATE;
    }

    @Override
    public String getExtension() {
        return "js";
    }

    @Override
    public void edit(final XScriptContext xScriptContext, ScriptMetaData scriptMetaData) {
        try {
            String string = scriptMetaData.getParcelLocation();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            string = string + scriptMetaData.getLanguageName();
            final URL uRL = scriptMetaData.getSourceURL();
            SwingInvocation.invoke(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = BEING_EDITED;
                    synchronized (map) {
                        ScriptEditorForJavaScript scriptEditorForJavaScript = (ScriptEditorForJavaScript)BEING_EDITED.get(uRL.toExternalForm());
                        if (scriptEditorForJavaScript == null) {
                            scriptEditorForJavaScript = new ScriptEditorForJavaScript(xScriptContext, uRL);
                            BEING_EDITED.put(uRL.toExternalForm(), scriptEditorForJavaScript);
                        }
                    }
                    assert (rhinoWindow != null);
                    rhinoWindow.showScriptWindow(uRL);
                    rhinoWindow.toFront();
                }
            });
        }
        catch (IOException iOException) {
            LogUtils.DEBUG("Caught exception: " + iOException);
            LogUtils.DEBUG(LogUtils.getTrace(iOException));
        }
    }

    private ScriptEditorForJavaScript() {
    }

    private ScriptEditorForJavaScript(XScriptContext xScriptContext, URL uRL) {
        this.setContext(xScriptContext);
        if (!this.isMacroExecutionEnabled()) {
            this.showErrorMessage("Macro Execution has been disabled.");
            return;
        }
        this.initUI();
        Scriptable scriptable = this.getScope(xScriptContext);
        rhinoWindow.openFile(uRL, scriptable, new CloseHandler(uRL));
        this.scriptURL = uRL;
    }

    @Override
    public Object execute() throws Exception {
        rhinoWindow.toFront();
        return rhinoWindow.runScriptWindow(this.scriptURL);
    }

    @Override
    public void indicateErrorLine(int n) {
        rhinoWindow.toFront();
        rhinoWindow.highlighLineInScriptWindow(this.scriptURL, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        try {
            Class<ScriptEditorForJavaScript> clazz = ScriptEditorForJavaScript.class;
            synchronized (ScriptEditorForJavaScript.class) {
                if (rhinoWindow != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                final Main main = new Main("Rhino JavaScript Debugger");
                main.pack();
                main.setSize(640, 640);
                main.setVisible(true);
                main.setExitAction(new Runnable(){

                    @Override
                    public void run() {
                        main.clearAllBreakpoints();
                        main.dispose();
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                Context.addContextListener(main);
                main.setScopeProvider(new ScopeProvider(){

                    @Override
                    public Scriptable getScope() {
                        return org.mozilla.javascript.tools.shell.Main.getScope();
                    }
                });
                main.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                rhinoWindow = main;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            LogUtils.DEBUG(LogUtils.getTrace(exception));
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        rhinoWindow = null;
        this.scriptURL = null;
        Map<String, ScriptEditorForJavaScript> map = BEING_EDITED;
        synchronized (map) {
            Iterator<String> iterator = BEING_EDITED.keySet().iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string = iterator.next();
                arrayList.add(string);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                BEING_EDITED.remove(arrayList.get(i));
            }
            arrayList = null;
        }
    }

    private Scriptable getScope(XScriptContext xScriptContext) {
        Context context = Context.enter();
        ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
        Scriptable scriptable = Context.toObject(xScriptContext, importerTopLevel);
        importerTopLevel.put("XSCRIPTCONTEXT", (Scriptable)importerTopLevel, (Object)scriptable);
        Scriptable scriptable2 = Context.toObject(new Object[0], importerTopLevel);
        importerTopLevel.put("ARGUMENTS", (Scriptable)importerTopLevel, (Object)scriptable2);
        Context.exit();
        return importerTopLevel;
    }

    static {
        BEING_EDITED = new HashMap<String, ScriptEditorForJavaScript>();
        JSTEMPLATE = "// JavaScript script";
        try {
            URL uRL = ScriptEditorForJavaScript.class.getResource("template.js");
            if (uRL != null) {
                int n;
                InputStream inputStream = uRL.openStream();
                StringBuilder stringBuilder = new StringBuilder();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n));
                }
                inputStream.close();
                JSTEMPLATE = stringBuilder.toString();
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class CloseHandler
    implements Runnable {
        private final URL url;

        private CloseHandler(URL uRL) {
            this.url = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BEING_EDITED;
            synchronized (map) {
                BEING_EDITED.remove(this.url.toExternalForm());
            }
        }
    }
}

