"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../utils/commons");
function getLegendListStyle(position, chartMargins, legendStyle) {
    var paddingTop = chartMargins.top, paddingBottom = chartMargins.bottom, paddingLeft = chartMargins.left, paddingRight = chartMargins.right;
    if (position === commons_1.Position.Bottom || position === commons_1.Position.Top) {
        return {
            paddingLeft: paddingLeft,
            paddingRight: paddingRight,
            gridTemplateColumns: "repeat(auto-fill, minmax(" + legendStyle.verticalWidth + "px, 1fr))",
        };
    }
    return {
        paddingTop: paddingTop,
        paddingBottom: paddingBottom,
    };
}
exports.getLegendListStyle = getLegendListStyle;
function getLegendStyle(position, size, margin) {
    if (position === commons_1.Position.Left || position === commons_1.Position.Right) {
        var width = size.width + "px";
        return {
            width: width,
            maxWidth: width,
            marginLeft: margin,
            marginRight: margin,
        };
    }
    var height = size.height + "px";
    return {
        height: height,
        maxHeight: height,
        marginTop: margin,
        marginBottom: margin,
    };
}
exports.getLegendStyle = getLegendStyle;
//# sourceMappingURL=style_utils.js.map