"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var geometry_1 = require("../../../../utils/geometry");
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var compute_axis_visible_ticks_1 = require("./compute_axis_visible_ticks");
var compute_legend_1 = require("./compute_legend");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_specs_1 = require("./get_specs");
exports.getDebugStateSelector = re_reselect_1.default([compute_series_geometries_1.computeSeriesGeometriesSelector, compute_legend_1.computeLegendSelector, compute_axis_visible_ticks_1.computeAxisVisibleTicksSelector, get_specs_1.getAxisSpecsSelector], function (_a, legend, axes, axesSpecs) {
    var geometries = _a.geometries;
    var seriesNameMap = getSeriesNameMap(legend);
    return {
        legend: getLegendState(legend),
        axes: getAxes(axes, axesSpecs),
        areas: geometries.areas.map(getAreaState(seriesNameMap)),
        lines: geometries.lines.map(getLineState(seriesNameMap)),
        bars: getBarsState(seriesNameMap, geometries.bars),
    };
})(get_chart_id_1.getChartIdSelector);
var getAxes = function (ticks, axesSpecs) {
    if (axesSpecs.length === 0) {
        return;
    }
    return axesSpecs.reduce(function (acc, _a) {
        var position = _a.position, title = _a.title, id = _a.id;
        var _b, _c;
        var axisTicks = (_b = ticks.axisVisibleTicks.get(id), (_b !== null && _b !== void 0 ? _b : []));
        var labels = axisTicks.map(function (_a) {
            var label = _a.label;
            return label;
        });
        var values = axisTicks.map(function (_a) {
            var value = _a.value;
            return value;
        });
        var grids = (_c = ticks.axisGridLinesPositions.get(id), (_c !== null && _c !== void 0 ? _c : []));
        var gridlines = grids.map(function (_a) {
            var _b = __read(_a, 2), x = _b[0], y = _b[1];
            return ({ x: x, y: y });
        });
        if (axis_type_utils_1.isVerticalAxis(position)) {
            acc.y.push({
                id: id,
                title: title,
                position: position,
                labels: labels.reverse(),
                values: values.reverse(),
                gridlines: gridlines.reverse(),
            });
        }
        else {
            acc.x.push({
                id: id,
                title: title,
                position: position,
                labels: labels,
                values: values,
                gridlines: gridlines,
            });
        }
        return acc;
    }, {
        y: [],
        x: [],
    });
};
var getBarsState = function (seriesNameMap, barGeometries) {
    var buckets = new Map();
    barGeometries.forEach(function (_a) {
        var color = _a.color, key = _a.seriesIdentifier.key, _b = _a.seriesStyle, rect = _b.rect, rectBorder = _b.rectBorder, _c = _a.value, x = _c.x, y = _c.y, mark = _c.mark, displayValue = _a.displayValue;
        var _d, _e, _f;
        var label = (_d = displayValue) === null || _d === void 0 ? void 0 : _d.text;
        var name = (_e = seriesNameMap.get(key), (_e !== null && _e !== void 0 ? _e : ''));
        var bucket = (_f = buckets.get(key), (_f !== null && _f !== void 0 ? _f : {
            key: key,
            name: name,
            color: color,
            bars: [],
            labels: [],
            visible: hasVisibleStyle(rect) || hasVisibleStyle(rectBorder),
        }));
        bucket.bars.push({ x: x, y: y, mark: mark });
        if (label) {
            bucket.labels.push(label);
        }
        buckets.set(key, bucket);
        return buckets;
    });
    return __spread(buckets.values());
};
var getLineState = function (seriesNameMap) { return function (_a) {
    var path = _a.line, points = _a.points, color = _a.color, key = _a.seriesIdentifier.key, seriesLineStyle = _a.seriesLineStyle, seriesPointStyle = _a.seriesPointStyle;
    var _b;
    var name = (_b = seriesNameMap.get(key), (_b !== null && _b !== void 0 ? _b : ''));
    return {
        path: path,
        color: color,
        key: key,
        name: name,
        visible: hasVisibleStyle(seriesLineStyle),
        visiblePoints: hasVisibleStyle(seriesPointStyle),
        points: points.map(function (_a) {
            var _b = _a.value, x = _b.x, y = _b.y, mark = _b.mark;
            return ({ x: x, y: y, mark: mark });
        }),
    };
}; };
var getAreaState = function (seriesNameMap) { return function (_a) {
    var path = _a.area, lines = _a.lines, points = _a.points, color = _a.color, key = _a.seriesIdentifier.key, seriesAreaStyle = _a.seriesAreaStyle, seriesPointStyle = _a.seriesPointStyle, seriesAreaLineStyle = _a.seriesAreaLineStyle;
    var _b;
    var _c = __read(lines, 2), y1Path = _c[0], y0Path = _c[1];
    var linePoints = points.reduce(function (acc, _a) {
        var _b = _a.value, accessor = _b.accessor, value = __rest(_b, ["accessor"]);
        if (accessor === geometry_1.BandedAccessorType.Y0) {
            acc.y0.push(value);
        }
        else {
            acc.y1.push(value);
        }
        return acc;
    }, {
        y0: [],
        y1: [],
    });
    var lineVisible = hasVisibleStyle(seriesAreaLineStyle);
    var visiblePoints = hasVisibleStyle(seriesPointStyle);
    var name = (_b = seriesNameMap.get(key), (_b !== null && _b !== void 0 ? _b : ''));
    return {
        path: path,
        color: color,
        key: key,
        name: name,
        visible: hasVisibleStyle(seriesAreaStyle),
        lines: {
            y0: y0Path
                ? {
                    visible: lineVisible,
                    path: y0Path,
                    points: linePoints.y0,
                    visiblePoints: visiblePoints,
                }
                : undefined,
            y1: {
                visible: lineVisible,
                path: y1Path,
                points: linePoints.y1,
                visiblePoints: visiblePoints,
            },
        },
    };
}; };
function getSeriesNameMap(legendItems) {
    return legendItems.reduce(function (acc, _a) {
        var name = _a.label, key = _a.seriesIdentifier.key;
        acc.set(key, name);
        return acc;
    }, new Map());
}
function getLegendState(legendItems) {
    var items = legendItems
        .filter(function (_a) {
        var isSeriesHidden = _a.isSeriesHidden;
        return !isSeriesHidden;
    })
        .map(function (_a) {
        var name = _a.label, color = _a.color, key = _a.seriesIdentifier.key;
        return ({
            key: key,
            name: name,
            color: color,
        });
    });
    return { items: items };
}
function hasVisibleStyle(_a) {
    var _b = _a.visible, visible = _b === void 0 ? true : _b, _c = _a.fill, fill = _c === void 0 ? '#fff' : _c, _d = _a.stroke, stroke = _d === void 0 ? '#fff' : _d, _e = _a.strokeWidth, strokeWidth = _e === void 0 ? 1 : _e, _f = _a.opacity, opacity = _f === void 0 ? 1 : _f;
    return Boolean(visible && opacity > 0 && strokeWidth > 0 && fill && stroke);
}
//# sourceMappingURL=get_debug_state.js.map