/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.GeoProperty;
import org.openstreetmap.josm.tools.Geometry;

public class DefaultGeoProperty
implements GeoProperty<Boolean> {
    private final Area area;

    public DefaultGeoProperty(Collection<Way> ways) {
        Path2D.Double path = new Path2D.Double();
        path.setWindingRule(0);
        for (Way w : ways) {
            Geometry.buildPath2DLatLon(w.getNodes(), path);
        }
        this.area = new Area(path);
    }

    public DefaultGeoProperty(Relation multipolygon) {
        this.area = Geometry.getAreaLatLon(multipolygon);
    }

    @Override
    public Boolean get(LatLon ll) {
        return this.area.contains(ll.lon(), ll.lat());
    }

    @Override
    public Boolean get(BBox box) {
        Area abox = new Area(box.toRectangle());
        Geometry.PolygonIntersection is = Geometry.polygonIntersection(abox, this.area, 1.0E-10);
        switch (is) {
            case FIRST_INSIDE_SECOND: {
                return Boolean.TRUE;
            }
            case OUTSIDE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public final Area getArea() {
        return this.area;
    }
}

