/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.JceSecurity;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class Mac
implements Cloneable {
    private static final Debug debug = Debug.getInstance("jca", "Mac");
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("mac");
    private Provider provider;
    private MacSpi spi;
    private final String algorithm;
    private boolean initialized = false;
    private Provider.Service firstService;
    private Iterator<Provider.Service> serviceIterator;
    private final Object lock;
    private static int warnCount = 10;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.spi = macSpi;
        this.provider = provider;
        this.algorithm = string;
        this.serviceIterator = null;
        this.lock = null;
    }

    private Mac(Provider.Service service, Iterator<Provider.Service> iterator, String string) {
        this.firstService = service;
        this.serviceIterator = iterator;
        this.algorithm = string;
        this.lock = new Object();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices("Mac", string);
        Iterator<Provider.Service> iterator = list.iterator();
        while (iterator.hasNext()) {
            Provider.Service service = iterator.next();
            if (!JceSecurity.canUseProvider(service.getProvider())) continue;
            return new Mac(service, iterator, string);
        }
        throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = JceSecurity.getInstance("Mac", MacSpi.class, string, string2);
        return new Mac((MacSpi)instance.impl, instance.provider, string);
    }

    public static final Mac getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = JceSecurity.getInstance("Mac", MacSpi.class, string, provider);
        return new Mac((MacSpi)instance.impl, instance.provider, string);
    }

    void chooseFirstProvider() {
        if (this.spi != null || this.serviceIterator == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            int n;
            if (this.spi != null) {
                return;
            }
            if (debug != null && (n = --warnCount) >= 0) {
                debug.println("Mac.init() not first method called, disabling delayed provider selection");
                if (n == 0) {
                    debug.println("Further warnings of this type will be suppressed");
                }
                new Exception("Call trace").printStackTrace();
            }
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                if (this.firstService != null) {
                    object2 = this.firstService;
                    this.firstService = null;
                } else {
                    object2 = this.serviceIterator.next();
                }
                if (!JceSecurity.canUseProvider(((Provider.Service)object2).getProvider())) continue;
                try {
                    Object object3 = ((Provider.Service)object2).newInstance(null);
                    if (!(object3 instanceof MacSpi)) continue;
                    this.spi = (MacSpi)object3;
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.firstService = null;
                    this.serviceIterator = null;
                    return;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    noSuchAlgorithmException = noSuchAlgorithmException2;
                }
            }
            object2 = new ProviderException("Could not construct MacSpi instance");
            if (noSuchAlgorithmException != null) {
                ((Throwable)object2).initCause(noSuchAlgorithmException);
            }
            throw object2;
        }
    }

    private void chooseProvider(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (this.spi != null) {
                this.spi.engineInit(key, algorithmParameterSpec);
                return;
            }
            Exception exception = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                if (this.firstService != null) {
                    object2 = this.firstService;
                    this.firstService = null;
                } else {
                    object2 = this.serviceIterator.next();
                }
                if (!((Provider.Service)object2).supportsParameter(key) || !JceSecurity.canUseProvider(((Provider.Service)object2).getProvider())) continue;
                try {
                    MacSpi macSpi = (MacSpi)((Provider.Service)object2).newInstance(null);
                    macSpi.engineInit(key, algorithmParameterSpec);
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.spi = macSpi;
                    this.firstService = null;
                    this.serviceIterator = null;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            if (exception instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            object2 = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception);
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return this.provider;
    }

    public final int getMacLength() {
        this.chooseFirstProvider();
        return this.spi.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            if (this.spi != null) {
                this.spi.engineInit(key, null);
            } else {
                this.chooseProvider(key, null);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
        this.initialized = true;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Mac." + this.algorithm + " algorithm from: " + this.provider.getName());
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.spi != null) {
            this.spi.engineInit(key, algorithmParameterSpec);
        } else {
            this.chooseProvider(key, algorithmParameterSpec);
        }
        this.initialized = true;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Mac." + this.algorithm + " algorithm from: " + this.provider.getName());
        }
    }

    public final void update(byte by) throws IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.spi.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            this.spi.engineUpdate(byArray, 0, byArray.length);
        }
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            if (n < 0 || n2 > byArray.length - n || n2 < 0) {
                throw new IllegalArgumentException("Bad arguments");
            }
            this.spi.engineUpdate(byArray, n, n2);
        }
    }

    public final void update(ByteBuffer byteBuffer) {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Buffer must not be null");
        }
        this.spi.engineUpdate(byteBuffer);
    }

    public final byte[] doFinal() throws IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        byte[] byArray = this.spi.engineDoFinal();
        this.spi.engineReset();
        return byArray;
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        int n2 = this.getMacLength();
        if (byArray == null || byArray.length - n < n2) {
            throw new ShortBufferException("Cannot store MAC in output buffer");
        }
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        this.chooseFirstProvider();
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.update(byArray);
        return this.doFinal();
    }

    public final void reset() {
        this.chooseFirstProvider();
        this.spi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        this.chooseFirstProvider();
        Mac mac = (Mac)super.clone();
        mac.spi = (MacSpi)this.spi.clone();
        return mac;
    }
}

