/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class HTTPMUSocket {
    private InetSocketAddress ssdpMultiGroup = null;
    private MulticastSocket ssdpMultiSock = null;
    private NetworkInterface ssdpMultiIf = null;

    public HTTPMUSocket() {
    }

    public HTTPMUSocket(String addr, int port, String bindAddr) {
        this.open(addr, port, bindAddr);
    }

    protected void finalize() {
        this.close();
    }

    public String getLocalAddress() {
        if (this.ssdpMultiGroup == null || this.ssdpMultiIf == null) {
            return "";
        }
        InetAddress mcastAddr = this.ssdpMultiGroup.getAddress();
        Enumeration<InetAddress> addrs = this.ssdpMultiIf.getInetAddresses();
        while (addrs.hasMoreElements()) {
            InetAddress addr = addrs.nextElement();
            if (mcastAddr instanceof Inet6Address && addr instanceof Inet6Address) {
                return addr.getHostAddress();
            }
            if (!(mcastAddr instanceof Inet4Address) || !(addr instanceof Inet4Address)) continue;
            return addr.getHostAddress();
        }
        return "";
    }

    public int getMulticastPort() {
        return this.ssdpMultiGroup.getPort();
    }

    public int getLocalPort() {
        return this.ssdpMultiSock.getLocalPort();
    }

    public MulticastSocket getSocket() {
        return this.ssdpMultiSock;
    }

    public InetAddress getMulticastInetAddress() {
        return this.ssdpMultiGroup.getAddress();
    }

    public String getMulticastAddress() {
        return this.getMulticastInetAddress().getHostAddress();
    }

    public boolean open(String addr, int port, InetAddress bindAddr) {
        try {
            this.ssdpMultiSock = new MulticastSocket(null);
            this.ssdpMultiSock.setReuseAddress(true);
            InetSocketAddress bindSockAddr = new InetSocketAddress(port);
            this.ssdpMultiSock.bind(bindSockAddr);
            this.ssdpMultiGroup = new InetSocketAddress(InetAddress.getByName(addr), port);
            this.ssdpMultiIf = NetworkInterface.getByInetAddress(bindAddr);
            this.ssdpMultiSock.joinGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean open(String addr, int port, String bindAddr) {
        try {
            return this.open(addr, port, InetAddress.getByName(bindAddr));
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
    }

    public boolean close() {
        if (this.ssdpMultiSock == null) {
            return true;
        }
        try {
            this.ssdpMultiSock.leaveGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
            this.ssdpMultiSock.close();
            this.ssdpMultiSock = null;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(String msg, String bindAddr, int bindPort) {
        try (MulticastSocket msock = null;){
            if (bindAddr != null && 0 < bindPort) {
                msock = new MulticastSocket(null);
                msock.bind(new InetSocketAddress(bindAddr, bindPort));
            } else {
                msock = new MulticastSocket();
            }
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), this.ssdpMultiGroup);
            msock.setTimeToLive(UPnP.getTimeToLive());
            msock.send(dgmPacket);
        }
        return true;
    }

    public boolean send(String msg) {
        return this.send(msg, null, -1);
    }

    public boolean post(HTTPRequest req, String bindAddr, int bindPort) {
        return this.send(req.toString(), bindAddr, bindPort);
    }

    public boolean post(HTTPRequest req) {
        return this.send(req.toString(), null, -1);
    }

    public SSDPPacket receive() throws IOException {
        byte[] ssdvRecvBuf = new byte[1024];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        if (this.ssdpMultiSock == null) {
            throw new IOException("Multicast socket has already been closed.");
        }
        this.ssdpMultiSock.receive(recvPacket.getDatagramPacket());
        recvPacket.setTimeStamp(System.currentTimeMillis());
        return recvPacket;
    }
}

