/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.io.File;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class ProjectArtifactResolver
implements ArtifactResolver {
    private final ProjectStateRegistry projectStateRegistry;

    public ProjectArtifactResolver(ProjectStateRegistry projectStateRegistry) {
        this.projectStateRegistry = projectStateRegistry;
    }

    @Override
    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactResolveResult result) {
        LocalComponentArtifactMetadata projectArtifact = (LocalComponentArtifactMetadata)artifact;
        ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)artifact.getComponentId();
        File localArtifactFile = (File)this.projectStateRegistry.stateFor(projectId).fromMutableState(p -> projectArtifact.getFile());
        if (localArtifactFile != null) {
            result.resolved(localArtifactFile);
        } else {
            result.notFound(projectArtifact.getId());
        }
    }
}

