/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class DefaultClasspathTransformerCacheFactory
implements ClasspathTransformerCacheFactory {
    private static final CacheVersionMapping CACHE_VERSION_MAPPING = CacheVersionMapping.introducedIn((String)"3.1-rc-1").incrementedIn("3.2-rc-1").incrementedIn("3.5-rc-1").changedTo(8, "6.5-rc-1").build();
    @VisibleForTesting
    static final String CACHE_NAME = "jars";
    @VisibleForTesting
    static final String CACHE_KEY = "jars-" + CACHE_VERSION_MAPPING.getLatestVersion();
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final File cacheDir;
    private final UsedGradleVersions usedGradleVersions;

    public DefaultClasspathTransformerCacheFactory(CacheScopeMapping cacheScopeMapping, UsedGradleVersions usedGradleVersions) {
        this.cacheDir = cacheScopeMapping.getBaseDirectory(null, CACHE_KEY, VersionStrategy.SharedCache);
        this.usedGradleVersions = usedGradleVersions;
    }

    @Override
    public PersistentCache createCache(CacheRepository cacheRepository, FileAccessTimeJournal fileAccessTimeJournal) {
        return cacheRepository.cache(this.cacheDir).withDisplayName(CACHE_NAME).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).withCleanup((CleanupAction)CompositeCleanupAction.builder().add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CACHE_NAME, (CacheVersionMapping)CACHE_VERSION_MAPPING, (UsedGradleVersions)this.usedGradleVersions)}).add(new CleanupAction[]{new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), fileAccessTimeJournal, 7L)}).build()).open();
    }

    @Override
    public FileAccessTracker createFileAccessTracker(FileAccessTimeJournal fileAccessTimeJournal) {
        return new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.cacheDir, 1);
    }
}

