;;; -*- Gerbil -*-
;;; (c) vyzo at hackzen.org
;;; SRFI-101: Purely Functional Random-Access Pairs and Lists

(import :gerbil/gambit/bits
        :std/srfi/1)
(export
  (rename: ra:quote rquote)
  (rename: ra:pair? rpair?)
  (rename: ra:cons rcons)
  (rename: ra:car rcar)
  (rename: ra:cdr rcdr)
  (rename: ra:caar rcaar)
  (rename: ra:cadr rcadr)
  (rename: ra:cddr rcddr)
  (rename: ra:cdar rcdar)
  (rename: ra:caaar rcaaar)
  (rename: ra:caadr rcaadr)
  (rename: ra:caddr rcaddr)
  (rename: ra:cadar rcadar)
  (rename: ra:cdaar rcdaar)
  (rename: ra:cdadr rcdadr)
  (rename: ra:cdddr rcdddr)
  (rename: ra:cddar rcddar)
  (rename: ra:caaaar rcaaaar)
  (rename: ra:caaadr rcaaadr)
  (rename: ra:caaddr rcaaddr)
  (rename: ra:caadar rcaadar)
  (rename: ra:cadaar rcadaar)
  (rename: ra:cadadr rcadadr)
  (rename: ra:cadddr rcadddr)
  (rename: ra:caddar rcaddar)
  (rename: ra:cdaaar rcdaaar)
  (rename: ra:cdaadr rcdaadr)
  (rename: ra:cdaddr rcdaddr)
  (rename: ra:cdadar rcdadar)
  (rename: ra:cddaar rcddaar)
  (rename: ra:cddadr rcddadr)
  (rename: ra:cddddr rcddddr)
  (rename: ra:cdddar rcdddar)
  (rename: ra:null? rnull?)
  (rename: ra:list? rlist?)
  (rename: ra:list rlist)
  (rename: ra:make-list make-rlist)
  (rename: ra:length rlength)
  (rename: ra:append rappend)
  (rename: ra:reverse rreverse)
  (rename: ra:list-tail rlist-tail)
  (rename: ra:list-ref rlist-ref)
  (rename: ra:list-set rlist-set)
  (rename: ra:list-ref/update rlist-ref/update)
  (rename: ra:map rmap)
  (rename: ra:for-each rfor-each)
  (rename: ra:random-access-list->linear-access-list rlist->list)
  (rename: ra:linear-access-list->random-access-list list->rlist))

(defalias make-eq-hashtable make-hash-table-eq)
(defalias hashtable-ref hash-ref)
(defalias hashtable-set! hash-put!)
(defalias bitwise-arithmetic-shift arithmetic-shift)

(defrules assert ()
  ((_ e) (unless e (error "assertion failure" 'e))))

(include "srfi-101.scm")