/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.resources.ResourceManager;

public class FatherDetailPanel
extends ColopediaGameObjectTypePanel<FoundingFather> {
    public FatherDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.FATHERS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        Specification spec = this.getSpecification();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put(fatherType, new ArrayList());
        }
        for (FoundingFather foundingFather : spec.getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        ImageIcon icon = new ImageIcon(ImageLibrary.getMiscImage("image.icon.model.goods.bells", ImageLibrary.ICON_SIZE));
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            String id = FoundingFather.getTypeKey(fatherType);
            String typeName = Messages.message(id);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, typeName, null));
            parent.add(node);
            for (FoundingFather father : (List)fathersByType.get((Object)fatherType)) {
                node.add(this.buildItem(father, icon));
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        try {
            FoundingFather father = this.getSpecification().getFoundingFather(id);
            this.buildDetail(father, panel);
        }
        catch (IllegalArgumentException e) {
            panel.setLayout(new MigLayout("wrap 1, align center", "align center"));
            if (this.getId().equals(id)) {
                JLabel header = Utility.localizedHeaderLabel(Messages.nameKey(id), 10, FontLibrary.FontSize.SMALL);
                panel.add((Component)header, "align center, wrap 20");
                panel.add(Utility.localizedTextArea("colopedia.foundingFather.description", 40));
            }
            JLabel header = Utility.localizedHeaderLabel(Messages.message(id), 10, FontLibrary.FontSize.SMALL);
            panel.add((Component)header, "align center, wrap 20");
            BufferedImage image = ResourceManager.getImage("image.flavor." + id);
            panel.add(new JLabel(new ImageIcon(image)));
        }
    }

    public void buildDetail(FoundingFather father, JPanel panel) {
        panel.setLayout(new MigLayout("wrap 2, fillx, gapx 20", "", ""));
        String name = Messages.getName(father);
        String type = Messages.message(father.getTypeKey());
        String text = name + " (" + type + ")";
        JLabel header = new JLabel(text);
        header.setFont(FontLibrary.createCompatibleFont(text, FontLibrary.FontType.HEADER, FontLibrary.FontSize.SMALL));
        BufferedImage image = ImageLibrary.getFoundingFatherImage(father, false);
        JLabel label = new JLabel(new ImageIcon(image));
        StringTemplate template = StringTemplate.label("").add(Messages.descriptionKey(father)).addName("\n\n[").add(father.getId() + ".birthAndDeath").addName("] ").add(father.getId() + ".text");
        Turn turn = this.getMyPlayer().getElectionTurns().get(name);
        if (turn != null) {
            template.addName("\n\n").add("report.continentalCongress.elected").addName(" ").addStringTemplate(turn.getLabel());
        }
        panel.add((Component)header, "span, align center, wrap 40");
        panel.add((Component)label, "top");
        JTextArea description = Utility.localizedTextArea(template, 20);
        panel.add((Component)description, "top, growx");
        Dimension hSize = header.getPreferredSize();
        Dimension lSize = label.getPreferredSize();
        Dimension dSize = description.getPreferredSize();
        Dimension size = new Dimension();
        size.setSize(lSize.getWidth() + dSize.getWidth() + 20.0, hSize.getHeight() + lSize.getHeight() + 10.0);
        panel.setPreferredSize(size);
    }
}

