/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnchorTagHandler
extends DefaultHandler {
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    private Vector<DocTagContent> tagsContent = new Vector();
    private DocTagContent currentScriptTag = null;
    private boolean scriptReading = false;
    private Locator locator;
    private HashMap<String, Integer> prefixes = new HashMap();

    public Vector<DocTagContent> getHrefAttributesValues() {
        return this.tagsContent;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void endDocument() {
        this.prefixes.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int imageIndex;
        if (qName.compareToIgnoreCase("script") == 0) {
            this.scriptReading = true;
            this.currentScriptTag = new DocTagContent();
            this.currentScriptTag.setLine(this.locator.getLineNumber());
            this.currentScriptTag.setColumn(this.locator.getColumnNumber());
            this.currentScriptTag.setType("script");
            this.currentScriptTag.setContext("script");
            this.tagsContent.add(this.currentScriptTag);
        }
        if (qName.compareToIgnoreCase("html") == 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (!attrName.startsWith("xmlns:") || attrValue.compareToIgnoreCase(MATH_ML_NAMESPACE) != 0) continue;
                String prefix = attrName.substring("xmlns:".length());
                this.startPrefixMapping(prefix, attrValue);
            }
        } else if (qName.compareToIgnoreCase("A") == 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrName.compareToIgnoreCase("href") != 0) continue;
                DocTagContent sa = new DocTagContent();
                sa.setValue(attrValue);
                sa.setType("A");
                sa.setLine(this.locator.getLineNumber());
                sa.setColumn(this.locator.getColumnNumber());
                sa.setContext("href");
                this.tagsContent.add(sa);
            }
        } else if (qName.compareToIgnoreCase("iframe") == 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrName.compareToIgnoreCase("src") != 0) continue;
                DocTagContent sa = new DocTagContent();
                sa.setValue(attrValue);
                sa.setType("iframe:src");
                sa.setLine(this.locator.getLineNumber());
                sa.setColumn(this.locator.getColumnNumber());
                sa.setContext("src");
                this.tagsContent.add(sa);
            }
        } else if (qName.compareToIgnoreCase("img") == 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrName.compareToIgnoreCase("src") != 0) continue;
                DocTagContent sa = new DocTagContent();
                sa.setValue(attrValue);
                sa.setType("img");
                sa.setLine(this.locator.getLineNumber());
                sa.setColumn(this.locator.getColumnNumber());
                sa.setContext("img");
                this.tagsContent.add(sa);
            }
        } else if (this.isMath(qName) && (imageIndex = attributes.getIndex("altimg")) >= 0) {
            String attrValue = attributes.getValue(imageIndex);
            DocTagContent sa = new DocTagContent();
            sa.setValue(attrValue);
            sa.setType("altimg");
            sa.setLine(this.locator.getLineNumber());
            sa.setColumn(this.locator.getColumnNumber());
            sa.setContext("altimg");
            this.tagsContent.add(sa);
        }
    }

    private boolean isMath(String qName) {
        return this.prefixes.containsKey(qName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (uri.compareToIgnoreCase(MATH_ML_NAMESPACE) == 0) {
            Integer count = this.prefixes.get(prefix = prefix + ":math");
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.prefixes.put(prefix, count);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        Integer count = this.prefixes.get(prefix = prefix + ":math");
        if (count != null) {
            count = count - 1;
            this.prefixes.put(prefix, count);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.scriptReading) {
            this.currentScriptTag.value = new String(ch, start, length);
            this.tagsContent.add(this.currentScriptTag);
            this.scriptReading = false;
        }
    }

    public class DocTagContent {
        String type;
        int line;
        int column;
        String context = "";
        String value = "";

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public String getContext() {
            return this.context;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

