export default class PlatformFontsWidget extends UI.ThrottledWidget{constructor(sharedModel){super(true);this.registerRequiredCSS('elements/platformFontsWidget.css');this._sharedModel=sharedModel;this._sharedModel.addEventListener(Elements.ComputedStyleModel.Events.ComputedStyleChanged,this.update,this);this._sectionTitle=createElementWithClass('div','title');this.contentElement.classList.add('platform-fonts');this.contentElement.appendChild(this._sectionTitle);this._sectionTitle.textContent=Common.UIString('Rendered Fonts');this._fontStatsSection=this.contentElement.createChild('div','stats-section');}
doUpdate(){const cssModel=this._sharedModel.cssModel();const node=this._sharedModel.node();if(!node||!cssModel){return Promise.resolve();}
return cssModel.platformFontsPromise(node.id).then(this._refreshUI.bind(this,node));}
_refreshUI(node,platformFonts){if(this._sharedModel.node()!==node){return;}
this._fontStatsSection.removeChildren();const isEmptySection=!platformFonts||!platformFonts.length;this._sectionTitle.classList.toggle('hidden',isEmptySection);if(isEmptySection){return;}
platformFonts.sort(function(a,b){return b.glyphCount-a.glyphCount;});for(let i=0;i<platformFonts.length;++i){const fontStatElement=this._fontStatsSection.createChild('div','font-stats-item');const fontNameElement=fontStatElement.createChild('span','font-name');fontNameElement.textContent=platformFonts[i].familyName;const fontDelimeterElement=fontStatElement.createChild('span','font-delimeter');fontDelimeterElement.textContent='\u2014';const fontOrigin=fontStatElement.createChild('span');fontOrigin.textContent=platformFonts[i].isCustomFont?Common.UIString('Network resource'):Common.UIString('Local file');const fontUsageElement=fontStatElement.createChild('span','font-usage');const usage=platformFonts[i].glyphCount;fontUsageElement.textContent=usage===1?Common.UIString('(%d glyph)',usage):Common.UIString('(%d glyphs)',usage);}}}
self.Elements=self.Elements||{};Elements=Elements||{};Elements.PlatformFontsWidget=PlatformFontsWidget;