/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class SortProcessor
extends AbstractProcessor {
    public static final String TYPE = "sort";
    public static final String FIELD = "field";
    public static final String ORDER = "order";
    public static final String DEFAULT_ORDER = "asc";
    private final String field;
    private final SortOrder order;
    private final String targetField;

    SortProcessor(String tag, String description, String field, SortOrder order, String targetField) {
        super(tag, description);
        this.field = field;
        this.order = order;
        this.targetField = targetField;
    }

    String getField() {
        return this.field;
    }

    SortOrder getOrder() {
        return this.order;
    }

    String getTargetField() {
        return this.targetField;
    }

    public IngestDocument execute(IngestDocument document) {
        List list = (List)document.getFieldValue(this.field, List.class);
        if (list == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot sort.");
        }
        ArrayList copy = new ArrayList(list);
        if (this.order.equals((Object)SortOrder.ASCENDING)) {
            Collections.sort(copy);
        } else {
            Collections.sort(copy, Collections.reverseOrder());
        }
        document.setFieldValue(this.targetField, copy);
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static enum SortOrder {
        ASCENDING("asc"),
        DESCENDING("desc");

        private final String direction;

        private SortOrder(String direction) {
            this.direction = direction;
        }

        public String toString() {
            return this.direction;
        }

        public static SortOrder fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Sort direction cannot be null");
            }
            if (value.equals(ASCENDING.toString())) {
                return ASCENDING;
            }
            if (value.equals(DESCENDING.toString())) {
                return DESCENDING;
            }
            throw new IllegalArgumentException("Sort direction [" + value + "] not recognized. Valid values are: [asc, desc]");
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public SortProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)SortProcessor.TYPE, (String)processorTag, config, (String)SortProcessor.FIELD);
            String targetField = ConfigurationUtils.readStringProperty((String)SortProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)field);
            try {
                SortOrder direction = SortOrder.fromString(ConfigurationUtils.readStringProperty((String)SortProcessor.TYPE, (String)processorTag, config, (String)SortProcessor.ORDER, (String)SortProcessor.DEFAULT_ORDER));
                return new SortProcessor(processorTag, description, field, direction, targetField);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)SortProcessor.TYPE, (String)processorTag, (String)SortProcessor.ORDER, (String)e.getMessage());
            }
        }
    }
}

