/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import com.googlecode.d2j.tools.jar.ClassInfo;
import com.googlecode.d2j.util.AccUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ScanBridgeAdapter
extends ClassVisitor
implements Opcodes {
    private Map<String, ClassInfo.MemberInfo> bridge = new HashMap<String, ClassInfo.MemberInfo>();

    public ScanBridgeAdapter(ClassVisitor cv) {
        super(262144, cv);
    }

    public Map<String, ClassInfo.MemberInfo> getBridge() {
        return Collections.unmodifiableMap(this.bridge);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (AccUtils.isBridge(access) && AccUtils.isSynthetic(access)) {
            if (mv == null) {
                mv = new MethodVisitor(262144){};
            }
            final ClassInfo.MemberInfo member = new ClassInfo.MemberInfo();
            member.access = access;
            member.desc = desc;
            member.name = name;
            mv = new MethodVisitor(262144, mv){

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                    if (!name.equals(member.name)) {
                        ScanBridgeAdapter.this.bridge.put(String.valueOf(owner) + '.' + name + desc.substring(0, desc.lastIndexOf(41) + 1), member);
                    }
                }
            };
        }
        return mv;
    }
}

