/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.util;

import com.intellij.ide.BrowserUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;

public class HTMLViewer
extends JEditorPane {
    private static final HyperlinkListener DEFAULT_LISTENER = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            BrowserUtil.launchBrowser((String)e.getURL().toExternalForm());
        }
    };
    private boolean myAutoStyleEnabled = false;
    private final Font myFont = UIManager.getFont("Label.font");
    private final int myColumns = 45;
    private Map<String, HyperlinkListener> myListeners;

    public HTMLViewer(String htmlContent) {
        this(htmlContent, false);
    }

    public HTMLViewer(String htmlContent, boolean autoStyleEnabled) {
        this();
        this.setAutoStyleEnabled(autoStyleEnabled);
        this.setText(htmlContent);
    }

    public HTMLViewer() {
        assert (this.myFont != null);
        this.setEditable(false);
        this.setFocusable(true);
        this.setBorder(null);
        this.setContentType("text/html");
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                    HyperlinkListener listener = null;
                    Map listeners = HTMLViewer.this.myListeners;
                    if (listeners != null) {
                        listener = (HyperlinkListener)listeners.get(e.getURL().toExternalForm());
                    }
                    if (listener == null) {
                        listener = DEFAULT_LISTENER;
                    }
                    listener.hyperlinkUpdate(e);
                }
            }
        });
    }

    public void addHyperlinkListener(String url, HyperlinkListener listener) {
        HyperlinkListener old;
        if (this.myListeners == null) {
            this.myListeners = new HashMap<String, HyperlinkListener>();
        }
        if ((old = this.myListeners.put(url, listener)) != null) assert (false) : old + " " + listener;
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.myFont);
        int w = fontMetrics.charWidth('m') * 45;
        if (preferredSize.width > w) {
            return new Dimension(w, preferredSize.height);
        }
        return preferredSize;
    }

    public void setAutoStyleEnabled(boolean autoStyleEnabled) {
        this.myAutoStyleEnabled = autoStyleEnabled;
    }

    public void setText(String t) {
        if (this.myAutoStyleEnabled) {
            t = this.autoStyle(t);
        }
        super.setText(t);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HTMLViewer.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    private String autoStyle(@NonNls String t) {
        String styleBlock = "<head><style>\nbody {margin:2px; font-family: " + this.myFont.getFamily() + "; font-size: " + this.myFont.getSize() + "pt; }\n" + "</style></head>";
        t = t.toLowerCase().startsWith("<html>") ? t.substring(0, 6) + styleBlock + t.substring(6) : "<html>" + styleBlock + t;
        return t;
    }
}

