/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.util.Collection;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.ByteArraySet;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.RawParseUtils;

public class PathFilterGroup {
    public static TreeFilter createFromStrings(Collection<String> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        int i = 0;
        for (String s : paths) {
            p[i++] = PathFilter.create(s);
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter createFromStrings(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        int length = paths.length;
        PathFilter[] p = new PathFilter[length];
        for (int i = 0; i < length; ++i) {
            p[i] = PathFilter.create(paths[i]);
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter create(Collection<PathFilter> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        paths.toArray(p);
        return PathFilterGroup.create(p);
    }

    private static TreeFilter create(PathFilter[] p) {
        if (p.length == 1) {
            return new Single(p[0]);
        }
        return new Group(p);
    }

    static class Group
    extends TreeFilter {
        private ByteArraySet fullpaths;
        private ByteArraySet prefixes;
        private byte[] max;

        private Group(PathFilter[] pathFilters) {
            this.fullpaths = new ByteArraySet(pathFilters.length);
            this.prefixes = new ByteArraySet(pathFilters.length / 5);
            this.max = pathFilters[0].pathRaw;
            ByteArraySet.Hasher hasher = new ByteArraySet.Hasher(null, 0);
            for (PathFilter pf : pathFilters) {
                hasher.init(pf.pathRaw, pf.pathRaw.length);
                while (hasher.hasNext()) {
                    int hash2 = hasher.nextHash();
                    if (!hasher.hasNext()) continue;
                    this.prefixes.addIfAbsent(pf.pathRaw, hasher.length(), hash2);
                }
                this.fullpaths.addIfAbsent(pf.pathRaw, pf.pathRaw.length, hasher.getHash());
                if (Group.compare(this.max, pf.pathRaw) >= 0) continue;
                this.max = pf.pathRaw;
            }
            byte[] newMax = new byte[this.max.length + 1];
            for (int i = 0; i < this.max.length; ++i) {
                newMax[i] = (this.max[i] & 0xFF) < 47 ? 47 : this.max[i];
            }
            newMax[newMax.length - 1] = 47;
            this.max = newMax;
        }

        private static int compare(byte[] a, byte[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                int ba = a[i] & 0xFF;
                int bb = b[i] & 0xFF;
                int cmp = ba - bb;
                if (cmp == 0) continue;
                return cmp;
            }
            return a.length - b.length;
        }

        @Override
        public boolean include(TreeWalk walker) {
            byte[] rp = walker.getRawPath();
            ByteArraySet.Hasher hasher = new ByteArraySet.Hasher(rp, walker.getPathLength());
            while (hasher.hasNext()) {
                int hash2 = hasher.nextHash();
                if (this.fullpaths.contains(rp, hasher.length(), hash2)) {
                    return true;
                }
                if (hasher.hasNext() || !walker.isSubtree() || !this.prefixes.contains(rp, hasher.length(), hash2)) continue;
                return true;
            }
            int cmp = walker.isPathPrefix(this.max, this.max.length);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return false;
        }

        @Override
        public boolean shouldBeRecursive() {
            return !this.prefixes.isEmpty();
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("FAST(");
            boolean first = true;
            for (byte[] p : this.fullpaths.toArray()) {
                if (!first) {
                    r.append(" OR ");
                }
                r.append(RawParseUtils.decode(p));
                first = false;
            }
            r.append(")");
            return r.toString();
        }
    }

    static class Single
    extends TreeFilter {
        private final PathFilter path;
        private final byte[] raw;

        private Single(PathFilter p) {
            this.path = p;
            this.raw = this.path.pathRaw;
        }

        @Override
        public boolean include(TreeWalk walker) {
            int cmp = walker.isPathPrefix(this.raw, this.raw.length);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return cmp == 0;
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.path.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "FAST_" + this.path.toString();
        }
    }
}

