/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.List;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.MultiplexingXXXSocketSupport;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.socket.SocketReceiveBuffer;

public class MultiplexingDatagramSocket
extends SafeCloseDatagramSocket {
    private final MultiplexingXXXSocketSupport<MultiplexedDatagramSocket> multiplexingXXXSocketSupport = new MultiplexingXXXSocketSupport<MultiplexedDatagramSocket>(MultiplexedDatagramSocket.class){

        @Override
        protected MultiplexedDatagramSocket createSocket(DatagramPacketFilter filter) throws SocketException {
            return new MultiplexedDatagramSocket(MultiplexingDatagramSocket.this, filter);
        }

        @Override
        protected void doReceive(DatagramPacket p) throws IOException {
            MultiplexingDatagramSocket.this.multiplexingXXXSocketSupportDoReceive(p);
        }

        @Override
        protected void doSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
            MultiplexingDatagramSocket.this.multiplexingXXXSocketSupportDoSetReceiveBufferSize(receiveBufferSize);
        }

        @Override
        protected List<DatagramPacket> getReceived() {
            return MultiplexingDatagramSocket.this.received;
        }

        @Override
        protected List<DatagramPacket> getReceived(MultiplexedDatagramSocket socket) {
            return socket.received;
        }
    };
    private final List<DatagramPacket> received = new SocketReceiveBuffer(){
        private static final long serialVersionUID = 3125772367019091216L;

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return MultiplexingDatagramSocket.this.getReceiveBufferSize();
        }
    };
    private int soTimeout = 0;

    public MultiplexingDatagramSocket() throws SocketException {
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public MultiplexingDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    void close(MultiplexedDatagramSocket multiplexed) {
        this.multiplexingXXXSocketSupport.close(multiplexed);
    }

    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        return this.getSocket(filter, true);
    }

    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter, boolean create) throws SocketException {
        return this.multiplexingXXXSocketSupport.getSocket(filter, create);
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    private void multiplexingXXXSocketSupportDoReceive(DatagramPacket p) throws IOException {
        super.receive(p);
    }

    private void multiplexingXXXSocketSupportDoSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
        super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.multiplexingXXXSocketSupport.receive(this.received, p, this.soTimeout);
    }

    void receive(MultiplexedDatagramSocket multiplexed, DatagramPacket p) throws IOException {
        this.multiplexingXXXSocketSupport.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        this.multiplexingXXXSocketSupport.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }
}

