/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;

public class DelegatingServerSocket
extends ServerSocket {
    protected final ServerSocketChannel channel;
    protected final ServerSocket delegate;

    public DelegatingServerSocket(ServerSocket delegate) throws IOException {
        this(delegate, delegate.getChannel());
    }

    public DelegatingServerSocket(ServerSocket delegate, ServerSocketChannel channel) throws IOException {
        this.delegate = delegate;
        this.channel = channel;
    }

    @Override
    public Socket accept() throws IOException {
        return this.delegate.accept();
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.delegate.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.delegate.bind(endpoint, backlog);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        ServerSocketChannel channel = this.channel;
        return channel == null ? this.delegate.getChannel() : channel;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

