/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarBrowser {
    public static String TABLE_NAME = "browser";
    private String name;
    private String version;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarBrowser(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public HarBrowser(String name, String version, String comment) {
        this.name = name;
        this.version = version;
        this.comment = comment;
    }

    public HarBrowser(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"browser\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("version".equals(name)) {
                this.setVersion(jp.getText());
                continue;
            }
            if ("name".equals(name)) {
                this.setName(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in browser element", jp.getCurrentLocation());
        }
        if (this.name == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing name field in browser element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing name field in browser element", jp.getCurrentLocation());
            }
        }
        if (this.version == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing version field in browser element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing version field in browser element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarBrowser(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,name,version,comment FROM " + tableName + " WHERE log_id=?");
            ps.setLong(1, logId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarBrowser for log id " + logId + " found in database");
            }
            long browserId = rs.getLong(1);
            this.setName(rs.getString(2));
            this.setVersion(rs.getString(3));
            this.setComment(rs.getString(4));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARBROWSER, browserId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("browser");
        g.writeStringField("name", this.name);
        g.writeStringField("version", this.version);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    public void writeJDBC(long logId, HarDatabaseConfig config) throws SQLException {
        long browserId = config.writeNameValueCommentJDBC(logId, config, TABLE_NAME, "name", this.name, "version", this.version, "comment", this.comment);
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARBROWSER, browserId, logId);
    }

    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        config.deleteFromTable(logId, config, "browser");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"browser\": { \"name\": \"" + this.name + "\", \"version\": \"" + this.version + "\", \"comment\": " + "\"" + this.comment + "\", " + this.customFields + " }";
    }
}

