/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.List;
import opennlp.tools.ml.model.Context;

public class ArrayMath {
    public static double innerProduct(double[] vecA, double[] vecB) {
        if (vecA == null || vecB == null || vecA.length != vecB.length) {
            return Double.NaN;
        }
        double product = 0.0;
        for (int i = 0; i < vecA.length; ++i) {
            product += vecA[i] * vecB[i];
        }
        return product;
    }

    public static double l1norm(double[] v) {
        double norm = 0.0;
        for (int i = 0; i < v.length; ++i) {
            norm += Math.abs(v[i]);
        }
        return norm;
    }

    public static double l2norm(double[] v) {
        return Math.sqrt(ArrayMath.innerProduct(v, v));
    }

    public static double invL2norm(double[] v) {
        return 1.0 / ArrayMath.l2norm(v);
    }

    public static double logSumOfExps(double[] x) {
        double max = ArrayMath.max(x);
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == Double.NEGATIVE_INFINITY) continue;
            sum += Math.exp(x[i] - max);
        }
        return max + Math.log(sum);
    }

    public static double max(double[] x) {
        int maxIdx = ArrayMath.argmax(x);
        return x[maxIdx];
    }

    public static int argmax(double[] x) {
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Vector x is null or empty");
        }
        int maxIdx = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[maxIdx] < x[i])) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static void sumFeatures(Context[] context, float[] values, double[] prior) {
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] == null) continue;
            Context predParams = context[ci];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            double value = 1.0;
            if (values != null) {
                value = values[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int oid;
                int n = oid = activeOutcomes[ai];
                prior[n] = prior[n] + activeParameters[ai] * value;
            }
        }
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] arr = new double[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }
}

