/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.UnicodeUtils;

@BuiltinFunction(value={"utf8bytelength/0"})
public class Utf8ByteLengthFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (!in.isTextual()) {
            throw JsonQueryException.format("%s (%s) only strings have UTF-8 byte length", in.getNodeType(), in);
        }
        return Collections.singletonList(IntNode.valueOf((int)UnicodeUtils.lengthUtf8(in.asText())));
    }
}

