// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _V3d_HeaderFile
#define _V3d_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <V3d_TypeOfOrientation.hxx>
#include <Handle_Graphic3d_Group.hxx>
#include <V3d_Coordinate.hxx>
#include <V3d_Parameter.hxx>
#include <Quantity_PlaneAngle.hxx>
#include <Handle_V3d_View.hxx>
#include <Handle_V3d_Viewer.hxx>
#include <Quantity_Length.hxx>
class Graphic3d_Vector;
class Graphic3d_Group;
class V3d_View;
class V3d_Viewer;
class V3d_Viewer;
class V3d_View;
class V3d_LayerMgr;
class V3d_Light;
class V3d_AmbientLight;
class V3d_PositionLight;
class V3d_PositionalLight;
class V3d_DirectionalLight;
class V3d_SpotLight;
class V3d_RectangularGrid;
class V3d_CircularGrid;
class V3d_ColorScale;
class V3d_ColorScaleLayerItem;


//! This package contains the set of commands and services
//! of the 3D Viewer. It provides a set of high level commands
//! to control the views and viewing modes. This package is
//! complementary to the Visual3D graphic package.
class V3d 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Determines the orientation vector corresponding
  //! to the predefined orientation type.
  Standard_EXPORT static   Graphic3d_Vector GetProjAxis (const V3d_TypeOfOrientation Orientation) ;
  
  //! Compute the graphic structure of arrow.
  //! X0,Y0,Z0 : coordinate of the arrow.
  //! DX,DY,DZ : Direction of the arrow.
  //! Alpha    : Angle of arrow.
  //! Lng      : Length of arrow.
  Standard_EXPORT static   void ArrowOfRadius (const Handle(Graphic3d_Group)& garrow, const V3d_Coordinate X0, const V3d_Coordinate Y0, const V3d_Coordinate Z0, const V3d_Parameter DX, const V3d_Parameter DY, const V3d_Parameter DZ, const Quantity_PlaneAngle Alpha, const V3d_Parameter Lng) ;
  
  //! Compute the graphic structure of circle.
  //! X0,Y0,Z0 : Center of circle.
  //! VX,VY,VZ : Axis of circle.
  //! Radius   : Radius of circle.
  Standard_EXPORT static   void CircleInPlane (const Handle(Graphic3d_Group)& gcircle, const V3d_Coordinate X0, const V3d_Coordinate Y0, const V3d_Coordinate Z0, const V3d_Parameter VX, const V3d_Parameter VY, const V3d_Parameter VZ, const V3d_Parameter Radius) ;
  
  Standard_EXPORT static   void SwitchViewsinWindow (const Handle(V3d_View)& aPreviousView, const Handle(V3d_View)& aNextView) ;
  
  //! test.
  Standard_EXPORT static   void DrawSphere (const Handle(V3d_Viewer)& aViewer, const Quantity_Length aRadius = 1000) ;
  
  //! test.
  Standard_EXPORT static   void PickGrid (const Handle(V3d_Viewer)& aViewer, const Quantity_Length aRadius = 1000) ;
  
  //! test.
  Standard_EXPORT static   void SetPlane (const Handle(V3d_Viewer)& aViewer, const Quantity_Length x1, const Quantity_Length y1, const Quantity_Length z1, const Quantity_Length x2, const Quantity_Length y2, const Quantity_Length z2) ;




protected:





private:




friend class V3d_Viewer;
friend class V3d_View;
friend class V3d_LayerMgr;
friend class V3d_Light;
friend class V3d_AmbientLight;
friend class V3d_PositionLight;
friend class V3d_PositionalLight;
friend class V3d_DirectionalLight;
friend class V3d_SpotLight;
friend class V3d_RectangularGrid;
friend class V3d_CircularGrid;
friend class V3d_ColorScale;
friend class V3d_ColorScaleLayerItem;

};







#endif // _V3d_HeaderFile
