/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SpvcSpecializationConstant
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int CONSTANT_ID;

    public SpvcSpecializationConstant(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcSpecializationConstant.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_constant_id")
    public int id() {
        return SpvcSpecializationConstant.nid(this.address());
    }

    @NativeType(value="unsigned int")
    public int constant_id() {
        return SpvcSpecializationConstant.nconstant_id(this.address());
    }

    public SpvcSpecializationConstant id(@NativeType(value="spvc_constant_id") int value) {
        SpvcSpecializationConstant.nid(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant constant_id(@NativeType(value="unsigned int") int value) {
        SpvcSpecializationConstant.nconstant_id(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant set(int id, int constant_id) {
        this.id(id);
        this.constant_id(constant_id);
        return this;
    }

    public SpvcSpecializationConstant set(SpvcSpecializationConstant src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcSpecializationConstant malloc() {
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcSpecializationConstant calloc() {
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcSpecializationConstant create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcSpecializationConstant create(long address) {
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)address);
    }

    @Nullable
    public static SpvcSpecializationConstant createSafe(long address) {
        return address == 0L ? null : (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcSpecializationConstant.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcSpecializationConstant.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcSpecializationConstant mallocStack() {
        return SpvcSpecializationConstant.mallocStack(MemoryStack.stackGet());
    }

    public static SpvcSpecializationConstant callocStack() {
        return SpvcSpecializationConstant.callocStack(MemoryStack.stackGet());
    }

    public static SpvcSpecializationConstant mallocStack(MemoryStack stack) {
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcSpecializationConstant callocStack(MemoryStack stack) {
        return (SpvcSpecializationConstant)SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SpvcSpecializationConstant.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SpvcSpecializationConstant.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcSpecializationConstant.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nconstant_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONSTANT_ID);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void nconstant_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONSTANT_ID, value);
    }

    static {
        Struct.Layout layout = SpvcSpecializationConstant.__struct((Struct.Member[])new Struct.Member[]{SpvcSpecializationConstant.__member((int)4), SpvcSpecializationConstant.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        CONSTANT_ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcSpecializationConstant, Buffer>
    implements NativeResource {
        private static final SpvcSpecializationConstant ELEMENT_FACTORY = SpvcSpecializationConstant.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcSpecializationConstant getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_constant_id")
        public int id() {
            return SpvcSpecializationConstant.nid(this.address());
        }

        @NativeType(value="unsigned int")
        public int constant_id() {
            return SpvcSpecializationConstant.nconstant_id(this.address());
        }

        public Buffer id(@NativeType(value="spvc_constant_id") int value) {
            SpvcSpecializationConstant.nid(this.address(), value);
            return this;
        }

        public Buffer constant_id(@NativeType(value="unsigned int") int value) {
            SpvcSpecializationConstant.nconstant_id(this.address(), value);
            return this;
        }
    }
}

