/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_limits_t")
public class BGFXInitLimits
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXENCODERS;
    public static final int TRANSIENTVBSIZE;
    public static final int TRANSIENTIBSIZE;

    public BGFXInitLimits(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXInitLimits.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short maxEncoders() {
        return BGFXInitLimits.nmaxEncoders(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientVbSize() {
        return BGFXInitLimits.ntransientVbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientIbSize() {
        return BGFXInitLimits.ntransientIbSize(this.address());
    }

    public BGFXInitLimits maxEncoders(@NativeType(value="uint16_t") short value) {
        BGFXInitLimits.nmaxEncoders(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientVbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientVbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientIbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientIbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits set(short maxEncoders, int transientVbSize, int transientIbSize) {
        this.maxEncoders(maxEncoders);
        this.transientVbSize(transientVbSize);
        this.transientIbSize(transientIbSize);
        return this;
    }

    public BGFXInitLimits set(BGFXInitLimits src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXInitLimits malloc() {
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXInitLimits calloc() {
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXInitLimits create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXInitLimits create(long address) {
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)address);
    }

    @Nullable
    public static BGFXInitLimits createSafe(long address) {
        return address == 0L ? null : (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)address);
    }

    public static BGFXInitLimits mallocStack() {
        return BGFXInitLimits.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXInitLimits callocStack() {
        return BGFXInitLimits.callocStack(MemoryStack.stackGet());
    }

    public static BGFXInitLimits mallocStack(MemoryStack stack) {
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInitLimits callocStack(MemoryStack stack) {
        return (BGFXInitLimits)BGFXInitLimits.wrap(BGFXInitLimits.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static short nmaxEncoders(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAXENCODERS);
    }

    public static int ntransientVbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTVBSIZE);
    }

    public static int ntransientIbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTIBSIZE);
    }

    public static void nmaxEncoders(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAXENCODERS, value);
    }

    public static void ntransientVbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTVBSIZE, value);
    }

    public static void ntransientIbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTIBSIZE, value);
    }

    static {
        Struct.Layout layout = BGFXInitLimits.__struct((Struct.Member[])new Struct.Member[]{BGFXInitLimits.__member((int)2), BGFXInitLimits.__member((int)4), BGFXInitLimits.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXENCODERS = layout.offsetof(0);
        TRANSIENTVBSIZE = layout.offsetof(1);
        TRANSIENTIBSIZE = layout.offsetof(2);
    }
}

