/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationFlagsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DISABLEDVALIDATIONCHECKCOUNT;
    public static final int PDISABLEDVALIDATIONCHECKS;

    public VkValidationFlagsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkValidationFlagsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkValidationFlagsEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkValidationFlagsEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int disabledValidationCheckCount() {
        return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
    }

    @NativeType(value="VkValidationCheckEXT const *")
    public IntBuffer pDisabledValidationChecks() {
        return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
    }

    public VkValidationFlagsEXT sType(@NativeType(value="VkStructureType") int value) {
        VkValidationFlagsEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT pNext(@NativeType(value="void const *") long value) {
        VkValidationFlagsEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT pDisabledValidationChecks(@NativeType(value="VkValidationCheckEXT const *") IntBuffer value) {
        VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT set(int sType, long pNext, IntBuffer pDisabledValidationChecks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDisabledValidationChecks(pDisabledValidationChecks);
        return this;
    }

    public VkValidationFlagsEXT set(VkValidationFlagsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkValidationFlagsEXT malloc() {
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkValidationFlagsEXT calloc() {
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkValidationFlagsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkValidationFlagsEXT create(long address) {
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)address);
    }

    @Nullable
    public static VkValidationFlagsEXT createSafe(long address) {
        return address == 0L ? null : (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkValidationFlagsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkValidationFlagsEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkValidationFlagsEXT mallocStack() {
        return VkValidationFlagsEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkValidationFlagsEXT callocStack() {
        return VkValidationFlagsEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkValidationFlagsEXT mallocStack(MemoryStack stack) {
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkValidationFlagsEXT callocStack(MemoryStack stack) {
        return (VkValidationFlagsEXT)VkValidationFlagsEXT.wrap(VkValidationFlagsEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkValidationFlagsEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkValidationFlagsEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkValidationFlagsEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndisabledValidationCheckCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISABLEDVALIDATIONCHECKCOUNT);
    }

    public static IntBuffer npDisabledValidationChecks(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PDISABLEDVALIDATIONCHECKS)), (int)VkValidationFlagsEXT.ndisabledValidationCheckCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndisabledValidationCheckCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISABLEDVALIDATIONCHECKCOUNT, value);
    }

    public static void npDisabledValidationChecks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDISABLEDVALIDATIONCHECKS), (long)MemoryUtil.memAddress((IntBuffer)value));
        VkValidationFlagsEXT.ndisabledValidationCheckCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDISABLEDVALIDATIONCHECKS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkValidationFlagsEXT.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkValidationFlagsEXT.__struct((Struct.Member[])new Struct.Member[]{VkValidationFlagsEXT.__member((int)4), VkValidationFlagsEXT.__member((int)POINTER_SIZE), VkValidationFlagsEXT.__member((int)4), VkValidationFlagsEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DISABLEDVALIDATIONCHECKCOUNT = layout.offsetof(2);
        PDISABLEDVALIDATIONCHECKS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkValidationFlagsEXT, Buffer>
    implements NativeResource {
        private static final VkValidationFlagsEXT ELEMENT_FACTORY = VkValidationFlagsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkValidationFlagsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkValidationFlagsEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkValidationFlagsEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int disabledValidationCheckCount() {
            return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
        }

        @NativeType(value="VkValidationCheckEXT const *")
        public IntBuffer pDisabledValidationChecks() {
            return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkValidationFlagsEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkValidationFlagsEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pDisabledValidationChecks(@NativeType(value="VkValidationCheckEXT const *") IntBuffer value) {
            VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
            return this;
        }
    }
}

