/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseMemoryBind;

public class VkSparseImageOpaqueMemoryBindInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    public VkSparseImageOpaqueMemoryBindInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSparseImageOpaqueMemoryBindInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkSparseImageOpaqueMemoryBindInfo.nimage(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseImageOpaqueMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseMemoryBind const *")
    public VkSparseMemoryBind.Buffer pBinds() {
        return VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseImageOpaqueMemoryBindInfo image(@NativeType(value="VkImage") long value) {
        VkSparseImageOpaqueMemoryBindInfo.nimage(this.address(), value);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
        VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo set(long image, VkSparseMemoryBind.Buffer pBinds) {
        this.image(image);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseImageOpaqueMemoryBindInfo set(VkSparseImageOpaqueMemoryBindInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSparseImageOpaqueMemoryBindInfo malloc() {
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo calloc() {
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSparseImageOpaqueMemoryBindInfo create(long address) {
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)address);
    }

    @Nullable
    public static VkSparseImageOpaqueMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSparseImageOpaqueMemoryBindInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageOpaqueMemoryBindInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSparseImageOpaqueMemoryBindInfo mallocStack() {
        return VkSparseImageOpaqueMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageOpaqueMemoryBindInfo callocStack() {
        return VkSparseImageOpaqueMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageOpaqueMemoryBindInfo mallocStack(MemoryStack stack) {
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageOpaqueMemoryBindInfo callocStack(MemoryStack stack) {
        return (VkSparseImageOpaqueMemoryBindInfo)VkSparseImageOpaqueMemoryBindInfo.wrap(VkSparseImageOpaqueMemoryBindInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageOpaqueMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageOpaqueMemoryBindInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static int nbindCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDCOUNT);
    }

    public static VkSparseMemoryBind.Buffer npBinds(long struct) {
        return VkSparseMemoryBind.create(MemoryUtil.memGetAddress((long)(struct + (long)PBINDS)), VkSparseImageOpaqueMemoryBindInfo.nbindCount(struct));
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    public static void nbindCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBINDS), (long)value.address());
        VkSparseImageOpaqueMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PBINDS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseImageOpaqueMemoryBindInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSparseImageOpaqueMemoryBindInfo.__struct((Struct.Member[])new Struct.Member[]{VkSparseImageOpaqueMemoryBindInfo.__member((int)8), VkSparseImageOpaqueMemoryBindInfo.__member((int)4), VkSparseImageOpaqueMemoryBindInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageOpaqueMemoryBindInfo, Buffer>
    implements NativeResource {
        private static final VkSparseImageOpaqueMemoryBindInfo ELEMENT_FACTORY = VkSparseImageOpaqueMemoryBindInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSparseImageOpaqueMemoryBindInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkSparseImageOpaqueMemoryBindInfo.nimage(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseImageOpaqueMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseMemoryBind const *")
        public VkSparseMemoryBind.Buffer pBinds() {
            return VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkSparseImageOpaqueMemoryBindInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
            VkSparseImageOpaqueMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

